/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.system.ExternalApplication;
import agorum.roi.statistic.RoiCheckSuite;
import java.util.Map;

public class ToolAvailabilityCheck
extends RoiCheckSuite {
    private static final ToolAvailabilityCheck instance = new ToolAvailabilityCheck(CoreStatistic.getInstance().getGroup("Checks"));

    protected ToolAvailabilityCheck(Statistic parent) {
        super(parent);
    }

    public static ToolAvailabilityCheck getInstance() {
        return instance;
    }

    protected void initialize(Map<String, Object> args) throws SystemTaskException {
        this.addCheck("Checking Ghostscript availability", () -> {
            try {
                String path = ExternalApplication.getToolPath((String)"GHOSTSCRIPT");
                if (path == null) {
                    this.fail("Unable to find Ghostscript");
                } else {
                    this.ok("Found Ghostscript in folder: " + path);
                }
            }
            catch (Exception e) {
                this.fail("An exception occurred searching for ghostscript: " + e.getLocalizedMessage());
            }
        });
        this.addCheck("Checking ImageMagick availability", () -> {
            try {
                String path = ExternalApplication.getToolPath((String)"IMAGEMAGICK");
                if (path == null) {
                    this.fail("Unable to find ImageMagick");
                } else {
                    this.ok("Found ImageMagick in folder: " + path);
                }
            }
            catch (Exception e) {
                this.fail("An exception occurred searching for ImageMagick: " + e.getLocalizedMessage());
            }
        });
    }

    public String getDescription() {
        return "Checking, if required tools are available";
    }

    public String getShortDescription() {
        return "Tool availability";
    }
}

