/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.cache.GenericCache;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemLink;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.statistic.JavaUtils;
import agorum.roi.statistic.config.SuperObjectCacheConfig;
import java.text.DecimalFormat;
import java.util.Map;

public class SuperObjectCacheCheck
extends SystemCheck {
    private static final SuperObjectCacheCheck instance = new SuperObjectCacheCheck(CoreStatistic.getInstance().getGroup("Checks"));

    protected SuperObjectCacheCheck(Statistic parent) {
        super(parent);
    }

    public static SuperObjectCacheCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        StatisticDetail detail = new StatisticDetail();
        this.details.add(detail);
        try {
            DecimalFormat df = new DecimalFormat("0.00");
            long maxMemory = JavaUtils.getMemory("-xmx");
            GenericCache gc = SuperObjectClientCachedBean.getClientBeanCache();
            long cacheSize = SuperObjectClientCachedBean.cacheSize;
            detail.title = "Result";
            if (cacheSize <= 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                this.info().detail((Object)"Please activate the SuperObjectCache, this improves the overall performance of agorum core").send("SuperObjectCache not active");
                detail.detail = "The SuperObjectCache is not active";
            } else {
                long memUsage = cacheSize * 5242L;
                if (memUsage > maxMemory / 2L) {
                    this.performanceStatus = Statistic.PerformanceStatus.WARN;
                    this.info().detail((Object)("The size of the SuperObjectCache is to large in relation of the available memory. Please consider, that a size of 10000 needs about 50 MB of RAM. Your SuperObjectCache size is: " + cacheSize + ", estimated ram usage is: " + df.format((double)memUsage / 1024.0 / 1024.0) + " MB, your available memory is: " + df.format((double)maxMemory / 1024.0 / 1024.0) + " MB. Do not user more than the half of your available JVM-memory")).send("SuperObjectCache size is too large");
                    detail.detail = "The SuperObjectCache size is too large";
                } else if (cacheSize < 10000L) {
                    this.performanceStatus = Statistic.PerformanceStatus.WARN;
                    this.info().detail((Object)("The size of the SuperObjectCache is below 10000 (" + cacheSize + "), please increased it. A good value is 50000")).send("SuperObjectCache size is too small");
                    detail.detail = "The SuperObjectCache size is too small";
                } else {
                    this.performanceStatus = Statistic.PerformanceStatus.OK;
                    this.info().detail((Object)("Your SuperObjectCache size is: " + cacheSize + ", estimated ram usage is: " + df.format((double)memUsage / 1024.0 / 1024.0) + " MB, your available memory is: " + df.format((double)maxMemory / 1024.0 / 1024.0) + " MB.")).send("SuperObjectCache size is good");
                    detail.detail = "The SuperObjectCache size is good";
                }
            }
            detail.actualValue = new Double(cacheSize);
            detail.referenceValue = new Double(10000.0);
            detail.performanceStatus = this.performanceStatus;
            SystemLink link = new SystemLink();
            link.setDescription("Open SuperObjectCache settings");
            link.setLink(SuperObjectCacheConfig.getInstance().getLink());
            detail.link = link;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.detail = "SuperObjectCache usage";
            detail.title = "Info";
            int count = gc == null ? 0 : gc.count();
            detail.actualValue = new Double(count);
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting SuperObjectCache info", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking SuperObjectCache";
    }

    public String getShortDescription() {
        return "SuperObjectCache";
    }
}

