/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemCheckSuite;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.auth.AuthenticatorFactory;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import java.util.Collection;
import java.util.Map;

public class AuthenticationCheck
extends SystemCheckSuite {
    private static final AuthenticationCheck instance = new AuthenticationCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private static final String NTLM_BASE_KEY = "MAIN_MODULE_MANAGEMENT/auth/NTLM";
    private static final String CIFS_BASE_KEY = "MAIN_MODULE_MANAGEMENT/auth/cifs";
    private static final String HTTP_BASE_KEY = "MAIN_MODULE_MANAGEMENT/auth/HTTP";
    private FormItem.Collection form;

    protected AuthenticationCheck(Statistic parent) {
        super(parent);
    }

    public static AuthenticationCheck getInstance() {
        return instance;
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        this.form = new FormItem.Collection();
        this.form.stringField("Username").description("Name of the user to test the authentication with").allowBlank(false).add();
        this.form.passwordField("Password").description("Password for the given user").allowBlank(false).add();
        return this.form.getCollection();
    }

    public String getDescription() {
        return "Authentication configuration check";
    }

    public String getShortDescription() {
        return "Authentication";
    }

    protected void initialize(Map<String, Object> args) throws SystemTaskException {
        if (args.get("Username") == null) {
            this.addCheck("Skipping", () -> this.skip("Test skipped, must be executed individually"));
            return;
        }
        MetaDbAccessor mda = new MetaDbAccessor(this.getName());
        if (mda.bundleExists(NTLM_BASE_KEY)) {
            this.addCheck("NTLM configuration check", () -> {
                try (MetaDbUtil mdu = mda.getReadUtil(NTLM_BASE_KEY);){
                    AuthenticatorFactory.checkNtlmPassThrough(mdu.getString("NetBiosDomain"), mdu.getString("NetBiosName"), mdu.getString("NetBiosDomainController"), mdu.getString("DomainController"), mdu.decryptString(mdu.getString("ServicePass")), (String)args.get("Username"), (String)args.get("Password"));
                    this.checkSuccessful();
                }
            });
        }
        if (mda.bundleExists(CIFS_BASE_KEY)) {
            this.addCheck("CIFS configuration check", () -> {
                try {
                    this.checkKerberos("cifs", args);
                }
                catch (AuthenticatorFactory.AuthException e) {
                    this.fail(e.getMessage());
                }
            });
        }
        if (mda.bundleExists(HTTP_BASE_KEY)) {
            this.addCheck("HTTP configuration check", () -> {
                try {
                    this.checkKerberos("HTTP", args);
                }
                catch (AuthenticatorFactory.AuthException e) {
                    this.fail(e.getMessage());
                }
            });
        }
    }

    private void checkKerberos(String name, Map<String, Object> args) throws AuthenticatorFactory.AuthException {
        AuthenticatorFactory.checkKerberos(name, (String)args.get("Username"), (String)args.get("Password"));
        this.checkSuccessful();
    }

    private void checkSuccessful() {
        this.ok("Check with the defined configuration and entered credentials successful");
    }
}

