/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.certificate;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.utils.TempFile;
import agorum.roi.statistic.certificate.KeystoreUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import sun.security.pkcs10.PKCS10;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.x509.X500Name;

public class CertificateGenerationAction
extends SystemAction {
    private static final String ALIAS_NAME_TOMCAT = "tomcat";
    private static final int KEY_SIZE = 2048;
    private static final CertificateGenerationAction instance = new CertificateGenerationAction(CoreStatistic.getInstance().getGroup("Actions"));
    private static String commonName;
    private static String organizationalUnit;
    private static String organization;
    private static String city;
    private static String state;
    private static String country;
    private static String confirmRemoval;

    protected CertificateGenerationAction(Statistic parent) {
        super(parent);
    }

    public static CertificateGenerationAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Generate a self-signed SSL certificate or a CSR (Certificate Signing Request)";
    }

    public String getShortDescription() {
        return "Generate certificates";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        fields.stringField("commonName").title("Common Name, CN").description("Common Name (Host + Domain Name) [like 'yoursite.com' or 'subdomain.yoursite.com']").allowBlank(false).add();
        fields.stringField("organizationalUnit").title("Organizational Unit, OU").allowBlank(false).add();
        fields.stringField("organization").title("Organization, O").allowBlank(false).add();
        fields.stringField("city").title("City, L").allowBlank(false).add();
        fields.stringField("state").title("State, S").allowBlank(false).add();
        fields.stringField("country").title("Country, C").allowBlank(false).add();
        fields.button("selfsignedButton").description("Generate self-signed certificate").add();
        fields.button("csrButton").description("Generate and download CSR").add();
        fields.button("removeButton").description("Remove existing certificate").add();
        fields.stringField("confirmRemoval").title("Confirm Removal").description("Confirmation for 'Remove existing certificate', leave blank otherwise").allowBlank(true).add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        String button = (String)args.get("buttonId");
        commonName = (String)args.get("commonName");
        organizationalUnit = (String)args.get("organizationalUnit");
        organization = (String)args.get("organization");
        city = (String)args.get("city");
        state = (String)args.get("state");
        country = (String)args.get("country");
        confirmRemoval = (String)args.get("confirmRemoval");
        if (button.equals("csrButton")) {
            this.generateCSR();
        } else if (button.equals("selfsignedButton")) {
            this.getSelfSignedCertificate();
            try {
                KeystoreUtil.removeAutoSelfSignedGeneration();
            }
            catch (IOException e) {
                this.error(e, "There was an error removing the self-signed certificate generation from the roi_jboss.bat start script.Please uncomment it manually, otherwise your changes will be lost after the next system start.");
            }
        } else if (button.equals("removeButton")) {
            this.removeCertificate();
        }
        return false;
    }

    private void removeCertificate() {
        if (!confirmRemoval.equals("remove")) {
            this.setPromptAfterAction("WARNING: Removing an existing certificate may impair security, or lead to a non-functional system. You should only do this, if you are certain that you have to.\n\nTo confirm removal, enter 'remove' in the 'Confirm Removal' field.");
        } else {
            try {
                String keystorePath = System.getProperty("javax.net.ssl.keyStore");
                char[] keystorePass = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
                KeystoreUtil keyStoreUtils = new KeystoreUtil(new File(keystorePath), keystorePass);
                KeyStore keyStore = keyStoreUtils.getKeyStore();
                if (keyStore.containsAlias(ALIAS_NAME_TOMCAT)) {
                    keyStore.deleteEntry(ALIAS_NAME_TOMCAT);
                    keyStoreUtils.save(keystorePass);
                    this.setPromptAfterAction("The certificate has been removed successfully. The server must be restarted for the changes to take effect.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void generateCSR() {
        try {
            this.setDownloadFile(null);
            KeyPair keyPair = this.generateKeyPair("RSA", 2048);
            byte[] csr = this.generateCSR("SHA256WithRSA", keyPair);
            File tmpFile = TempFile.createTempFile((long)3600000L, (String)commonName, (String)"csr");
            try (FileOutputStream os = new FileOutputStream(tmpFile);){
                ((OutputStream)os).write(csr);
            }
            this.setDownloadFile(tmpFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.error(e, "Unable to generate CSR", null);
        }
    }

    private void getSelfSignedCertificate() {
        long validity = 1557628928L;
        try {
            CertAndKeyGen keyPair = new CertAndKeyGen("RSA", "SHA256WithRSA", null);
            X500Name x500Name = new X500Name(commonName, organizationalUnit, organization, city, state, country);
            keyPair.generate(2048);
            X509Certificate cert = keyPair.getSelfCertificate(x500Name, new Date(), validity);
            Certificate[] chain = new Certificate[]{cert};
            String keystorePath = System.getProperty("javax.net.ssl.keyStore");
            char[] keystorePass = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
            KeystoreUtil keyStoreUtils = new KeystoreUtil(new File(keystorePath), keystorePass);
            KeyStore keyStore = keyStoreUtils.getKeyStore();
            if (keyStore.containsAlias(ALIAS_NAME_TOMCAT)) {
                this.warning().detail((Object)"Your keystore already contains a matching certificate. For safety-reasons, you must first remove the existing one.").send("Matching certificate already exists");
                throw new Exception("Generate self-signed certificate ignored for safety reasons");
            }
            try {
                KeyStore keyStore2 = KeyStore.getInstance("JKS");
                keyStore2.load(new FileInputStream(keystorePath), keystorePass);
                keyStore2.setKeyEntry(ALIAS_NAME_TOMCAT, keyPair.getPrivateKey(), keystorePass, chain);
                keyStore2.store(new FileOutputStream(keystorePath), keystorePass);
            }
            catch (KeyStoreException e) {
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new FileInputStream(keystorePath), keystorePass);
                keyStore.setKeyEntry(ALIAS_NAME_TOMCAT, keyPair.getPrivateKey(), keystorePass, chain);
                keyStore.store(new FileOutputStream(keystorePath), keystorePass);
            }
            this.setPromptAfterAction("Self-signed certificate installed successfully. The server must be restarted for the changes to take effect.");
        }
        catch (Exception e) {
            this.error(e, "Unable to generate and import self-signed certificate", null);
        }
    }

    byte[] generateCSR(String sigAlg, KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, CertificateException, IOException, SignatureException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outStream);
        X500Name x500Name = new X500Name("CN=" + commonName + ", OU=" + organizationalUnit + ", O=" + organization + ", L=" + city + ", S=" + state + ", C=" + country);
        Signature sig = Signature.getInstance(sigAlg);
        sig.initSign(keyPair.getPrivate());
        PKCS10 pkcs10 = new PKCS10(keyPair.getPublic());
        pkcs10.encodeAndSign(x500Name, sig);
        pkcs10.print(printStream);
        return outStream.toByteArray();
    }

    KeyPair generateKeyPair(String alg, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(alg);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.generateKeyPair();
    }
}

