/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.action;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.statistic.action.DomainTrust;
import java.util.Collection;
import java.util.Map;

public class SSOAction
extends SystemAction {
    private static final SSOAction instance = new SSOAction(CoreStatistic.getInstance().getGroup("Actions"));

    protected SSOAction(Statistic parent) {
        super(parent);
    }

    public static SSOAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "SSO: Enable Single Sign-On by joining a domain";
    }

    public String getShortDescription() {
        return "SSO";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        String host;
        FormItem.Collection fields = new FormItem.Collection();
        try {
            host = DomainTrust.guessHostName();
        }
        catch (Exception e) {
            host = "";
            this.info("Could not determine the local host name automatically");
        }
        fields.stringField("host").title("Host").description("Fully qualified, canonical host name of this machine").value((Object)host).allowBlank(false).add();
        fields.stringField("domain").title("Domain Name").description("Fully qualified name of the domain to join").value((Object)"").allowBlank(false).add();
        fields.stringField("dc").title("Domain Controller").description("Fully qualified name of the domain controller to use, optionally followed by the LDAP port if different from the standard of 389 (may be omitted)").value((Object)"").allowBlank(true).add();
        fields.stringField("user").title("User").description("Administrative user in the target domain").value((Object)"").allowBlank(false).add();
        fields.passwordField("pass").title("Password").description("Password of the administrative user").value((Object)"").allowBlank(false).add();
        fields.boolField("ignoreTest").title("Ignore test").description("Ignore if the SSO test performed during the join process fails").value((Object)false).allowBlank(false).add();
        fields.button("save").description("Join").add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        if (SSOAction.isButton((String)"save", args)) {
            String host = (String)args.get("host");
            String domain = (String)args.get("domain");
            String dc = (String)args.get("dc");
            String user = (String)args.get("user");
            String pass = (String)args.get("pass");
            boolean ignoreTest = (Boolean)args.get("ignoreTest");
            try {
                DomainTrust dt = new DomainTrust(domain, user, pass);
                this.info("Discovering domain controllers...");
                dt.discover(dc);
                this.info("Establishing domain trust...");
                dt.establish(host);
                try {
                    this.info("Checking domain trust...");
                    try {
                        dt.test();
                    }
                    catch (Exception e) {
                        if (ignoreTest || e instanceof DomainTrust.NonFatalDomainTrustException) {
                            this.warning("Test failed, proceeding anyway...", e);
                        }
                        throw e;
                    }
                    this.info("Activating SSO...");
                    dt.install();
                }
                catch (Exception e) {
                    try {
                        dt.abolish();
                    }
                    catch (Exception e2) {
                        this.error("Could not undo domain trust after an error occurred during testing or installation.", e2);
                    }
                    throw e;
                }
                this.setPromptAfterAction("Domain joined successfully. The server must be restarted for the changes to take effect.");
            }
            catch (Exception e) {
                this.error(e);
                String message = e.getMessage();
                if (message == null) {
                    this.setPromptAfterAction("Failed to join the domain, please consult the log for more information.");
                }
                this.setPromptAfterAction("Failed to join the domain: " + message);
            }
        }
        return false;
    }
}

