/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.action;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.utils.TempFile;
import agorum.commons.zip.ZipUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class LogDownloadAction
extends SystemAction {
    private static final int ONE_DAY_MILLISECONDS = 86400000;
    private static final LogDownloadAction instance = new LogDownloadAction(CoreStatistic.getInstance().getGroup("Actions"));

    protected LogDownloadAction(Statistic parent) {
        super(parent);
    }

    public static LogDownloadAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Log download";
    }

    public String getShortDescription() {
        return "Log download";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        fields.dateField("fromDate").title("From Date").value((Object)new Date(new Date().getTime() - 86400000L)).description("Specify a starting date for downloading logs").allowBlank(false).add();
        fields.dateField("toDate").title("To Date").value((Object)new Date()).description("Specify an end date for downloading logs").allowBlank(true).add();
        fields.button("downloadButton").title("Download").description("Download").add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        try {
            String button = (String)args.get("buttonId");
            if (button.equals("downloadButton")) {
                this.setDownloadFile(null);
                Date fromDate = (Date)args.get("fromDate");
                long fromDateL = fromDate.getTime();
                Date toDate = (Date)args.get("toDate");
                long toDateL = toDate == null ? Long.MAX_VALUE : toDate.getTime() + 86400000L;
                fromDateL += 60000L;
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                String serverHome = System.getProperty("jboss.server.home.dir");
                File logDir = new File(serverHome + "/log");
                long realFromDate = Long.MAX_VALUE;
                long realToDate = Long.MIN_VALUE;
                ArrayList<File> logFilesToUse = new ArrayList<File>();
                File[] logFiles = logDir.listFiles();
                if (logFiles != null) {
                    for (File logFile : logFiles) {
                        BasicFileAttributes attr;
                        long mt;
                        if (!logFile.getName().contains(".log") || (mt = (attr = Files.readAttributes(logFile.toPath(), BasicFileAttributes.class, new LinkOption[0])).lastModifiedTime().toMillis()) < fromDateL || mt >= toDateL) continue;
                        logFilesToUse.add(logFile);
                        if (realFromDate > mt) {
                            realFromDate = mt;
                        }
                        if (realToDate >= mt) continue;
                        realToDate = mt;
                    }
                }
                if (logFilesToUse.size() > 0) {
                    String logName = "server-" + sdf2.format(new Date(realFromDate)) + " - " + sdf2.format(new Date(realToDate));
                    File tmpFileZip = TempFile.createTempFile((long)600000L, (String)logName, (String)"zip");
                    this.info("zipping: " + tmpFileZip.getAbsolutePath());
                    ZipUtils.zipFiles(logFilesToUse, (File)tmpFileZip);
                    this.setDownloadFile(tmpFileZip.getAbsolutePath());
                    this.info("zipping finished: " + this.getDownloadFile());
                } else {
                    this.warning("No log files found in the selected time period!");
                }
            }
        }
        catch (Exception e) {
            this.error(e, "Error creating zip file");
        }
        return false;
    }
}

