/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.action;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.scripting.EngineContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JavaScriptAction
extends SystemAction {
    private static final String JAVA_SCRIPT_ACTION = "JavaScriptAction";
    private static final Statistic instance = new JavaScriptAction(CoreStatistic.getInstance().getGroup("Actions"));
    public static final String METADB_BASE_KEY = "MAIN_MODULE_MANAGEMENT/roi/control/statistic/js";
    public static final String DEFAULT_JS = "/* global sc, args */\n\nlet objects = require('common/objects');\n\n";
    private JsAction action;

    public static final Statistic getInstance() {
        block23: {
            MetaDbAccessor mdba = new MetaDbAccessor(JAVA_SCRIPT_ACTION);
            try (MetaDbUtil mdu = mdba.getReadUtil(METADB_BASE_KEY);){
                List<String> jsList = mdu.listBundles("");
                if (jsList == null) break block23;
                Statistic group = CoreStatistic.getInstance().getGroup("Actions");
                for (String jsName : jsList) {
                    MetaDbUtil mdu2 = mdba.getReadUtil("MAIN_MODULE_MANAGEMENT/roi/control/statistic/js/" + jsName);
                    Throwable throwable = null;
                    try {
                        String prettyName = mdu2.getString("name", jsName);
                        JavaScriptAction javaScriptAction = new JavaScriptAction(group, new JsAction(prettyName));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (mdu2 == null) continue;
                        if (throwable != null) {
                            try {
                                mdu2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        mdu2.close();
                    }
                }
            }
        }
        return instance;
    }

    protected JavaScriptAction(Statistic parent) {
        super(parent);
    }

    protected JavaScriptAction(Statistic parent, JsAction action) {
        super(action.prettyName, parent);
        this.action = action;
        this.action.load();
    }

    public String getDescription() {
        if (this.action == null) {
            return "JavaScript action";
        }
        return "JavaScript action: " + this.action.nodeName;
    }

    public String getShortDescription() {
        if (this.action == null) {
            return "JS action";
        }
        return "JS: " + this.action.nodeName;
    }

    public Map<String, Object> getPropertyMap(int rc, int depth) {
        if (this.action != null) {
            this.action.load();
        }
        return super.getPropertyMap(rc, depth);
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        String js;
        boolean readOnly;
        FormItem.Collection fields = new FormItem.Collection();
        if (this.action == null) {
            readOnly = false;
            js = DEFAULT_JS;
            fields.stringField("name").title("Name").description("Script Name").readOnly(readOnly).allowBlank(false).add();
        } else {
            readOnly = this.action.readOnly;
            js = this.action.script;
        }
        fields.scriptField("js").title("JavaScript").description("JavaScript Code").value((Object)js).readOnly(readOnly).allowBlank(false).add();
        if (this.action == null) {
            fields.button("execute").description("Execute").add();
            fields.button("save").description("Save as new action").add();
        } else if (!readOnly) {
            fields.button("execute").description("Save and execute").add();
            fields.button("save").description("Update action").add();
            fields.button("delete").description("Delete action").add();
        }
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        try {
            String button = (String)args.get("buttonId");
            if (button != null) {
                this.clearLog();
                if (JavaScriptAction.isButton((String)"execute", args)) {
                    if (this.action != null) {
                        if (args.get("js") == null) {
                            args.put("js", this.action.script);
                        }
                        if (args.get("name") == null) {
                            args.put("name", this.action.prettyName);
                        }
                        if (!this.action.readOnly) {
                            this.save(args);
                        }
                    }
                    return true;
                }
                if (JavaScriptAction.isButton((String)"save", args)) {
                    this.save(args);
                } else if (JavaScriptAction.isButton((String)"delete", args)) {
                    this.delete();
                }
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        return false;
    }

    public void runActionAsync(Map<String, Object> args) throws SystemTaskException {
        try {
            this.info("Executing JavaScript");
            SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin("SystemStatistic.JS." + args.get("name"));
            EngineContext context = new EngineContext(false, sessionController);
            context.put("sessionController", sessionController);
            context.put("sc", sessionController);
            context.put("sessionControllerAdmin", sessionController);
            context.put("sca", sessionController);
            context.put("args", args);
            long time = System.currentTimeMillis();
            Object result = context.eval(args.get("js") + "");
            time = System.currentTimeMillis() - time;
            this.info("Execution finished in " + time + " ms");
            if (result == null) {
                result = "";
            }
            this.info().detail((Object)result.toString()).send("Result");
            this.info().send("Finished");
        }
        catch (Exception e) {
            this.error(e);
            throw new SystemTaskException("", (Throwable)e);
        }
    }

    private final void save(Map<String, Object> conf) {
        if (this.action == null) {
            JsAction newAction = new JsAction((String)conf.get("name"));
            if (newAction.exists()) {
                this.error("Action name " + newAction.nodeName + " already exists, choose another name");
            } else {
                newAction.setFromConfig(conf);
                newAction.save();
                Statistic group = CoreStatistic.getInstance().getGroup("Actions");
                JavaScriptAction newStat = new JavaScriptAction(group, newAction);
                this.setStatisticRedirectionName(newStat.getName());
                JavaScriptAction.getInstance().info("Action " + newAction.nodeName + " saved");
            }
        } else {
            this.action.setFromConfig(conf);
            this.action.save();
            this.info("Action " + this.action.nodeName + " updated");
        }
    }

    private final void delete() {
        MetaDbAccessor mdba = new MetaDbAccessor(JAVA_SCRIPT_ACTION);
        try (MetaDbUtil mdu = mdba.getWriteUtil(METADB_BASE_KEY);){
            mdu.delete(this.action.nodeName);
            mdu.commit();
        }
        this.removeFromParent();
        this.setStatisticRedirectionName(JavaScriptAction.getInstance().getName());
        JavaScriptAction.getInstance().info("Action " + this.action.nodeName + " deleted");
    }

    private static class JsAction {
        boolean readOnly;
        private String nodeName;
        private String prettyName;
        private String script = "/* global sc, args */\n\nlet objects = require('common/objects');\n\n";

        private JsAction(String nodeName) {
            this.prettyName = nodeName;
            this.nodeName = Statistic.normalizeIdentifier((String)nodeName);
        }

        private String getMetaPath() {
            return "MAIN_MODULE_MANAGEMENT/roi/control/statistic/js/" + this.nodeName;
        }

        private boolean exists() {
            MetaDbAccessor mdba = new MetaDbAccessor(JavaScriptAction.JAVA_SCRIPT_ACTION);
            return mdba.bundleExists(this.getMetaPath());
        }

        private void load() {
            MetaDbAccessor mdba = new MetaDbAccessor(JavaScriptAction.JAVA_SCRIPT_ACTION);
            try (MetaDbUtil mdu = mdba.getReadUtil(this.getMetaPath());){
                this.script = mdu.getString("js", JavaScriptAction.DEFAULT_JS);
                this.prettyName = mdu.getString("name", null);
                this.readOnly = mdu.getBoolean("readOnly", false);
            }
        }

        private void save() {
            MetaDbAccessor mdba = new MetaDbAccessor(JavaScriptAction.JAVA_SCRIPT_ACTION);
            try (MetaDbUtil mdu = mdba.getWriteUtil(this.getMetaPath());){
                mdu.setString("name", this.prettyName);
                mdu.setString("js", this.script);
                mdu.setBoolean("readOnly", this.readOnly);
                mdu.commit();
            }
        }

        public void setFromConfig(Map<String, Object> conf) {
            this.prettyName = (String)conf.get("name");
            this.script = (String)conf.get("js");
            this.readOnly = conf.get("readOnly") == null ? false : (Boolean)conf.get("readOnly");
        }
    }
}

