/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.action;

import agorum.commons.utils.RandomIdGenerator;
import agorum.roi.auth.Authentication;
import agorum.roi.auth.AuthenticatorFactory;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.statistic.action.SSOAction;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DomainTrust {
    private static final String OID_SPNEGO = "1.3.6.1.5.5.2";
    private final String domain;
    private final String user;
    private final String pass;
    private final String domainDn;
    private InetSocketAddress dc;
    private String domainController;
    private String netBiosDomainController;
    private String netBiosDomain;
    private String computersDn;
    private String domainControllersDn;
    private String host;
    private String netBiosHost;
    private String spnAgorum;
    private String spnCifs;
    private String spnHttp;
    private String spnPass;

    public DomainTrust(String domain, String user, String pass) throws DomainTrustException {
        this.domain = domain;
        this.user = DomainTrust.fixPrincipal(user, domain);
        this.pass = pass;
        this.domainDn = Arrays.stream(domain.split("\\.")).map(part -> "DC=" + part).collect(Collectors.joining(","));
    }

    public static String guessHostName() throws SocketException, UnknownHostException, NamingException {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = DomainTrust.reverseLookup(socket.getLocalAddress());
            return string;
        }
    }

    public void discover(String domainController) throws DomainTrustException {
        if (domainController == null || domainController.isEmpty()) {
            Collection<InetSocketAddress> dcs = DomainTrust.getDomainControllers(this.domain);
            if (dcs.isEmpty()) {
                throw new DomainTrustException("No domain controllers found for: " + this.domain);
            }
            SSOAction.getInstance().info().detail((Object)dcs.stream().map(dc -> dc.getHostName()).collect(Collectors.joining("\n"))).send("Discovered " + dcs.size() + " domain controllers");
            this.dc = dcs.iterator().next();
            this.domainController = this.dc.getHostName();
            if (dcs.size() > 1) {
                SSOAction.getInstance().warning("More than one domain controller discovered, using the first one: " + this.domainController);
            } else {
                SSOAction.getInstance().info("Using domain controller: " + this.domainController);
            }
        } else {
            int port;
            int i = domainController.indexOf(":");
            if (i >= 0) {
                port = Integer.parseInt(domainController.substring(i + 1));
                domainController = domainController.substring(0, i);
            } else {
                port = 389;
            }
            this.dc = new InetSocketAddress(domainController, port);
            this.domainController = domainController;
        }
        System.setProperty("java.security.krb5.realm", this.domain.toUpperCase());
        System.setProperty("java.security.krb5.kdc", this.domainController);
        this.inLdap(ctx -> {
            Attribute wellKnownObjects;
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setDerefLinkFlag(false);
            NamingEnumeration<SearchResult> nEnum = ctx.search("CN=Partitions,CN=Configuration," + this.domainDn, "(&(nETBIOSName=*)(dnsRoot=" + this.domain + "))", sc);
            while (nEnum.hasMore()) {
                Attribute netbiosName = nEnum.next().getAttributes().get("nETBIOSName");
                if (netbiosName == null || netbiosName.size() <= 0) continue;
                this.netBiosDomain = (String)netbiosName.get(0);
                break;
            }
            if (this.netBiosDomain == null) {
                this.netBiosDomain = this.domain.substring(0, this.domain.indexOf(".")).toUpperCase();
            }
            if ((wellKnownObjects = ctx.getAttributes(this.domainDn).get("wellKnownObjects")) != null) {
                nEnum = wellKnownObjects.getAll();
                while (nEnum.hasMore()) {
                    String typeAndValue;
                    SearchResult obj = nEnum.next();
                    if (!(obj instanceof String) || (typeAndValue = (String)((Object)obj)).length() < 38) continue;
                    String type = typeAndValue.substring(0, 37);
                    String value = typeAndValue.substring(38);
                    switch (type) {
                        case "B:32:AA312825768811D1ADED00C04FD8D5CD": {
                            this.computersDn = value;
                            break;
                        }
                        case "B:32:A361B2FFFFD211D1AA4B00C04FD7D83A": {
                            this.domainControllersDn = value;
                        }
                    }
                }
            }
            if (this.computersDn == null) {
                this.computersDn = "CN=Computers," + this.domainDn;
            }
            if (this.domainControllersDn == null) {
                this.domainControllersDn = "OU=Domain Controllers," + this.domainDn;
            }
            sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setDerefLinkFlag(false);
            nEnum = ctx.search(this.domainControllersDn, "(dNSHostName=" + this.domainController + ")", sc);
            while (nEnum.hasMore()) {
                Attribute cn = nEnum.next().getAttributes().get("CN");
                if (cn == null || !(cn.get() instanceof String)) continue;
                this.netBiosDomainController = (String)cn.get();
                break;
            }
            if (this.netBiosDomainController == null) {
                NamingEnumeration<NameClassPair> listEnum = ctx.list(this.domainControllersDn);
                while (listEnum.hasMore()) {
                    Attribute cn = ctx.getAttributes(listEnum.next().getNameInNamespace()).get("CN");
                    if (cn == null || !(cn.get() instanceof String)) continue;
                    this.netBiosDomainController = (String)cn.get();
                    break;
                }
            }
            if (this.netBiosDomainController == null) {
                this.netBiosDomainController = this.domainController.substring(0, this.domainController.indexOf(".")).toUpperCase();
            }
        });
    }

    public String establish(String host) throws DomainTrustException {
        DomainTrust.validateHost(host);
        this.invoke(host, RandomIdGenerator.createId());
        this.inLdap(ctx -> {
            BasicAttributes attrs = new BasicAttributes();
            attrs.put("cn", this.netBiosHost);
            attrs.put("sAMAccountName", this.netBiosHost + "$");
            BasicAttribute servicePrincipalName = new BasicAttribute("servicePrincipalName");
            servicePrincipalName.add(this.spnAgorum);
            servicePrincipalName.add(this.spnCifs);
            servicePrincipalName.add(this.spnHttp);
            attrs.put(servicePrincipalName);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add("top");
            objectClass.add("person");
            objectClass.add("organizationalPerson");
            objectClass.add("user");
            objectClass.add("computer");
            attrs.put(objectClass);
            attrs.put("userAccountControl", "4128");
            attrs.put("unicodePwd", ("\"" + this.spnPass + "\"").getBytes(StandardCharsets.UTF_16LE));
            ctx.rebind("CN=" + this.netBiosHost + "," + this.computersDn, null, (Attributes)attrs);
        });
        return this.spnPass;
    }

    public void invoke(String host, String spnPass) {
        int i = host.indexOf(".");
        String name = i < 0 ? host : host.substring(0, i);
        this.host = host;
        this.spnPass = spnPass;
        this.netBiosHost = name.substring(0, Math.min(12, name.length())).toUpperCase() + "-AC";
        this.spnAgorum = "agorum/" + host;
        this.spnCifs = "cifs/" + host;
        this.spnHttp = "HTTP/" + host;
    }

    public void abolish() throws DomainTrustException {
        this.inLdap(ctx -> ctx.unbind("CN=" + this.netBiosHost + "," + this.computersDn));
    }

    public void test() throws DomainTrustException {
        GSSContext serverContext;
        GSSContext clientContext;
        LoginContext client = DomainTrust.login(this.user, this.pass, true);
        LoginContext server = DomainTrust.login(this.spnCifs + "@" + this.domain.toUpperCase(), this.spnPass, false);
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid oid = new Oid(OID_SPNEGO);
            GSSName clientName = gssManager.createName(this.user, null).canonicalize(oid);
            GSSName serverName = gssManager.createName(this.spnCifs + "@" + this.domain.toUpperCase(), null).canonicalize(oid);
            GSSCredential clientCreds = DomainTrust.inContext(client, () -> gssManager.createCredential(clientName, 0, oid, 1));
            clientContext = gssManager.createContext(serverName, oid, clientCreds, 0);
            serverContext = gssManager.createContext(serverName, oid, null, 0);
            byte[] token = new byte[]{};
            while (token != null) {
                byte[] clientInToken = token;
                if ((token = DomainTrust.inContext(client, () -> clientContext.initSecContext(clientInToken, 0, clientInToken.length))) == null) continue;
                byte[] serverInToken = token;
                token = DomainTrust.inContext(server, () -> serverContext.acceptSecContext(serverInToken, 0, serverInToken.length));
            }
        }
        catch (Exception e) {
            throw new DomainTrustException("Kerberos authentication test failed", e);
        }
        if (!clientContext.isEstablished()) {
            throw new DomainTrustException("Kerberos authentication test failed: Server did not authenticate to client");
        }
        if (!serverContext.isEstablished()) {
            throw new DomainTrustException("Kerberos authentication test failed: Client did not authenticate to server");
        }
        try {
            AuthenticatorFactory.checkNtlmPassThrough(this.netBiosDomain, this.netBiosHost, this.netBiosDomainController, this.domainController, this.spnPass, this.user.substring(0, this.user.indexOf("@")), this.pass);
        }
        catch (Exception e) {
            throw new NonFatalDomainTrustException("NTLM pass-through authentication test failed", e);
        }
    }

    public void install() {
        SessionController sc = SessionControllerAdmin.getService(DomainTrust.class);
        try (Transaction t = new Transaction();){
            try (MetaDbUtil mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/auth/domain/");){
                mdu.delete("");
                mdu.setString("Host", this.host);
                mdu.setString("Realm", this.domain.toUpperCase());
                mdu.setString("KDC", this.domainController);
                mdu.commit();
            }
            mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/auth/agorum/");
            var5_7 = null;
            try {
                mdu.delete("");
                mdu.setString("Class", Authentication.KERBEROS_LOGIN_MODULE);
                mdu.setString("ServicePass", this.spnPass);
                mdu.encrypt("ServicePass");
                mdu.setString("options/principal", this.spnAgorum + "@" + this.domain.toUpperCase());
                mdu.setString("options/storeKey", "true");
                mdu.setString("options/isInitiator", "false");
                mdu.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (mdu != null) {
                    if (var5_7 != null) {
                        try {
                            mdu.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        mdu.close();
                    }
                }
            }
            mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/auth/HTTP/");
            var5_7 = null;
            try {
                mdu.delete("");
                mdu.setString("Class", Authentication.KERBEROS_LOGIN_MODULE);
                mdu.setString("ServicePass", this.spnPass);
                mdu.encrypt("ServicePass");
                mdu.setString("options/principal", this.spnHttp + "@" + this.domain.toUpperCase());
                mdu.setString("options/storeKey", "true");
                mdu.setString("options/isInitiator", "false");
                mdu.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (mdu != null) {
                    if (var5_7 != null) {
                        try {
                            mdu.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        mdu.close();
                    }
                }
            }
            mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/auth/cifs/");
            var5_7 = null;
            try {
                mdu.delete("");
                mdu.setString("Class", Authentication.KERBEROS_LOGIN_MODULE);
                mdu.setString("ServicePass", this.spnPass);
                mdu.encrypt("ServicePass");
                mdu.setString("options/principal", this.spnCifs + "@" + this.domain.toUpperCase());
                mdu.setString("options/storeKey", "true");
                mdu.setString("options/isInitiator", "false");
                mdu.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (mdu != null) {
                    if (var5_7 != null) {
                        try {
                            mdu.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        mdu.close();
                    }
                }
            }
            mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/auth/NTLM/");
            var5_7 = null;
            try {
                mdu.delete("");
                mdu.setString("NetBiosDomain", this.netBiosDomain);
                mdu.setString("NetBiosName", this.netBiosHost);
                mdu.setString("NetBiosDomainController", this.netBiosDomainController);
                mdu.setString("DomainController", this.domainController);
                mdu.setString("ServicePass", this.spnPass);
                mdu.encrypt("ServicePass");
                mdu.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (mdu != null) {
                    if (var5_7 != null) {
                        try {
                            mdu.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        mdu.close();
                    }
                }
            }
            mdu = new MetaDbUtil(sc, "MAIN_MODULE_MANAGEMENT/api/control/");
            var5_7 = null;
            try {
                mdu.setBoolean("HttpAuth", true);
                mdu.commit();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (mdu != null) {
                    if (var5_7 != null) {
                        try {
                            mdu.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        mdu.close();
                    }
                }
            }
            t.commit();
        }
    }

    private static String fixPrincipal(String principal, String domain) throws DomainTrustException {
        int i = principal.indexOf("@");
        if (i < 0) {
            return principal + "@" + domain.toUpperCase();
        }
        return principal.substring(0, i + 1) + principal.substring(i + 1).toUpperCase();
    }

    private static Collection<InetSocketAddress> getDomainControllers(String domain) throws DomainTrustException {
        String typeSRV = "SRV";
        String[] types = new String[]{"SRV"};
        try {
            InitialDirContext ctx = new InitialDirContext();
            Attributes attributes = ctx.getAttributes("dns:/_ldap._tcp.dc._msdcs." + domain, types);
            if (attributes.get("SRV") == null) {
                return Collections.emptyList();
            }
            NamingEnumeration<?> e = attributes.get("SRV").getAll();
            TreeMap<Integer, InetSocketAddress> result = new TreeMap<Integer, InetSocketAddress>();
            while (e.hasMoreElements()) {
                String line = (String)e.nextElement();
                String[] parts = line.split("\\s+");
                int prio = Integer.parseInt(parts[0]);
                int port = Integer.parseInt(parts[2]);
                String host = parts[3];
                if (host.endsWith(".")) {
                    host = host.substring(0, host.length() - 1);
                }
                result.put(prio, new InetSocketAddress(host, port));
            }
            return result.values();
        }
        catch (Exception e) {
            throw new DomainTrustException("Could not find domain controller", e);
        }
    }

    private static <T> T inContext(LoginContext loginContext, PrivilegedExceptionAction<T> action) throws Exception {
        try {
            return Subject.doAs(loginContext.getSubject(), action);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static LoginContext login(String user, String pass, boolean initiator) throws DomainTrustException {
        final HashMap<String, String> clientOptions = new HashMap<String, String>();
        clientOptions.put("principal", user);
        clientOptions.put("storeKey", "true");
        clientOptions.put("isInitiator", Boolean.toString(initiator));
        CallbackHandler callbackHandler = callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof TextOutputCallback) continue;
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(user);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    pc.setPassword(pass.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unsupported callback");
            }
        };
        try {
            LoginContext lc = new LoginContext(DomainTrust.class.getName(), null, callbackHandler, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Authentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, clientOptions)};
                }
            });
            lc.login();
            return lc;
        }
        catch (Exception e) {
            throw new DomainTrustException("Could not authenticate to the domain controller using the provided credentials for user: " + user, e);
        }
    }

    private void inLdap(DirContextConsumer callback) throws DomainTrustException {
        try {
            DomainTrust.inContext(DomainTrust.login(this.user, this.pass, true), () -> {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + this.dc.getHostName() + ":" + this.dc.getPort());
                env.put("java.naming.security.authentication", "GSSAPI");
                env.put("javax.security.sasl.qop", "auth-conf");
                callback.consume(new InitialDirContext(env));
                return null;
            });
        }
        catch (DomainTrustException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DomainTrustException(e);
        }
    }

    private static void validateHost(String host) throws DomainTrustException {
        try {
            InetAddress addr = InetAddress.getByName(host);
            String canonical = DomainTrust.reverseLookup(addr);
            if (canonical == null) {
                throw new DomainTrustException("Given hostname \"" + host + "\" is not a canonical hostname for the associated address: " + addr.getHostAddress());
            }
            if (!host.equalsIgnoreCase(canonical)) {
                throw new DomainTrustException("Given hostname \"" + host + "\" does not match canonical hostname \"" + canonical + "\" for the associated address: " + addr.getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            throw new DomainTrustException("Given hostname \"" + host + "\" is unknown", e);
        }
        catch (Exception e) {
            throw new DomainTrustException("Could not validate hostname \"" + host + "\"", e);
        }
    }

    private static String reverseLookup(InetAddress addr) throws NamingException {
        StringBuilder reverseLookup = new StringBuilder("dns:/");
        byte[] octets = addr.getAddress();
        for (int i = octets.length - 1; i >= 0; --i) {
            reverseLookup.append(Byte.toUnsignedInt(octets[i]));
            reverseLookup.append(".");
        }
        reverseLookup.append("in-addr.arpa");
        Attribute ptr = new InitialDirContext().getAttributes(reverseLookup.toString(), new String[]{"PTR"}).get("ptr");
        if (ptr != null && ptr.get() instanceof String) {
            String canonical = (String)ptr.get();
            while (canonical.endsWith(".")) {
                canonical = canonical.substring(0, canonical.length() - 1);
            }
            return canonical;
        }
        return null;
    }

    private static interface DirContextConsumer {
        public void consume(DirContext var1) throws Exception;
    }

    public static class NonFatalDomainTrustException
    extends DomainTrustException {
        public NonFatalDomainTrustException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class DomainTrustException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DomainTrustException(String message) {
            super(message);
        }

        public DomainTrustException(String message, Throwable cause) {
            super(DomainTrustException.chain(message, cause), cause);
        }

        public DomainTrustException(Throwable cause) {
            this(null, cause);
        }

        private static final String chain(String message, Throwable cause) {
            StringBuilder messages = new StringBuilder();
            if (message != null) {
                messages.append(message);
            }
            while (cause != null) {
                String causeMessage = cause.getMessage();
                if (causeMessage != null) {
                    if (messages.length() > 0) {
                        messages.append(" > ");
                    }
                    messages.append(causeMessage);
                }
                cause = cause.getCause();
            }
            return messages.length() > 0 ? messages.toString() : null;
        }
    }
}

