/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic;

import agorum.commons.logging.LogEntry;
import agorum.commons.statistic.RootStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticBase;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.statistic.measurement.Measurement;
import agorum.commons.string.SerializableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DashboardStatistic
extends SystemStatistic {
    public static final DashboardStatistic instance = new DashboardStatistic();

    public static DashboardStatistic getInstance() {
        return instance;
    }

    protected DashboardStatistic() {
        this.setServiceStatus(Statistic.ServiceStatus.NONE);
        this.setSort(0);
    }

    public String getPropertyType() {
        return "dashboard";
    }

    public String getDescription() {
        return "Support tool dashboard";
    }

    public String getShortDescription() {
        return "Dashboard";
    }

    public Map<String, Object> getPropertyMap(int rc, int depth) {
        Map result = super.getPropertyMap(rc, depth);
        StatisticBase root = (StatisticBase)RootStatistic.getInstance();
        List stickies = root.stickyLogToPropertyMap();
        result.put("sticky", stickies);
        String serverStatus = "ok";
        String serverStatusText = "Your agorum core server is working fine.";
        String status = DashboardStatistic.getErrorStatus((Statistic.ServiceStatus)root.getCompositeTaskStatus());
        if ("ERROR".equals(status)) {
            serverStatus = "error";
            serverStatusText = "Your agorum core server has detected a problem.";
        } else if (stickies.size() > 0) {
            serverStatus = "alert";
            serverStatusText = "Active notifications require your attention.";
        } else if ("WARN".equals(status)) {
            serverStatus = "alert";
            serverStatusText = "A sub-system requires your attention.";
        }
        result.put("serverStatus", serverStatus);
        result.put("serverStatusText", serverStatusText);
        ArrayList<Map> lo = new ArrayList<Map>();
        for (Measurement m : RootStatistic.getPinnedMeasurements()) {
            lo.add(m.getPropertyMap(false));
        }
        result.put("measurements", lo);
        result.put("debugLoggers", this.getDebugLoggers(RootStatistic.getInstance(), new SerializableMap()));
        return result;
    }

    public List<Measurement> getMeasurementList(Measurement.Id id) {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        for (Measurement m : RootStatistic.getPinnedMeasurements()) {
            if (!m.getId().toString().equals(id.toString())) continue;
            result.add(m);
        }
        return result;
    }

    private SerializableMap getDebugLoggers(Statistic parent, SerializableMap result) {
        if (parent.getLogLevel() == LogEntry.Severity.DEBUG && parent.getQualifyingName() != null) {
            result.put((Object)parent.getName(), (Object)parent.getLink());
        }
        for (Statistic child : parent.getChildren()) {
            this.getDebugLoggers(child, result);
        }
        return result;
    }
}

