/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.ExtendedUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.UserProfileObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;

public class AppUserProfileObjectSessionFacade
extends GlobalObjectSessionFacade {
    private boolean keywordWithId = false;
    private boolean isDirectoryUserSet = false;

    public void setKeywordWithId(boolean keywordWithId) {
        this.keywordWithId = keywordWithId;
    }

    public AppUserProfileObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.gosfc.setGlobalObjectClientBeanDefinition(new AppUserProfileObjectClientBeanDefinition(sessionController));
    }

    public void setApplication(String application) throws Exception {
        this.setAttributeInternal(ExtendedUserProfileObjectClientBean.APPLICATION_ATTRIBUTE, application);
    }

    public void setKeyword(String keyword) throws Exception {
        if (keyword == null) {
            throw new NullPointerException();
        }
        this.setAttributeInternal("APPKEYWORD", keyword);
    }

    public void setValue(String value) throws Exception {
        this.setAttributeInternal("APPVALUE", value != null ? value.getBytes("UTF-8") : null);
    }

    public void setDirectoryUserObject(DirectoryUserObjectClientBean du) throws Exception {
        if (this.sessionController.isAdminEnabled() || this.sessionController.getLoginUser().getId().longValue() == du.getId().longValue()) {
            this.setAttributeInternal(UserProfileObjectClientBean.DIRECTORYUSEROBJECT_ATTRIBUTE, du);
            this.setAttributeInternal(GlobalObjectClientBean.OWNER_ATTRIBUTE, du);
            this.isDirectoryUserSet = true;
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.AdminAccessNeeded", 23);
        }
    }

    public void setAllAttributes() throws Exception {
        if (!this.isDirectoryUserSet) {
            this.setAttributeInternal(UserProfileObjectClientBean.DIRECTORYUSEROBJECT_ATTRIBUTE, this.sessionController.getLoginUser());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean create() throws Exception {
        GlobalObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.setAllAttributes();
            poRet = super.create();
            this.setCreateKeyword();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    private void setCreateKeyword() throws Exception {
        GlobalObjectClientBeanDefinition def;
        if (this.keywordWithId && (def = this.getGlobalObjectClientBeanDefinition()).getAttribute("APPKEYWORD") != null) {
            String keyword = def.getAttribute("APPKEYWORD").getString();
            Long id = def.getId();
            keyword = this.su.strReplace(keyword, "$$ID$$", "" + id);
            def.setAttribute("APPKEYWORD", AttributeValue.newAttributeValueObject(keyword));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean update() throws Exception {
        GlobalObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.setAllAttributes();
            poRet = super.update();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }
}

