/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting.sandbox;

import agorum.roi.scripting.sandbox.SandboxContext;
import agorum.roi.scripting.sandbox.SandboxNativeJavaArray;
import agorum.roi.scripting.sandbox.SandboxNativeJavaObject;
import agorum.roi.scripting.sandbox.SandboxNativeList;
import agorum.roi.scripting.sandbox.SandboxNativeMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class SandboxWrapFactory
extends WrapFactory {
    public SandboxWrapFactory() {
        this.setJavaPrimitiveWrap(false);
    }

    @Override
    public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
        if (obj != null && obj.getClass().isArray()) {
            return new SandboxNativeJavaArray(scope, obj);
        }
        return super.wrap(cx, scope, obj, staticType);
    }

    @Override
    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
        if (cx instanceof SandboxContext) {
            SandboxContext context = (SandboxContext)cx;
            if (javaObject instanceof Map) {
                return new SandboxNativeMap(context, scope, (Map)javaObject, staticType);
            }
            if (javaObject instanceof List) {
                return new SandboxNativeList(context, scope, (List)javaObject, staticType);
            }
            if (javaObject != null && javaObject.getClass().equals(Date.class)) {
                Date date = (Date)javaObject;
                return ScriptRuntime.newObject(context, scope, "Date", new Object[]{date.getTime()});
            }
            return new SandboxNativeJavaObject(context, scope, javaObject, staticType);
        }
        return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
    }
}

