/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.mail;

import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParseException;

public class RFC2231Parser {
    public String getAttachmentName(Part part) throws MessagingException {
        String[] header = part.getHeader("Content-Disposition");
        if (header != null && header.length > 0) {
            return this.getParameter(header[0], "filename");
        }
        header = part.getHeader("Content-Type");
        if (header != null && header.length > 0) {
            return this.getParameter(header[0], "name");
        }
        return null;
    }

    public String getParameter(String header, String name) {
        HeaderTokenizer tokenizer = new HeaderTokenizer(header, "()<>@,;:\\\"\t []/?=", true);
        StringBuffer sb = null;
        Encoding encoding = new Encoding();
        try {
            HeaderTokenizer.Token token;
            while ((token = tokenizer.next()).getType() != -4) {
                if (token.getType() != 59) continue;
                token = tokenizer.next();
                if (token.getType() == -4) break;
                this.checkType(token);
                String n = token.getValue();
                token = tokenizer.next();
                if (token.getType() != 61) {
                    throw new ParseException("Illegal token : " + token.getValue());
                }
                token = tokenizer.next();
                this.checkType(token);
                String v = token.getValue();
                if (n.equalsIgnoreCase(name)) {
                    while ((token = tokenizer.next()).getType() != -4 && token.getType() != 59 && token.getType() != 61 && token.getValue() != null) {
                        v = v + " " + token.getValue();
                    }
                    return v;
                }
                int index = name.length();
                if (!n.startsWith(name) || n.charAt(index) != '*') continue;
                int lastIndex = n.length() - 1;
                if (sb == null) {
                    sb = new StringBuffer();
                }
                if (n.charAt(lastIndex) == '*') {
                    sb.append(this.decodeRFC2231(v, encoding));
                } else {
                    sb.append(v);
                }
                if (index != lastIndex) continue;
                break;
            }
            if (sb != null) {
                return new String(sb);
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        throw new InternalError();
    }

    private void checkType(HeaderTokenizer.Token token) throws ParseException {
        int t = token.getType();
        if (t != -1 && t != -2) {
            throw new ParseException("Illegal token : " + token.getValue());
        }
    }

    private String decodeRFC2231(String s, Encoding encoding) throws ParseException, UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int work = s.indexOf(39);
        if (work > 0) {
            encoding.encoding = s.substring(0, work);
            i = s.indexOf(39, ++work);
            encoding.lang = s.substring(work, i);
            ++i;
        }
        try {
            while (i < s.length()) {
                if (s.charAt(i) == '%') {
                    sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    i += 2;
                } else {
                    sb.append(s.charAt(i));
                }
                ++i;
            }
            return new String(new String(sb).getBytes("iso-8859-15"), encoding.encoding);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException(s + " :: this string were not decoded.");
        }
    }

    static class Encoding {
        String encoding = "us-ascii";
        String lang = "";

        Encoding() {
        }
    }
}

