/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.common;

import agorum.agceptit.dynawebservices.client.beans.DynaGenericRequestBean;
import agorum.agceptit.dynawebservices.client.beans.DynaGenericResponseBean;
import agorum.agceptit.dynawebservices.client.beans.LoginRequestBean;
import agorum.agceptit.dynawebservices.client.beans.LoginResponseBean;
import agorum.agceptit.dynawebservices.client.beans.LogoutRequestBean;
import agorum.agceptit.dynawebservices.client.beans.LogoutResponseBean;
import agorum.agceptit.dynawebservices.client.common.DynaWebservicesCall;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.ngos.dynawebservices.client.beans.AbortTransactionRequestBean;
import agorum.ngos.dynawebservices.client.beans.BeginTransactionRequestBean;
import agorum.ngos.dynawebservices.client.beans.EndTransactionRequestBean;
import agorum.ngos.dynawebservices.client.beans.TransactionResponseBean;
import agorum.ngos.dynawebservices.client.beans.parsexml.ParseXMLRequestBean;
import agorum.ngos.dynawebservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManager;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.parser.common.AttributeObject;
import agorum.roi.parser.common.ClassObject;
import agorum.roi.parser.common.CopyObjectBean;
import agorum.roi.parser.common.CreateOrUpdateRoiObjectInstance;
import agorum.roi.parser.common.MetaDbBean;
import agorum.roi.parser.common.ParseXmlServerBean;
import agorum.roi.parser.common.ParseXmlServiceObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLObject;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CreateRoiObjectsFromParseObject {
    private String ADMINPATH_OFFSET = "/Administration/RoiCreateJavaObjects/RoiSourceTemplates/ejb";
    private String ADMINSAVEPATH_OFFSET = "/Administration/RoiCreateJavaObjects/CreateJavaClasses";
    private String ADMINPATH_SYNC_OFFSET = "/Administration/RoiCreateJavaObjects/RoiSourceTemplates/sync";
    private String CLASSNAME_ATTRIBUTE = "${ClassName}";
    private String ATTRIBUTESCLIENTBEAN_ATTRIBUTE = "${AttributesClientBean}";
    private String ATTRIBUTESCLIENTBEANDEFINITION_ATTRIBUTE = "${AttributesClientBeanDefinition}";
    private String EXTENDEDCLASSNAME_ATTRIBUTE = "${ExtendClassName}";
    private String CLASSNAMETABLE_ATTRIBUTE = "${ClassNameTable}";
    private String PACKAGEOFFSET_ATTRIBUTE = "${PackageOffset}";
    private String NEWLINE = "\n";
    private String CLIENTBEANREF = "${ClientBeanRef}";
    private String DATATYPE = "${DATATYPE}";
    private String GETDATATYPE = "${GETDATATYPE}";
    private String ATTRIBUTEDEFINITION = "${AttributeDefinition}";
    private SessionController sessionController = null;
    private FolderObjectClientBean actFolder = null;

    public CreateRoiObjectsFromParseObject(SessionController sessionController, FolderObjectClientBean actFolder) {
        this.sessionController = sessionController;
        this.actFolder = actFolder;
    }

    public CreateRoiObjectsFromParseObject(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public Vector create(ParserObject po) throws Exception {
        Vector returnVector = new Vector();
        if (po != null) {
            Hashtable savepoint = new Hashtable();
            Hashtable internalVariables = new Hashtable();
            int len = po.size();
            for (int i = 0; i < len; ++i) {
                StringUtils su;
                Object o = po.getParserObject(i);
                if (o instanceof ClassObject) {
                    ClassObject co = (ClassObject)o;
                    if (!co.getUpdate()) {
                        this.createNewClassObject(co);
                        try {
                            this.createJavaObjects(co);
                            this.createJavaObjectsForSync(co);
                        }
                        catch (Exception e) {
                            System.err.println("INFO : ---- Keine Source erzeugt f\u00fcr Object " + co.getName());
                        }
                        continue;
                    }
                    this.updateClassObject(co);
                    continue;
                }
                if (o instanceof ParseXmlServiceObject) {
                    this.parseXmlService((ParseXmlServiceObject)o);
                    continue;
                }
                if (o instanceof UserManagerBean) {
                    UserManagerBean userManagerBean = (UserManagerBean)o;
                    if (userManagerBean.getMakeUpdateFromUserName() == null) {
                        UserManager um = new UserManager(this.sessionController);
                        um.create(userManagerBean);
                        continue;
                    }
                    DirectoryUserObjectClientBean du = this.sessionController.getUserByName(userManagerBean.getMakeUpdateFromUserName());
                    UserManager um = new UserManager(this.sessionController);
                    um.update(userManagerBean, du);
                    continue;
                }
                if (o instanceof RoiXMLObject) {
                    CreateOrUpdateRoiObjectInstance couri = new CreateOrUpdateRoiObjectInstance(this.sessionController, this.actFolder);
                    RoiXMLObject rxo = (RoiXMLObject)o;
                    if (couri.createOrUpdate(rxo, savepoint, returnVector, internalVariables)) continue;
                    break;
                }
                if (o instanceof CopyObjectBean) {
                    try {
                        CopyObjectBean cob = (CopyObjectBean)o;
                        this.copyObject(cob);
                        continue;
                    }
                    catch (Throwable t) {
                        su = new StringUtils();
                        throw new Exception("Error in CopyObject\n:" + su.exceptionToString(t));
                    }
                }
                if (!(o instanceof MetaDbBean)) continue;
                try {
                    MetaDbBean mdbb = (MetaDbBean)o;
                    this.doMetaDb(mdbb);
                    continue;
                }
                catch (Throwable t) {
                    su = new StringUtils();
                    throw new Exception("Error in MetaDbBean\n:" + su.exceptionToString(t));
                }
            }
        }
        return returnVector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyObject(CopyObjectBean cob) throws Exception {
        int lenV;
        GlobalObjectClientBean sourceGocb;
        String sourceObject = cob.getSourceObject();
        String destinationObject = cob.getDestinationObject();
        if (sourceObject == null) {
            throw new Exception("Error in CopyObject\n: no SourceObject define");
        }
        if (destinationObject == null) {
            throw new Exception("Error in CopyObject\n: no DestinationObject define");
        }
        if (!sourceObject.startsWith("/")) {
            if (sourceObject.startsWith("./")) {
                sourceObject = sourceObject.substring(2);
            }
            if (this.actFolder == null) throw new Exception("no rootfolder for sourceObject define");
            sourceObject = this.actFolder.getAnyFolderPath() + "/" + sourceObject;
        }
        if (!destinationObject.startsWith("/")) {
            if (destinationObject.startsWith("./")) {
                destinationObject = destinationObject.substring(2);
            }
            if (this.actFolder == null) throw new Exception("no rootfolder for destinationObject define");
            destinationObject = this.actFolder.getAnyFolderPath() + "/" + destinationObject;
        }
        if ((sourceGocb = this.sessionController.findGlobalObjectByPath(sourceObject)) == null) throw new Exception("Error in CopyObject\n: no SourceObject \"" + sourceObject + "\" not found");
        GlobalObjectClientBean destinationGocb = this.sessionController.findGlobalObjectByPath(destinationObject);
        if (destinationGocb != null) throw new Exception("Error in CopyObject\n: DestinationObject \"" + destinationObject + "\" exists");
        DirectoryUserObjectClientBean owner = null;
        DirectoryUserObjectClientBean creator = null;
        AccessControlListObjectClientBean acl = null;
        if (cob.getAcl() != null && (acl = this.sessionController.getAclByName(cob.getAcl())) == null) {
            throw new Exception("Error in CopyObject\n: no Acl \"" + cob.getAcl() + "\" not found");
        }
        if (cob.getOwner() != null && (owner = this.sessionController.getUserByName(cob.getOwner())) == null) {
            throw new Exception("Error in CopyObject\n: no Owner \"" + cob.getOwner() + "\" not found");
        }
        if (cob.getCreator() != null && (creator = this.sessionController.getUserByName(cob.getCreator())) == null) {
            throw new Exception("Error in CopyObject\n: no Creator \"" + cob.getCreator() + "\" not found");
        }
        String parent = destinationObject.substring(0, destinationObject.lastIndexOf("/"));
        FolderObjectClientBean parentFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(parent);
        if (parentFolder == null) throw new Exception("Error in CopyObject\n: no DestinationObject Parent \"" + parent + "\" not exists");
        String name = destinationObject.substring(destinationObject.lastIndexOf("/") + 1);
        SuperObjectClientBeanDefinition def = sourceGocb.getDefinition(this.sessionController);
        def.setSystemOption("addToFolder", parentFolder);
        def.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(name));
        Vector<String> vLeafAttributesByCopy = new Vector<String>();
        if (acl != null) {
            def.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, AttributeValue.newAttributeValueObject(acl));
            vLeafAttributesByCopy.addElement(GlobalObjectClientBean.ACL_ATTRIBUTE);
        }
        if (owner != null) {
            def.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, AttributeValue.newAttributeValueObject(owner));
            vLeafAttributesByCopy.addElement(GlobalObjectClientBean.OWNER_ATTRIBUTE);
        }
        if (creator != null) {
            def.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, AttributeValue.newAttributeValueObject(creator));
            vLeafAttributesByCopy.addElement(GlobalObjectClientBean.CREATOR_ATTRIBUTE);
        }
        if ((lenV = vLeafAttributesByCopy.size()) > 0) {
            String[] sLeafeAttributesByCopy = new String[lenV];
            for (int k = 0; k < lenV; ++k) {
                sLeafeAttributesByCopy[k] = (String)vLeafAttributesByCopy.elementAt(k);
            }
            def.setSystemOption("leaveAttributesByCopy", sLeafeAttributesByCopy);
        }
        sourceGocb.copy(def);
    }

    private void doMetaDb(MetaDbBean mdbb) throws Exception {
    }

    private void parseXmlService(ParseXmlServiceObject serviceObject) throws Exception {
        Vector servers = serviceObject.getServers();
        Vector jobs = serviceObject.getJobs();
        Hashtable<String, ParseXmlServerBean> hServers = new Hashtable<String, ParseXmlServerBean>();
        StringUtils su = new StringUtils();
        DynaWebservicesCall wsCall = new DynaWebservicesCall();
        if (servers != null && jobs != null && servers.size() > 0 && jobs.size() > 0) {
            ParseXmlServerBean server;
            try {
                int len = servers.size();
                for (int i = 0; i < len; ++i) {
                    server = (ParseXmlServerBean)servers.elementAt(i);
                    LoginRequestBean loginRequestBean = new LoginRequestBean();
                    loginRequestBean.setUserName(server.getUsername());
                    loginRequestBean.setPassWord(server.getPassword());
                    LoginResponseBean loginResponseBean = (LoginResponseBean)wsCall.callStaticService(null, "StaticNgOsService", "login", server.getUrl(), LoginResponseBean.class, (DynaGenericRequestBean)loginRequestBean);
                    this.checkResponseError((DynaGenericResponseBean)loginResponseBean);
                    if (!loginResponseBean.getConnected()) continue;
                    System.err.println("Login is ok.");
                    String wsSessionId = loginResponseBean.getWsSessionId();
                    BeginTransactionRequestBean beginTransactionRequestBean = new BeginTransactionRequestBean();
                    beginTransactionRequestBean.setTransactionTimeout(server.getTransactionTimeout());
                    TransactionResponseBean transactionResponseBean = (TransactionResponseBean)wsCall.callStaticService(wsSessionId, "NgOSSystemService", "beginTransaction", server.getUrl(), TransactionResponseBean.class, (DynaGenericRequestBean)beginTransactionRequestBean);
                    this.checkResponseError((DynaGenericResponseBean)transactionResponseBean);
                    String transactionId = transactionResponseBean.getTransactionId();
                    System.err.println("do Job : ");
                    System.err.println("WsSessionId : " + wsSessionId);
                    System.err.println("TransactionId : " + transactionId);
                    server.setTransactionId(transactionId);
                    server.setLoginResponseBean(loginResponseBean);
                    hServers.put(wsSessionId, server);
                    int lenJ = jobs.size();
                    for (int x = 0; x < lenJ; ++x) {
                        String xml = su.strTrim((String)jobs.elementAt(x));
                        ParseXMLRequestBean parseXMLRequestBean = new ParseXMLRequestBean();
                        parseXMLRequestBean.setInnerXML(xml);
                        ParseXMLResponseBean parseXMLResponseBean = (ParseXMLResponseBean)wsCall.callStaticService(wsSessionId, "NgOSParseXmlService", "parse", server.getUrl(), ParseXMLResponseBean.class, (DynaGenericRequestBean)parseXMLRequestBean);
                        this.checkResponseError((DynaGenericResponseBean)parseXMLResponseBean);
                    }
                }
                Enumeration enumT = hServers.keys();
                while (enumT.hasMoreElements()) {
                    String wsSessionId = (String)enumT.nextElement();
                    ParseXmlServerBean server2 = (ParseXmlServerBean)hServers.get(wsSessionId);
                    System.err.println("Logout : " + server2.getUrl());
                    System.err.println("WsSessionId : " + server2.getLoginResponseBean().getWsSessionId());
                    System.err.println("TransactionId : " + server2.getTransactionId());
                    EndTransactionRequestBean endTransactionRequestBean = new EndTransactionRequestBean();
                    endTransactionRequestBean.setTransactionId(server2.getTransactionId());
                    TransactionResponseBean responseBean = (TransactionResponseBean)wsCall.callStaticService(server2.getLoginResponseBean().getWsSessionId(), "NgOSSystemService", "endTransaction", server2.getUrl(), TransactionResponseBean.class, (DynaGenericRequestBean)endTransactionRequestBean);
                    this.checkResponseError((DynaGenericResponseBean)responseBean);
                    LogoutRequestBean logoutRequestBean = new LogoutRequestBean();
                    LogoutResponseBean logoutResponseBean = (LogoutResponseBean)wsCall.callStaticService(server2.getLoginResponseBean().getWsSessionId(), "StaticNgOsService", "logout", server2.getUrl(), LogoutResponseBean.class, (DynaGenericRequestBean)logoutRequestBean);
                    this.checkResponseError((DynaGenericResponseBean)logoutResponseBean);
                    server2.setUrl(null);
                }
            }
            catch (Throwable t) {
                String error = su.exceptionToString(t);
                throw new Exception(error);
            }
            finally {
                Enumeration enumT = hServers.keys();
                while (enumT.hasMoreElements()) {
                    String wsSessionId = (String)enumT.nextElement();
                    server = (ParseXmlServerBean)hServers.get(wsSessionId);
                    System.err.println("Abort : " + server.getUrl());
                    if (server.getUrl() == null) continue;
                    try {
                        AbortTransactionRequestBean abortTransactionRequestBean = new AbortTransactionRequestBean();
                        abortTransactionRequestBean.setTransactionId(server.getTransactionId());
                        TransactionResponseBean responseBean = (TransactionResponseBean)wsCall.callStaticService(server.getLoginResponseBean().getWsSessionId(), "NgOSSystemService", "abortTransaction", server.getUrl(), TransactionResponseBean.class, (DynaGenericRequestBean)abortTransactionRequestBean);
                        this.checkResponseError((DynaGenericResponseBean)responseBean);
                        LogoutRequestBean logoutRequestBean = new LogoutRequestBean();
                        LogoutResponseBean logoutResponseBean = (LogoutResponseBean)wsCall.callStaticService(server.getLoginResponseBean().getWsSessionId(), "StaticNgOsService", "logout", server.getUrl(), LogoutResponseBean.class, (DynaGenericRequestBean)logoutRequestBean);
                        this.checkResponseError((DynaGenericResponseBean)logoutResponseBean);
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else {
            if ((servers == null || servers != null && servers.size() == 0) && (jobs == null || jobs != null && jobs.size() == 0)) {
                throw new Exception("Error in parseXmlService : no server and no job define \n(Check the Tags : <Servers><Server>..</Server><Server>..</Server> ...</Servers>)\n(Check the Tags : <Jobs><Job>..</Job><Job>..</Job> ...</Jobs>)\n");
            }
            if (servers == null || servers != null && servers.size() == 0) {
                throw new Exception("Error in parseXmlService : no server define \n(Check the Tags : <Servers><Server>..</Server><Server>..</Server> ...</Servers>)\n");
            }
            if (jobs == null || jobs != null && jobs.size() == 0) {
                throw new Exception("Error in parseXmlService : no job define \n(Check the Tags : <Jobs><Job>..</Job><Job>..</Job> ...</Jobs>)\n");
            }
        }
    }

    private void checkResponseError(DynaGenericResponseBean baseResponseBean) throws Exception {
        if (baseResponseBean.getErrorKey() != null) {
            String error = "parseXmlService : \n\nCheckError :" + baseResponseBean.getClass().getName() + "\nLogError    : " + baseResponseBean.getLogError() + "\nErrorKey    : " + baseResponseBean.getErrorKey() + "\n\n";
            System.err.println(error);
            throw new Exception(error);
        }
    }

    private void createNewClassObject(ClassObject co) throws Exception {
        ClassObjectClientBeanDefinition classDef = new ClassObjectClientBeanDefinition(this.sessionController);
        classDef.setDataBaseObjectName(co.getDataBaseObjectName().toUpperCase());
        classDef.setName(co.getName());
        classDef.setDescription(co.getDescription());
        classDef.setJndiNameHome(co.getJndiNameHome());
        classDef.setJndiNameEJB(co.getJndiNameEJB());
        classDef.setEJBHomeClass(co.getEJBHomeClass());
        classDef.setClientBeanClass(co.getClientBeanClass());
        classDef.setCallBackClassPath(co.getCallBackClassPath());
        classDef.setClassAcl(Boolean.valueOf(co.getClassAcl()));
        classDef.setAbstract(co.getAbstract());
        classDef.setFinal(co.getFinal());
        classDef.setPartitioned(co.getPartitioned());
        classDef.setUniqueName(co.getUniqueName().toUpperCase());
        classDef.setActive(co.getActive());
        ClassObjectClientBean superClass = this.sessionController.getClassObject(co.getSuperClass().toUpperCase());
        if (superClass == null) {
            throw new Exception("Superclass not Found (" + co.getSuperClass() + ")");
        }
        classDef.setSuperClass(superClass);
        Vector v = co.getAttributes();
        this.createAllAttributeDefinitions(classDef, v);
        this.sessionController.createDataBaseObject(classDef);
    }

    private void updateClassObject(ClassObject co) throws Exception {
        ClassObjectClientBean cocb = this.sessionController.getClassObject(co.getUpdateClassName());
        if (cocb == null) {
            throw new Exception("No ClassName Found (" + co.getUpdateClassName() + ")");
        }
        ClassObjectClientBeanDefinition classDef = new ClassObjectClientBeanDefinition(this.sessionController);
        Vector v = co.getAttributes();
        this.createAllAttributeDefinitions(classDef, v);
        this.sessionController.updateDataBaseObject(classDef, cocb);
    }

    private void createAllAttributeDefinitions(ClassObjectClientBeanDefinition classObjectClientBeanDefinition, Vector v) throws Exception {
        if (v != null) {
            int lenV = v.size();
            for (int j = 0; j < lenV; ++j) {
                AttributeObject ao = (AttributeObject)v.elementAt(j);
                AttributeObjectClientBeanDefinition attrDef = new AttributeObjectClientBeanDefinition(this.sessionController);
                attrDef.setDataBaseObjectName(ao.getDataBaseObjectName().toUpperCase());
                attrDef.setName(ao.getName());
                attrDef.setActive(ao.getActive());
                attrDef.setDataType(ao.getDataType().toUpperCase());
                attrDef.setDataLength(ao.getDataLength());
                attrDef.setIsUnique(ao.getIsUnique());
                attrDef.setRequired(ao.getRequired());
                attrDef.setIndexed(ao.getIndexed());
                attrDef.setSetable(ao.getSetable());
                attrDef.setUpdateable(ao.getUpdateable());
                attrDef.setUniqueDataBaseObjects(ao.getUniqueDataBaseObjects());
                attrDef.setIndexedDataBaseObjects(ao.getIndexedDataBaseObjects());
                classObjectClientBeanDefinition.addAttributeDefinition(attrDef);
            }
        }
    }

    private void createJavaObjects(ClassObject co) throws Exception {
        String packageOffset = co.getPackageOffset();
        if (packageOffset != null) {
            RoiFileSystem roiFileSystem = new RoiFileSystem(this.sessionController);
            FolderObjectClientBean focbSourceFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(this.ADMINPATH_OFFSET);
            if (focbSourceFolder != null) {
                FolderObjectClientBean focbDestFolder = roiFileSystem.createFullpath(this.ADMINSAVEPATH_OFFSET + "/" + co.getName());
                GlobalObjectClientBean[] items = focbDestFolder.getItems();
                if (items != null) {
                    int lenItems = items.length;
                    for (int i = 0; i < lenItems; ++i) {
                        items[i].delete();
                    }
                }
                FolderObjectClientBean focbCopyFolder = (FolderObjectClientBean)focbSourceFolder.copy(focbSourceFolder.getDefinition(this.sessionController));
                focbDestFolder.addItem(focbCopyFolder);
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/beans/" + this.CLASSNAME_ATTRIBUTE + "EJB.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/callback/Custom" + this.CLASSNAME_ATTRIBUTE + "CallBack.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/callback/" + this.CLASSNAME_ATTRIBUTE + "CallBack.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/client/beans/" + this.CLASSNAME_ATTRIBUTE + "ClientBean.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/client/beans/" + this.CLASSNAME_ATTRIBUTE + "ClientBeanDefinition.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/interfaces/home/" + this.CLASSNAME_ATTRIBUTE + "Home.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/ejb/interfaces/remote/" + this.CLASSNAME_ATTRIBUTE + "Remote.java");
                this.createAttributes(co);
            }
        }
    }

    private void createJavaObjectsForSync(ClassObject co) throws Exception {
        String packageOffset = co.getPackageOffset();
        if (packageOffset != null) {
            RoiFileSystem roiFileSystem = new RoiFileSystem(this.sessionController);
            FolderObjectClientBean focbDestFolder = roiFileSystem.createFullpath(this.ADMINSAVEPATH_OFFSET + "/" + co.getName());
            FolderObjectClientBean focbSourceFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(this.ADMINPATH_SYNC_OFFSET);
            if (focbSourceFolder != null) {
                FolderObjectClientBean focbCopyFolder = (FolderObjectClientBean)focbSourceFolder.copy(focbSourceFolder.getDefinition(this.sessionController));
                focbDestFolder.addItem(focbCopyFolder);
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/sync/beans/Ws" + this.CLASSNAME_ATTRIBUTE + "Bean.java");
                this.updateJavaClass(co, this.ADMINSAVEPATH_OFFSET, "/sync/wssessionfacade/beans/Ws" + this.CLASSNAME_ATTRIBUTE + "SessionFacade.java");
            }
        }
    }

    private void updateJavaClass(ClassObject co, String offset, String className) throws Exception {
        StringUtils su = new StringUtils();
        String path = offset + "/" + co.getName() + className;
        FileObjectClientBean focb = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath(path);
        if (focb != null) {
            focb.setName(su.strReplace(focb.getName(), this.CLASSNAME_ATTRIBUTE, co.getName()));
            String content = StringConverterUtils.toString((InputStream)focb.getContentStream());
            content = su.strReplace(content, this.CLASSNAME_ATTRIBUTE, co.getName());
            content = su.strReplace(content, this.CLASSNAMETABLE_ATTRIBUTE, co.getName().toUpperCase());
            content = su.strReplace(content, this.EXTENDEDCLASSNAME_ATTRIBUTE, co.getSuperClass());
            content = su.strReplace(content, this.PACKAGEOFFSET_ATTRIBUTE, co.getPackageOffset());
            focb.setContent(StringConverterUtils.toStream((String)content));
        }
    }

    private void createAttributes(ClassObject co) throws Exception {
        FileObjectClientBean focb = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath(this.ADMINSAVEPATH_OFFSET + "/" + co.getName() + "/ejb/client/beans/" + co.getName() + "ClientBean.java");
        if (focb != null) {
            StringUtils su = new StringUtils();
            StringBuffer setAttributes = new StringBuffer();
            StringBuffer getAttributes = new StringBuffer();
            StringBuffer attributeDef = new StringBuffer();
            Vector v = co.getAttributes();
            if (v != null) {
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeObject ao = (AttributeObject)v.elementAt(i);
                    String datatype = ao.getDataType().toUpperCase();
                    String setter = "  /**" + this.NEWLINE + "   *" + this.NEWLINE + "   */" + this.NEWLINE + "  public void set" + ao.getName() + "(" + this.DATATYPE + " value)" + this.NEWLINE + "    throws Exception {" + this.NEWLINE + "    setAttribute(" + this.CLIENTBEANREF + ao.getName().toUpperCase() + "_ATTRIBUTE," + this.NEWLINE + "      AttributeValue.newAttributeValueObject(value));" + this.NEWLINE + "  }" + this.NEWLINE + this.NEWLINE;
                    String getter = "  /**" + this.NEWLINE + "   *" + this.NEWLINE + "   */" + this.NEWLINE + "  public " + this.DATATYPE + " get" + ao.getName() + "()" + this.NEWLINE + "    throws Exception {" + this.NEWLINE + "    return getAttribute(" + this.NEWLINE + "           " + ao.getName().toUpperCase() + "_ATTRIBUTE)." + this.GETDATATYPE + ";" + this.NEWLINE + "  }" + this.NEWLINE + this.NEWLINE;
                    String attributedefinition = "  public static final String " + ao.getName().toUpperCase() + "_ATTRIBUTE";
                    int lenA = attributedefinition.length();
                    lenA = 70 - lenA;
                    for (int k = 0; k < lenA; ++k) {
                        attributedefinition = attributedefinition + " ";
                    }
                    attributedefinition = attributedefinition + "=" + this.NEWLINE;
                    attributedefinition = attributedefinition + "                                                 \"" + ao.getDataBaseObjectName().toUpperCase() + "\";" + this.NEWLINE;
                    attributeDef.append(attributedefinition);
                    if (datatype.equals("STRING")) {
                        setter = su.strReplace(setter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getString()");
                    } else if (datatype.equals("CISTRING")) {
                        setter = su.strReplace(setter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getString()");
                    } else if (datatype.equals("LONGTEXT")) {
                        setter = su.strReplace(setter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.DATATYPE, "String");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getString()");
                    } else if (datatype.equals("LONG")) {
                        setter = su.strReplace(setter, this.DATATYPE, "long");
                        getter = su.strReplace(getter, this.DATATYPE, "long");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getLong()");
                    } else if (datatype.equals("BOOLEAN")) {
                        setter = su.strReplace(setter, this.DATATYPE, "boolean");
                        getter = su.strReplace(getter, this.DATATYPE, "boolean");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getBoolean()");
                    } else if (datatype.equals("INTEGER")) {
                        setter = su.strReplace(setter, this.DATATYPE, "int");
                        getter = su.strReplace(getter, this.DATATYPE, "int");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getInteger()");
                    } else if (datatype.equals("DOUBLE")) {
                        setter = su.strReplace(setter, this.DATATYPE, "double");
                        getter = su.strReplace(getter, this.DATATYPE, "double");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDouble()");
                    } else if (datatype.equals("DATABASEOBJECT")) {
                        setter = su.strReplace(setter, this.DATATYPE, "DataBaseObjectClientBean");
                        getter = su.strReplace(getter, this.DATATYPE, "DataBaseObjectClientBean");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDataBaseObjectClientBean(sessionController)");
                    } else if (datatype.equals("GLOBALOBJECT")) {
                        setter = su.strReplace(setter, this.DATATYPE, "GlobalObjectClientBean");
                        getter = su.strReplace(getter, this.DATATYPE, "GlobalObjectClientBean");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getGlobalObjectClientBean(sessionController)");
                    } else if (datatype.equals("INTERNALOBJECT")) {
                        setter = su.strReplace(setter, this.DATATYPE, "InternalObjectClientBean");
                        getter = su.strReplace(getter, this.DATATYPE, "InternalObjectClientBean");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getInternalObjectClientBean(sessionController)");
                    } else if (datatype.equals("DATE")) {
                        setter = su.strReplace(setter, this.DATATYPE, "Date");
                        getter = su.strReplace(getter, this.DATATYPE, "Date");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDate()");
                    } else if (datatype.equals("DIRECTORYOBJECT")) {
                        setter = su.strReplace(setter, this.DATATYPE, "DirectoryObjectClientBean");
                        getter = su.strReplace(getter, this.DATATYPE, "DirectoryObjectClientBean");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDirectoryObjectClientBean(sessionController)");
                    } else if (datatype.equals("BOOLEAN_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "boolean[]");
                        getter = su.strReplace(getter, this.DATATYPE, "boolean[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getBooleanArray(sessionController)");
                    } else if (datatype.equals("DATE_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "Date[]");
                        getter = su.strReplace(getter, this.DATATYPE, "Date[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDateArrayObject(sessionController)");
                    } else if (datatype.equals("INTEGER_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "int[]");
                        getter = su.strReplace(getter, this.DATATYPE, "int[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getIntegerArray(sessionController)");
                    } else if (datatype.equals("LONG_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "long[]");
                        getter = su.strReplace(getter, this.DATATYPE, "long[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getLongArray(sessionController)");
                    } else if (datatype.equals("DOUBLE_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "double[]");
                        getter = su.strReplace(getter, this.DATATYPE, "double[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDoubleArray(sessionController)");
                    } else if (datatype.equals("STRING_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "String[]");
                        getter = su.strReplace(getter, this.DATATYPE, "String[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getStringArrayObject(sessionController)");
                    } else if (datatype.equals("GLOBALOBJECT_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "GlobalObjectClientBean[]");
                        getter = su.strReplace(getter, this.DATATYPE, "GlobalObjectClientBean[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getGlobalObjectClientBeanArray(sessionController)");
                    } else if (datatype.equals("INTERNALOBJECT_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "InternalObjectClientBean[]");
                        getter = su.strReplace(getter, this.DATATYPE, "InternalObjectClientBean[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getInternalObjectClientBeanArray(sessionController)");
                    } else if (datatype.equals("DATABASEOBJECT_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "DataBaseObjectClientBean[]");
                        getter = su.strReplace(getter, this.DATATYPE, "DataBaseObjectClientBean[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDataBaseObjectClientBeanArray(sessionController)");
                    } else if (datatype.equals("DIRECTORYOBJECT_ARRAY")) {
                        setter = su.strReplace(setter, this.DATATYPE, "DirectoryObjectClientBean[]");
                        getter = su.strReplace(getter, this.DATATYPE, "DirectoryObjectClientBean[]");
                        getter = su.strReplace(getter, this.GETDATATYPE, "getDirectoryObjectClientBeanArray(sessionController)");
                    }
                    setAttributes.append(setter);
                    getAttributes.append(getter);
                }
                String content = su.streamToString(focb.getContentStream());
                content = su.strReplace(content, this.ATTRIBUTESCLIENTBEAN_ATTRIBUTE, su.strReplace(setAttributes.toString(), this.CLIENTBEANREF, "") + getAttributes.toString());
                content = su.strReplace(content, this.ATTRIBUTEDEFINITION, attributeDef.toString());
                focb.setContent(su.stringToStream(content));
                focb = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath(this.ADMINSAVEPATH_OFFSET + "/" + co.getName() + "/ejb/client/beans/" + co.getName() + "ClientBeanDefinition.java");
                if (focb != null) {
                    content = su.streamToString(focb.getContentStream());
                    content = su.strReplace(content, this.ATTRIBUTESCLIENTBEANDEFINITION_ATTRIBUTE, su.strReplace(setAttributes.toString(), this.CLIENTBEANREF, co.getName() + "ClientBean."));
                    focb.setContent(su.stringToStream(content));
                }
            }
        }
    }
}

