/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OrderedName {
    public String fullName;
    public int orderId;
    public String name;
    private static final Pattern pattern = Pattern.compile("(\\d+)\\s*(.+)");

    public OrderedName(String fullName) {
        Matcher matcher = pattern.matcher(fullName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Ordered name \"" + fullName + "\" has a wrong format, expected: \"<Order ID> <Name>\"");
        }
        this.fullName = fullName;
        this.orderId = Integer.parseInt(matcher.group(1));
        this.name = matcher.group(2);
    }

    protected OrderedName(String fullName, int orderId, String name) {
        this.fullName = fullName;
        this.orderId = orderId;
        this.name = name;
    }

    public String toString() {
        return this.fullName;
    }

    public static class Builder {
        private final int digits;

        public Builder(int length) {
            this.digits = (int)Math.floor(Math.log10(length)) + 2;
        }

        public OrderedName build(int index, String name) {
            int orderId = (index + 1) * 10;
            StringBuilder fullName = new StringBuilder();
            fullName.append(Integer.toString(orderId));
            int neededPadding = this.digits - fullName.length();
            if (neededPadding > 0) {
                StringBuilder padding = new StringBuilder();
                for (int i = 0; i < neededPadding; ++i) {
                    padding.append("0");
                }
                fullName = padding.append((CharSequence)fullName);
            }
            fullName.append(" ");
            fullName.append(name);
            return new OrderedName(fullName.toString(), orderId, name);
        }
    }
}

