/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util;

import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.metadb.util.OrderedName;
import agorum.roi.metadb.util.cache.MetaDbCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetaDbUtil
implements AutoCloseable {
    private final MetaDbCache cache;
    private final boolean readRestricted;

    public MetaDbUtil(SessionController sessionController, String prefix) {
        this(sessionController, prefix, false);
    }

    public MetaDbUtil(SessionController sessionController, String prefix, boolean readOnly) {
        this.cache = MetaDbCache.getInstance(sessionController, prefix, readOnly);
        this.readRestricted = readOnly;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public void commit() {
        if (this.readRestricted) {
            throw new IllegalStateException("commit() invoked on a read-only MetaDb cache");
        }
        try (Transaction t = new Transaction();){
            this.cache.commit();
            t.commit();
        }
    }

    private void write() {
        if (this.readRestricted) {
            throw new IllegalStateException("Tried to write into a read-only MetaDb cache");
        }
    }

    public String getString(String path) {
        return this.cache.get(path);
    }

    public String getString(String path, String defaultValue) {
        String value = this.cache.get(path);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setString(String path, String value) {
        this.write();
        this.cache.set(path, value);
    }

    public void encrypt(String path) {
        this.write();
        this.cache.encrypt(path);
    }

    public String decryptString(String str) {
        return this.cache.decryptString(str);
    }

    public String[] getStringArray(String path) {
        String[] result = this.cache.getArray(path);
        if (result == null) {
            return new String[0];
        }
        return result;
    }

    public void setStringArray(String path, String[] value) {
        this.write();
        this.cache.set(path, value);
    }

    public void setStringArray(String path, List<String> value) {
        this.write();
        this.cache.set(path, value.toArray(new String[value.size()]));
    }

    public boolean getBoolean(String path, boolean defaultValue) {
        String value = this.cache.get(path);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public void setBoolean(String path, boolean value) {
        this.write();
        this.cache.set(path, Boolean.toString(value));
    }

    public int getInt(String path, int defaultValue) {
        String value = this.cache.get(path);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public void setInt(String path, int value) {
        this.write();
        this.cache.set(path, Integer.toString(value));
    }

    public long getLong(String path, long defaultValue) {
        String value = this.cache.get(path);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public void setLong(String path, long value) {
        this.write();
        this.cache.set(path, Long.toString(value));
    }

    public List<String> listBundles(String path) {
        return this.cache.list(path, true);
    }

    public List<OrderedName> listOrderedBundles(String path) {
        List<String> bundleNames = this.listBundles(path);
        Collections.sort(bundleNames);
        ArrayList<OrderedName> result = new ArrayList<OrderedName>(bundleNames.size());
        for (String bundleName : bundleNames) {
            result.add(new OrderedName(bundleName));
        }
        return result;
    }

    public List<String> listEntries(String path) {
        return this.cache.list(path, false);
    }

    public boolean isEntry(String path) {
        return this.cache.isEntry(path);
    }

    public boolean isBundle(String path) {
        return this.cache.isBundle(path);
    }

    public void delete(String path) {
        this.write();
        this.cache.delete(path);
    }
}

