/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.common;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.SessionController;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaDbExtractor {
    private final SessionController sessionController;
    private final String metaDbPath;
    private final String defFile;
    private Map<Long, String> alreadyDone = new HashMap<Long, String>();

    public MetaDbExtractor(SessionController sessionController, String metaDbPath, String defFile) throws Exception {
        if (sessionController == null || !sessionController.isAdminEnabled()) {
            throw new Exception("Session not valid: bad username/password or no admin");
        }
        this.sessionController = sessionController;
        this.metaDbPath = metaDbPath;
        this.defFile = defFile;
    }

    public MetaDbExtractor(SessionController sessionController, String metaDbPath) throws Exception {
        this(sessionController, metaDbPath, null);
    }

    public MetaDbExtractor(String userName, String passWord, String metaDbPath, String defFile) throws Exception {
        this(MetaDbExtractor.connect(userName, passWord), metaDbPath, defFile);
    }

    private static final SessionController connect(String userName, String passWord) throws Exception {
        CredentialObject co = new CredentialObject();
        co.setUserName(userName);
        co.setPassWord(passWord);
        co.setModulInfo("MetaDbExtractor");
        return SessionController.connect(co);
    }

    public String extract() throws Exception {
        StringBuilder sb = new StringBuilder();
        FolderObjectClientBean startFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb");
        List<String> segments = Arrays.asList(this.metaDbPath.split("/"));
        List<String> pre = segments.subList(0, segments.size() - 1);
        String last = segments.get(segments.size() - 1);
        String depth = "";
        for (String segment : pre) {
            startFolder = (FolderObjectClientBean)startFolder.getItem(segment);
            sb.append(depth);
            sb.append(segment);
            sb.append(" (");
            sb.append(startFolder instanceof MetaDbPropertyGroupObjectClientBean ? "G" : "B");
            sb.append(")\n");
            depth = depth + "|";
        }
        sb.append("--------------------\n");
        this.metaDbWalker(this.sessionController, startFolder.getItem(last), this.metaDbPath, depth, sb);
        if (this.defFile != null) {
            FileOutputStream fos = new FileOutputStream(this.defFile);
            fos.write(sb.toString().getBytes("UTF-8"));
            fos.close();
        }
        return sb.toString();
    }

    private void metaDbWalker(SessionController sessionController, GlobalObjectClientBean item, String metaDbPath, String depth, StringBuilder sb) throws Exception {
        Long id = item.getId();
        String name = item.getName();
        String fullPath = metaDbPath + "/" + name;
        String otherPath = this.alreadyDone.get(id);
        if (otherPath != null) {
            int p;
            String[] otherPathEls = otherPath.split("/");
            String[] thisPathEls = fullPath.split("/");
            for (p = 0; (p < otherPathEls.length || p < thisPathEls.length) && otherPathEls[p].equalsIgnoreCase(thisPathEls[p]); ++p) {
            }
            int points = thisPathEls.length - p - 1;
            String newPath = "";
            for (int j = 0; j < points; ++j) {
                newPath = newPath + "../";
            }
            String slash = "";
            while (p < otherPathEls.length) {
                newPath = newPath + slash + otherPathEls[p];
                slash = "/";
                ++p;
            }
            sb.append(depth);
            sb.append(newPath);
            sb.append(" (L)\n");
        } else {
            String sign;
            this.alreadyDone.put(id, fullPath);
            sb.append(depth);
            sb.append(name);
            if (item instanceof MetaDbPropertyEntryObjectClientBean) {
                String value;
                MetaDbPropertyEntryObjectClientBean entry = (MetaDbPropertyEntryObjectClientBean)item;
                if (entry.getEntryDataType() == 1L) {
                    value = this.convertContent(entry.getStringValue());
                    sign = value.contains("\n") ? "C" : "E";
                } else if (entry.getEntryDataType() == 8192L) {
                    sign = "X";
                    value = "xxxxxxxx";
                } else if (entry.getEntryDataType() == 64L) {
                    sign = "E";
                    CharSequence[] arr = entry.getStringArrayValue();
                    value = arr == null ? "" : String.join((CharSequence)"||", arr);
                } else if (entry.getEntryDataType() == 4096L) {
                    sign = "C";
                    value = this.convertContent(entry.getContentString());
                } else {
                    throw new Exception("Unknown entry type: " + entry.getClass().getName() + " at " + fullPath);
                }
                sb.append("=");
                sb.append(value);
            } else if (item instanceof MetaDbPropertyBundleObjectClientBean) {
                sign = "B";
            } else if (item instanceof MetaDbPropertyGroupObjectClientBean) {
                sign = "G";
            } else {
                throw new Exception("Unknown object type: " + item.getClass().getName() + " at " + fullPath);
            }
            sb.append(" (");
            sb.append(sign);
            sb.append(")\n");
            if (item instanceof FolderObjectClientBean) {
                for (GlobalObjectClientBean subItem : ((FolderObjectClientBean)item).items()) {
                    this.metaDbWalker(sessionController, subItem, fullPath, depth + "|", sb);
                }
            }
        }
    }

    private String convertContent(String value) {
        return value.replace("\r\n", "\n").replace("\n", "\\\n");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: ngfs-user ngs-password metaDbPath [output]");
        } else {
            String userName = args[0];
            String passWord = args[1];
            String metaDbPath = args[2];
            String defFile = null;
            if (args.length > 3) {
                defFile = args[3];
            }
            try {
                new MetaDbExtractor(userName, passWord, metaDbPath, defFile).extract();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

