/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.lucene.common;

import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.List;

public class Personalize {
    private static boolean validKeyChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    private static List<String> tokenize(String query) {
        Accumulator tokens = new Accumulator();
        boolean escaped = false;
        boolean quoted = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (escaped) {
                if (!Personalize.validKeyChar(c)) {
                    tokens.add('\\');
                }
                tokens.add(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (quoted) {
                tokens.add(c);
                if (c != '\"') continue;
                tokens.next();
                quoted = false;
                continue;
            }
            if (c == '\"') {
                tokens.next();
                tokens.add(c);
                quoted = true;
                continue;
            }
            if (Personalize.validKeyChar(c)) {
                tokens.add(c);
                continue;
            }
            tokens.next();
            tokens.add(c);
            tokens.next();
        }
        return tokens.getTokens();
    }

    public static String getPrefix(SessionController sessionController) throws Exception {
        return "user_" + sessionController.getLoginUserUuid().replace("-", "");
    }

    public static String field(String prefix, String field) {
        if (field.startsWith("user_")) {
            return prefix + field.substring(4);
        }
        return field;
    }

    public static String fieldReverse(String prefix, String field) {
        if (field.startsWith(prefix)) {
            return "user" + field.substring(prefix.length());
        }
        if (field.startsWith("user_")) {
            return null;
        }
        return field;
    }

    public static String query(String prefix, String query) {
        StringBuilder personalized = new StringBuilder();
        List<String> tokens = Personalize.tokenize(query);
        int len = tokens.size();
        if (len == 0) {
            return "";
        }
        for (int i = 0; i < len - 1; ++i) {
            String token = tokens.get(i);
            if (token.startsWith("user_") && tokens.get(i + 1).equals(":")) {
                personalized.append(prefix);
                personalized.append(token.substring(4));
                continue;
            }
            personalized.append(token);
        }
        personalized.append(tokens.get(len - 1));
        return personalized.toString();
    }

    public static String query(SessionController sessionController, String query) throws Exception {
        return Personalize.query(Personalize.getPrefix(sessionController), query);
    }

    private static class Accumulator {
        private final List<String> tokens = new ArrayList<String>();
        StringBuilder current = new StringBuilder();

        private Accumulator() {
        }

        public void add(char c) {
            this.current.append(c);
        }

        public void next() {
            if (this.current.length() > 0) {
                this.tokens.add(this.current.toString());
            }
            this.current = new StringBuilder();
        }

        public List<String> getTokens() {
            this.next();
            return this.tokens;
        }
    }
}

