/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server.common;

import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseResponseBean;
import agorum.roi.interfaces.webservices.server.common.WebServiceTransactionHandler;

public class WebServiceCallerThread
extends Thread {
    private WebServiceTransactionHandler transactionHandler = null;
    private BaseRequestBean requestBean = null;
    private BaseResponseBean responseBean = null;
    private String serviceFunction = null;
    private boolean eventWasSet = false;

    public WebServiceCallerThread(WebServiceTransactionHandler transactionHandler, BaseRequestBean requestBean, String serviceFunction) {
        this.transactionHandler = transactionHandler;
        this.requestBean = requestBean;
        this.serviceFunction = serviceFunction;
    }

    public synchronized void notifyMe() throws Exception {
        this.eventWasSet = true;
        this.notify();
    }

    public synchronized void waitForEvent() throws Exception {
        this.eventWasSet = false;
        while (!this.eventWasSet) {
            this.wait();
        }
    }

    @Override
    public void run() {
    }

    public void runner() {
        try {
            if (this.transactionHandler == null) {
                WebServiceTransactionHandler transactionHandler = new WebServiceTransactionHandler(0L);
                this.responseBean = transactionHandler.callService(this.requestBean, this.serviceFunction);
            } else {
                this.transactionHandler.performService(this.serviceFunction, this.requestBean, this);
                while (!this.transactionHandler.hasProcessed()) {
                    this.waitForEvent();
                }
                this.responseBean = this.transactionHandler.getOutputResponseBean();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public BaseResponseBean getResponseBean() {
        return this.responseBean;
    }
}

