/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.webservices.client.beans.common.BaseItemsRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceDeleteItemsRequestBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceGetItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceHasNewItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceIsUserControlObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceIsUserControlObjectResponseBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceUserControlObjectRequestBean;
import agorum.roi.interfaces.webservices.client.common.WebServiceErrorKeys;
import agorum.roi.interfaces.webservices.server.BaseItemService;
import agorum.roi.sessionfacade.beans.AppUserProfileObjectSessionFacade;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class EventAssistanceService
extends BaseItemService {
    public EventAssistanceService(WebServiceSessionBean wsSessionBean) {
        super(wsSessionBean);
    }

    public EventAssistanceGetItemsResponseBean eventAssistanceGetItems(BaseItemsRequestBean requestBean) {
        EventAssistanceGetItemsResponseBean responseBean = new EventAssistanceGetItemsResponseBean();
        try {
            int len;
            int amount;
            ArrayList<agorum.roi.ejb.common.EventAssistanceBean> all;
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            int startIndex = requestBean.getStartItem();
            int endIndex = requestBean.getStartItem() + requestBean.getItemsPerRequest();
            if (endIndex == startIndex) {
                endIndex = startIndex + 100000000;
            }
            if ((all = sessionController.getEventAssistanceList(amount = endIndex)) != null && (len = all.size()) >= startIndex + 1) {
                int anz = endIndex - startIndex;
                if (anz + startIndex > len) {
                    anz -= anz + startIndex - len;
                }
                Vector<EventAssistanceBean> v = new Vector<EventAssistanceBean>();
                for (int i = 0; i < anz; ++i) {
                    int pos = i + startIndex;
                    agorum.roi.ejb.common.EventAssistanceBean eaBean = all.get(pos);
                    EventAssistanceBean myEABean = new EventAssistanceBean();
                    myEABean.setId(eaBean.getId());
                    myEABean.setType(eaBean.getType());
                    myEABean.setClassName(eaBean.getClassName());
                    try {
                        GlobalObjectClientBean clientBean = sessionController.getGlobalObjectById(eaBean.getId());
                        clientBean = clientBean.getMainObject();
                        ItemBean itemBean = this.fillItemBean(clientBean, requestBean.getRequestAttributes(), null);
                        myEABean.setItemBean(itemBean);
                        v.addElement(myEABean);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (v.size() > 0) {
                    this.updateUserTimeStamp(sessionController);
                    int lenV = v.size();
                    EventAssistanceBean[] eventAssistanceBeans = new EventAssistanceBean[lenV];
                    for (int i = 0; i < lenV; ++i) {
                        eventAssistanceBeans[i] = (EventAssistanceBean)v.elementAt(i);
                    }
                    responseBean.setEventAssistanceBeans(eventAssistanceBeans);
                    responseBean.setResultCount(lenV);
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public EventAssistanceHasNewItemsResponseBean eventAssistanceHasNewItems(BaseRequestBean requestBean) {
        EventAssistanceHasNewItemsResponseBean responseBean;
        block7: {
            responseBean = new EventAssistanceHasNewItemsResponseBean();
            try {
                SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
                ArrayList<agorum.roi.ejb.common.EventAssistanceBean> all = sessionController.getEventAssistanceList(1);
                if (all == null || all.size() <= 0) break block7;
                agorum.roi.ejb.common.EventAssistanceBean eaBean = all.get(0);
                try {
                    GlobalObjectClientBean clientBean = sessionController.getGlobalObjectById(eaBean.getId());
                    AppUserProfileObjectClientBean aupocb = sessionController.getLoginUser().getApplicationUserProfile("webservice", "agorum.roiwebui.EventAssistanceLastAccessTime");
                    long lastAccessTime = 0L;
                    if (aupocb != null) {
                        lastAccessTime = new Long(aupocb.getAppValue());
                    }
                    if (lastAccessTime < clientBean.getLastModifyDate().getTime()) {
                        responseBean.setHasNewItems(true);
                        this.updateUserTimeStamp(sessionController);
                    }
                }
                catch (Exception exception) {}
            }
            catch (RoiException re) {
                responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
                responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
                responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            }
        }
        return responseBean;
    }

    public BaseResponseBean eventAssistanceDeleteItems(EventAssistanceDeleteItemsRequestBean requestBean) {
        BaseResponseBean responseBean = new BaseResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            ObjectLookupBean[] objects = requestBean.getObjects();
            if (objects != null) {
                int len = objects.length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean globalObject = this.lookupObject(sessionController, objects[i]);
                    sessionController.setEventAssistanceEntryRead(globalObject.getId());
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public BaseResponseBean eventAssistanceDeleteAllItems(BaseRequestBean requestBean) {
        BaseResponseBean responseBean = new BaseResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            sessionController.setEventAssistanceAllRead();
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public BaseResponseBean eventAssistanceCreateUserControlObjects(EventAssistanceUserControlObjectRequestBean requestBean) {
        BaseResponseBean responseBean = new BaseResponseBean();
        try {
            ObjectLookupBean[] objects;
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            ObjectLookupBean userObject = requestBean.getUser();
            DirectoryUserObjectClientBean user = null;
            if (userObject != null) {
                user = (DirectoryUserObjectClientBean)this.lookupObject(sessionController, userObject);
            }
            if ((objects = requestBean.getObjects()) != null) {
                int len = objects.length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean globalObject = this.lookupObject(sessionController, objects[i]);
                    if (this.getObjectUserControl(sessionController, globalObject, user) != null) continue;
                    this.createEventAssistanceUserControl(sessionController, globalObject, user);
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public BaseItemsResponseBean eventAssistanceGetUserControlObjects(EventAssistanceUserControlObjectRequestBean requestBean) {
        BaseItemsResponseBean responseBean = new BaseItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            ObjectLookupBean userObject = requestBean.getUser();
            DirectoryUserObjectClientBean user = null;
            user = userObject != null ? (DirectoryUserObjectClientBean)this.lookupObject(sessionController, userObject) : sessionController.getLoginUser();
            AppUserProfileObjectClientBean[] allApp = user.getApplicationUserProfiles("EventAssistance");
            Vector<ItemBean> v = new Vector<ItemBean>();
            if (allApp != null) {
                int len = allApp.length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean globalObject = sessionController.getGlobalObjectById(new Long(allApp[i].getAppKeyWord()));
                    ItemBean itemBean = this.fillItemBean(globalObject, requestBean.getRequestAttributes(), null);
                    v.addElement(itemBean);
                }
                if (v.size() > 0) {
                    int lenV = v.size();
                    ItemBean[] allItems = new ItemBean[lenV];
                    for (int i = 0; i < lenV; ++i) {
                        allItems[i] = (ItemBean)v.elementAt(i);
                    }
                    responseBean.setItems(allItems);
                    responseBean.setResultCount(lenV);
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public BaseResponseBean eventAssistanceRemoveUserControlObjects(EventAssistanceUserControlObjectRequestBean requestBean) {
        BaseResponseBean responseBean = new BaseResponseBean();
        try {
            ObjectLookupBean[] objects;
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            ObjectLookupBean userObject = requestBean.getUser();
            DirectoryUserObjectClientBean user = null;
            if (userObject != null) {
                user = (DirectoryUserObjectClientBean)this.lookupObject(sessionController, userObject);
            }
            if ((objects = requestBean.getObjects()) != null) {
                int len = objects.length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean globalObject = this.lookupObject(sessionController, objects[i]);
                    AppUserProfileObjectClientBean appObject = this.getObjectUserControl(sessionController, globalObject, user);
                    if (appObject == null) continue;
                    appObject.delete();
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public EventAssistanceIsUserControlObjectResponseBean eventAssistanceIsUserControlObject(EventAssistanceIsUserControlObjectRequestBean requestBean) {
        EventAssistanceIsUserControlObjectResponseBean responseBean = new EventAssistanceIsUserControlObjectResponseBean();
        try {
            ObjectLookupBean object;
            GlobalObjectClientBean globalObject;
            AppUserProfileObjectClientBean appObject;
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            ObjectLookupBean userObject = requestBean.getUser();
            DirectoryUserObjectClientBean user = null;
            if (userObject != null) {
                user = (DirectoryUserObjectClientBean)this.lookupObject(sessionController, userObject);
            }
            if ((appObject = this.getObjectUserControl(sessionController, globalObject = this.lookupObject(sessionController, object = requestBean.getObject()), user)) != null) {
                responseBean.setIsUserControl(true);
            } else {
                responseBean.setIsUserControl(false);
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    private AppUserProfileObjectClientBean getObjectUserControl(SessionController sessionController, GlobalObjectClientBean clientBean, DirectoryUserObjectClientBean user) throws Exception {
        user = user == null ? sessionController.getLoginUser() : user;
        AppUserProfileObjectClientBean app = user.getApplicationUserProfile("EventAssistance", "" + clientBean.getId());
        return app;
    }

    private void updateUserTimeStamp(SessionController sessionController) throws Exception {
        AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(sessionController);
        auposf.setWithTransaction(true);
        DirectoryUserObjectClientBean user = sessionController.getLoginUser();
        AppUserProfileObjectClientBean aupocb = user.getApplicationUserProfile("webservice", "agorum.roiwebui.EventAssistanceLastAccessTime");
        boolean create = true;
        if (aupocb != null) {
            auposf.setGlobalObject(aupocb);
            create = false;
        } else {
            create = true;
        }
        auposf.setValue("" + new Date().getTime());
        auposf.setKeyword("agorum.roiwebui.EventAssistanceLastAccessTime");
        auposf.setApplication("webservice");
        if (create) {
            auposf.create();
        } else {
            auposf.update();
        }
    }

    private void createEventAssistanceUserControl(SessionController sessionController, GlobalObjectClientBean clientBean, DirectoryUserObjectClientBean user) throws Exception {
        AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(sessionController);
        auposf.setWithTransaction(true);
        auposf.setApplication("EventAssistance");
        auposf.setKeyword("" + clientBean.getId());
        auposf.setValue("");
        auposf.setDirectoryUserObject(user == null ? sessionController.getLoginUser() : user);
        AppUserProfileObjectClientBean appUp = (AppUserProfileObjectClientBean)auposf.create();
    }
}

