/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.util.Vector;

public class BaseItemService {
    protected WebServiceSessionBean wsSessionBean = null;

    public BaseItemService(WebServiceSessionBean wsSessionBean) {
        this.wsSessionBean = wsSessionBean;
    }

    protected ItemBean fillItemBean(GlobalObjectClientBean globalObject, String[] requestedAttributes, String myPath) {
        return this.fillItemBean(globalObject, requestedAttributes, myPath, -1000);
    }

    protected ItemBean fillItemBean(GlobalObjectClientBean globalObject, String[] requestedAttributes, String myPath, int depth) {
        ItemBean itemBean = new ItemBean();
        int len = requestedAttributes.length;
        String[] responseAttributes = new String[len];
        for (int i = 0; i < len; ++i) {
            String attribute = requestedAttributes[i];
            if (attribute.equalsIgnoreCase("anyPath")) {
                try {
                    if (myPath != null) {
                        responseAttributes[i] = "\"" + myPath + "\"";
                        continue;
                    }
                    responseAttributes[i] = "\"" + globalObject.getAnyFolderPath() + "\"";
                }
                catch (Exception e) {
                    responseAttributes[i] = "null";
                }
                continue;
            }
            if (attribute.equalsIgnoreCase("depth") && depth != -1000) {
                responseAttributes[i] = "\"" + depth + "\"";
                continue;
            }
            if (attribute.equalsIgnoreCase("id")) {
                try {
                    responseAttributes[i] = "\"" + globalObject.getId().toString() + "\"";
                }
                catch (Exception e) {
                    responseAttributes[i] = "null";
                }
                continue;
            }
            if (attribute.equalsIgnoreCase("classname")) {
                try {
                    responseAttributes[i] = "\"" + globalObject.getClassName() + "\"";
                }
                catch (Exception e) {
                    responseAttributes[i] = "null";
                }
                continue;
            }
            try {
                responseAttributes[i] = globalObject.getAttribute(attribute).toString(globalObject.getSessionController());
                continue;
            }
            catch (Exception e) {
                responseAttributes[i] = "null";
            }
        }
        itemBean.setAttributes(responseAttributes);
        return itemBean;
    }

    protected ItemBean[] getItemBeans(Vector itemList) throws Exception {
        if (itemList != null) {
            int len = itemList.size();
            ItemBean[] itemBeans = new ItemBean[len];
            for (int i = 0; i < len; ++i) {
                itemBeans[i] = (ItemBean)itemList.elementAt(i);
            }
            return itemBeans;
        }
        return null;
    }

    protected GlobalObjectClientBean lookupObject(SessionController sessionController, ObjectLookupBean olBean) throws Exception {
        if (olBean.getFullPath() != null && olBean.getFullPath().length() > 0) {
            return sessionController.findGlobalObjectByPath(olBean.getFullPath());
        }
        if (olBean.getObjectId() != -1L) {
            return sessionController.getGlobalObjectById(new Long(olBean.getObjectId()));
        }
        if (olBean.getClassName() != null && olBean.getName() != null && olBean.getClassName().length() > 0 && olBean.getName().length() > 0) {
            ClassObjectClientBean classObject = sessionController.getClassObject(olBean.getClassName());
            SuperObjectClientBean[] soArr = sessionController.getSuperObjectByAttribute(sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, olBean.getName(), true, classObject);
            if (soArr != null && soArr.length > 0) {
                return (GlobalObjectClientBean)soArr[0];
            }
        }
        return null;
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

