/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.filing.WsGetItemsAttributes;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;

public class TestPerformance
extends TestBaseClass {
    public TestPerformance(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    public void test(LoginResponseBean loginResponseBean) throws Exception {
        for (int i = 0; i < 1; ++i) {
            TestThread tt = new TestThread(loginResponseBean);
            tt.start();
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: TestGetObjectByAttribute <UserName> <PassWord>");
        } else {
            try {
                TestPerformance test = new TestPerformance(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.test(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("ende test");
        }
    }

    private class TestThread
    extends Thread {
        private LoginResponseBean loginResponseBean = null;

        private TestThread(LoginResponseBean resp) {
            this.loginResponseBean = resp;
        }

        @Override
        public void run() {
            try {
                int n;
                ItemBean[] items;
                ItemsResponseBean resp;
                ObjectLookupBean objectLookupBean;
                WsGetItemsAttributes wsgi;
                int i;
                long startTime = System.currentTimeMillis();
                int count = 100;
                for (i = 0; i < count; ++i) {
                    wsgi = new WsGetItemsAttributes(this.loginResponseBean, TestPerformance.this.getUrl(), null);
                    wsgi.addAttribute("ID");
                    wsgi.addAttribute("NAME");
                    wsgi.addAttribute("CLASSNAME");
                    objectLookupBean = new ObjectLookupBean();
                    objectLookupBean.setObjectId(1003545L);
                    wsgi.addObject(objectLookupBean);
                    resp = wsgi.doWs();
                    items = resp.getItems();
                    n = items.length;
                }
                System.err.println("Time 1: " + (System.currentTimeMillis() - startTime) / (long)count + "\n\n");
                startTime = System.currentTimeMillis();
                for (i = 0; i < count; ++i) {
                    wsgi = new WsGetItemsAttributes(this.loginResponseBean, TestPerformance.this.getUrl(), null);
                    wsgi.addAttribute("ID");
                    wsgi.addAttribute("NAME");
                    wsgi.addAttribute("CLASSNAME");
                    wsgi.addAttribute("DESCRIPTION");
                    wsgi.addAttribute("OWNER");
                    wsgi.addAttribute("CREATOR");
                    wsgi.addAttribute("CREATEDATE");
                    wsgi.addAttribute("LASTMODIFYDATE");
                    wsgi.addAttribute("ACL");
                    wsgi.addAttribute("LASTMODIFIER");
                    wsgi.addAttribute("DELETOR");
                    wsgi.addAttribute("LOCKSTATE");
                    wsgi.addAttribute("FLAGS");
                    wsgi.addAttribute("SYSTEMFLAGS");
                    wsgi.addAttribute("LOCKEDFORSESSION");
                    wsgi.addAttribute("MAINOBJECT");
                    wsgi.addAttribute("EXPIRATIONDATE");
                    wsgi.addAttribute("ISFOLDER");
                    wsgi.addAttribute("OBJECTTEXTKEY");
                    objectLookupBean = new ObjectLookupBean();
                    objectLookupBean.setObjectId(1003545L);
                    wsgi.addObject(objectLookupBean);
                    resp = wsgi.doWs();
                    items = resp.getItems();
                    n = items.length;
                }
                System.err.println("Time 2: " + (System.currentTimeMillis() - startTime) / (long)count + "\n\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

