/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.extendedsearch;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.extendedsearch.ExtendedSearchInterface;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Hashtable;

public class ExtendedSearchUtils {
    public static final String DATATYPE_DATEDATE = "DATEDATE";
    public static final String DATATYPE_DATETIME = "DATETIME";

    public String makeQuery(String[] classes, Hashtable attributes, SessionController sessionController) throws Exception {
        String query = null;
        if (classes != null && classes.length > 0) {
            int len = classes.length;
            for (int i = 0; i < len; ++i) {
                Class<?> extendedSearchClass;
                ExtendedSearchInterface extendedSearchInterface;
                String query1;
                if (classes[i] == null || (query1 = (extendedSearchInterface = (ExtendedSearchInterface)(extendedSearchClass = Class.forName(classes[i])).newInstance()).getQuery(attributes, sessionController)) == null || query1.length() == 0) continue;
                query = this.buildORQuery(query, query1);
            }
        }
        return query;
    }

    public String buildQuery(Object value, String attributeName, String dataType) throws Exception {
        String query = null;
        if (value != null) {
            if (!value.getClass().isArray()) {
                String v = this.getValueFromDataType(value, dataType, 0);
                if (v != null && v.length() != 0) {
                    query = "(" + v + ")";
                }
            } else {
                String or = "";
                int len = Array.getLength(value);
                for (int i = 0; i < len; ++i) {
                    String v = this.getValueFromDataType(Array.get(value, i), dataType, 0);
                    if (v == null || v.length() == 0) continue;
                    if (query == null) {
                        query = "(";
                    }
                    query = query + or + "\"" + v + "\"";
                    or = " OR ";
                }
                if (query != null) {
                    query = query + ")";
                }
            }
            if (query != null && attributeName != null && attributeName.length() > 1) {
                query = attributeName.toLowerCase() + ":" + query;
            }
        }
        return query;
    }

    public String buildToQuery(Object valueFrom, Object valueTo, String attributeName, String dataType) throws Exception {
        String query = null;
        if (valueFrom != null || valueTo != null) {
            String valueFromStr = this.getValueFromDataType(valueFrom, dataType, -1);
            String valueToStr = this.getValueFromDataType(valueTo, dataType, 1);
            query = "";
            if (attributeName != null && attributeName.length() > 1) {
                query = attributeName.toLowerCase() + ":";
            }
            query = query + "[" + valueFromStr + " TO " + valueToStr + "]";
        }
        return query;
    }

    public String getValueFromDataType(Object value, String dataType, int returnValueMaxMin) {
        String retValue = null;
        if (dataType.equals("STRING")) {
            retValue = (String)value;
        } else if (dataType.equals(DATATYPE_DATEDATE)) {
            if (value != null || returnValueMaxMin == 0) {
                if (value instanceof String) {
                    retValue = (String)value;
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    retValue = sdf.format(value);
                }
            } else if (returnValueMaxMin == -1) {
                retValue = "00010101";
            } else if (returnValueMaxMin == 1) {
                retValue = "99991231";
            }
        } else if (dataType.equals(DATATYPE_DATETIME)) {
            if (value != null || returnValueMaxMin == 0) {
                if (value instanceof String) {
                    retValue = (String)value;
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm00");
                    retValue = sdf.format(value);
                }
            } else if (returnValueMaxMin == -1) {
                retValue = "00010101000000";
            } else if (returnValueMaxMin == 1) {
                retValue = "99991231235959";
            }
        } else if (dataType.equals("INTEGER")) {
            if (value instanceof String) {
                value = new Integer((String)value);
            }
            if (value == null) {
                if (returnValueMaxMin == -1) {
                    value = new Integer(0);
                } else if (returnValueMaxMin == 1) {
                    value = new Integer(Integer.MAX_VALUE);
                }
            }
            if (value != null || returnValueMaxMin == 0) {
                retValue = AttributeValue.setIntegerValue("0000000000", (Integer)value);
            }
        } else if (dataType.equals("DOUBLE")) {
            if (value instanceof String) {
                value = new Double((String)value);
            }
            if (value == null) {
                if (returnValueMaxMin == -1) {
                    value = new Double(0.0);
                } else if (returnValueMaxMin == 1) {
                    value = new Double(9.99999999999999E14);
                }
            }
            if (value != null || returnValueMaxMin == 0) {
                retValue = AttributeValue.setDoubleValue("000000000000000.0000000000", '.', (Double)value);
            }
        }
        return retValue;
    }

    public String buildORQuery(String query1, String query2) throws Exception {
        String query = null;
        if (query1 != null && query1.length() > 0 && query2 != null && query2.length() > 0) {
            query = "((" + query1 + ") OR (" + query2 + "))";
        } else if (query1 != null && query1.length() > 0) {
            query = "(" + query1 + ")";
        } else if (query2 != null && query2.length() > 0) {
            query = "(" + query2 + ")";
        }
        return query;
    }

    public String buildANDQuery(String query1, String query2) throws Exception {
        String query = null;
        if (query1 != null && query1.length() > 0 && query2 != null && query2.length() > 0) {
            query = "((" + query1 + ") AND (" + query2 + "))";
        } else if (query1 != null && query1.length() > 0) {
            query = "(" + query1 + ")";
        } else if (query2 != null && query2.length() > 0) {
            query = "(" + query2 + ")";
        }
        return query;
    }

    public String getAllANDQuerys(String[][] sArr, Hashtable attributes) throws Exception {
        int len;
        String myQuery = "";
        String ancestors = null;
        if (sArr != null && attributes != null && (len = sArr.length) > 0) {
            String queryConnector = "";
            for (int i = 0; i < len; ++i) {
                String query = null;
                if (sArr[i][1] == null) {
                    if (attributes.containsKey(sArr[i][0])) {
                        query = this.buildQuery(attributes.get(sArr[i][0]), sArr[i][2], sArr[i][5]);
                    }
                } else if (attributes.containsKey(sArr[i][0]) || attributes.containsKey(sArr[i][1])) {
                    Object o1 = null;
                    if (attributes.containsKey(sArr[i][0])) {
                        o1 = attributes.get(sArr[i][0]);
                    }
                    Object o2 = null;
                    if (attributes.containsKey(sArr[i][1])) {
                        o2 = attributes.get(sArr[i][1]);
                    }
                    query = this.buildToQuery(o1, o2, sArr[i][2], sArr[i][5]);
                }
                if (query == null) continue;
                if (ancestors == null && sArr[i][3] != null) {
                    ancestors = myQuery = "ancestors:" + sArr[i][3];
                    queryConnector = " AND ";
                }
                myQuery = myQuery + queryConnector + "(" + query + (sArr[i][4] != null ? sArr[i][4] : "") + ")";
                queryConnector = " AND ";
            }
        }
        return myQuery;
    }
}

