/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.virtual;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.virtual.VirtualFolderDescription;
import agorum.roi.ejb.virtual.VirtualFolderStructure;
import agorum.roi.exception.RoiException;
import agorum.roi.statistic.SmartFolderStatistic;
import java.io.IOException;
import java.util.Date;
import org.codehaus.jackson.map.ObjectMapper;

public class VirtualFolderDescriptionProvider {
    private static final String ASF_TREE = "asf_tree";
    private static final int DEFAULT_MAX_CACHE_ENTRIES = 1000;
    private static final int DEFAULT_CACHE_PURGE_TIME = 5000;
    private static final int DEFAULT_CACHE_LIFETIME = 36000000;
    private static final String MAX_CACHE_ENTRIES = "MAIN_MODULE_MANAGEMENT/asf/maxCacheConfigurationEntries";
    private static final String MAX_PURGE_TIME = "MAIN_MODULE_MANAGEMENT/asf/maxCacheConfigurationPurgeTime";
    private static final String MAX_LIFE_TIME = "MAIN_MODULE_MANAGEMENT/asf/maxCacheConfigurationLifeTime";
    private VirtualFolderDescription description = null;
    private FolderObjectClientBean entryPoint = null;

    public VirtualFolderDescriptionProvider(FolderObjectClientBean entryPoint) {
        this.entryPoint = entryPoint;
    }

    public VirtualFolderDescriptionProvider(FolderObjectClientBean entryPoint, VirtualFolderDescription description) {
        this.description = description;
        this.entryPoint = entryPoint;
    }

    public VirtualFolderDescription getDescription() throws Exception {
        return this.provideDescription();
    }

    private VirtualFolderDescription provideDescription() throws Exception {
        if (this.description == null) {
            this.description = this.loadFolderStructure().getContent();
        }
        return this.description;
    }

    private VirtualFolderStructure loadFolderStructure() throws Exception {
        GlobalObjectClientBean currentBean;
        String configurationUUID = null;
        AttributeValue av = this.entryPoint.getExtendedAttribute(ASF_TREE);
        if (av != null) {
            configurationUUID = av.getString();
        }
        if (configurationUUID == null) {
            throw new RoiException("No tree definition found for folder with UUID " + this.entryPoint.getUUID());
        }
        int[] cacheSettings = this.determineCacheSettings();
        GenericCache uuidLookupCache = GenericCache.getInstance((Object)("Roi.FolderObjectClientBeanWrapper.uuidMapping." + this.entryPoint.getSessionController().getSessionId()), (int)cacheSettings[0], (int)cacheSettings[1], (int)cacheSettings[2]);
        Object cachedId = uuidLookupCache.get((Object)configurationUUID);
        if (cachedId != null) {
            currentBean = this.entryPoint.getSessionController().getGlobalObjectById((Long)cachedId);
        } else {
            currentBean = this.entryPoint.getSessionController().getGlobalObjectByUUID(configurationUUID);
            uuidLookupCache.put((Object)configurationUUID, (Object)currentBean.getId());
        }
        GenericCache descriptionCache = GenericCache.getInstance((Object)("Roi.FolderObjectClientBeanWrapper.Structures." + this.entryPoint.getSessionController().getSessionId()), (int)cacheSettings[0], (int)cacheSettings[1], (int)cacheSettings[2]);
        FolderDescriptionCacheEntry cachedConfiguration = (FolderDescriptionCacheEntry)descriptionCache.get((Object)configurationUUID);
        if (cachedConfiguration != null) {
            if (!currentBean.getLastModifyDate().equals(cachedConfiguration.getLastModifyDate())) {
                cachedConfiguration = this.createFolderDescriptionCacheEntry(currentBean);
                descriptionCache.put((Object)configurationUUID, (Object)cachedConfiguration);
                return cachedConfiguration.getStructure();
            }
            return cachedConfiguration.getStructure();
        }
        cachedConfiguration = this.createFolderDescriptionCacheEntry(currentBean);
        descriptionCache.put((Object)configurationUUID, (Object)cachedConfiguration);
        return cachedConfiguration.getStructure();
    }

    private FolderDescriptionCacheEntry createFolderDescriptionCacheEntry(GlobalObjectClientBean currentBean) throws Exception {
        FolderDescriptionCacheEntry entry = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            FileObjectClientBean focb = (FileObjectClientBean)currentBean;
            VirtualFolderStructure folderStructure = (VirtualFolderStructure)objectMapper.readValue(focb.getContentString(), VirtualFolderStructure.class);
            entry = new FolderDescriptionCacheEntry(currentBean.getLastModifyDate(), folderStructure);
        }
        catch (IOException e) {
            SmartFolderStatistic.getInstance().error(e, "Faulty configuration: " + currentBean.getUUID());
            throw new RoiException("Faulty configuration: " + currentBean.getUUID());
        }
        return entry;
    }

    private int[] determineCacheSettings() {
        int[] cacheSettings = new int[3];
        MetaDb metaDb = this.entryPoint.getSessionController().getMetaDbInstance();
        int maxCacheEntries = 1000;
        String[] configuredMaxCacheEntries = metaDb.getSimplePropertyValue(MAX_CACHE_ENTRIES);
        if (configuredMaxCacheEntries != null && configuredMaxCacheEntries.length > 0) {
            maxCacheEntries = Integer.parseInt(configuredMaxCacheEntries[0]);
        }
        cacheSettings[0] = maxCacheEntries;
        int maxPurgeTime = 5000;
        String[] configuredMaxPurgeTime = metaDb.getSimplePropertyValue(MAX_PURGE_TIME);
        if (configuredMaxPurgeTime != null && configuredMaxPurgeTime.length > 0) {
            maxPurgeTime = Integer.parseInt(configuredMaxPurgeTime[0]);
        }
        cacheSettings[1] = maxPurgeTime;
        int maxLifeTime = 36000000;
        String[] configuredMaxLifeTime = metaDb.getSimplePropertyValue(MAX_LIFE_TIME);
        if (configuredMaxLifeTime != null && configuredMaxLifeTime.length > 0) {
            maxLifeTime = Integer.parseInt(configuredMaxLifeTime[0]);
        }
        cacheSettings[2] = maxLifeTime;
        return cacheSettings;
    }

    private class FolderDescriptionCacheEntry {
        private Date lastModifyDate;
        private VirtualFolderStructure structure;

        public FolderDescriptionCacheEntry(Date lastModifyDate, VirtualFolderStructure structure) {
            this.lastModifyDate = lastModifyDate;
            this.structure = structure;
        }

        public Date getLastModifyDate() {
            return this.lastModifyDate;
        }

        public VirtualFolderStructure getStructure() {
            return this.structure;
        }
    }
}

