/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.OldPathIndexServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.statistic.metadata.MetadataInheritanceStatistic;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;

public class OldPathIndexService
implements OldPathIndexServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private long count = 0L;
    private boolean isStarted = false;
    private MessageConnectionHolder messageConnectionHolder = null;
    private SessionController sessionController = null;
    private Vector queue = new Vector();
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;
    private long amount = 0L;
    private RoiTransactionHandler globalRTH = null;
    public static boolean stopTest = false;
    private static final MetadataInheritanceStatistic stat = MetadataInheritanceStatistic.getInstance();
    long globalAmount = 0L;

    @Override
    public void start() {
        System.out.println("---------- Starting Path Index Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting path index service...\n\n", "");
        final OldPathIndexService jmsEventListener = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                System.out.println("PathIndexService: Service is started");
                try {
                    OldPathIndexService.this.connectEvents();
                    OldPathIndexService.this.jmsBean = new JMSEventListenerBean();
                    OldPathIndexService.this.jmsBean.setId("PathIndexService_" + jmsEventListener.hashCode());
                    OldPathIndexService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    OldPathIndexService.this.eventController = JMSEventController.getInstance();
                    OldPathIndexService.this.eventController.registerListener(OldPathIndexService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stop() {
        System.out.println("---------- Stopping Path Index Service -------------");
        try {
            this.disconnectEvents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolder = messageUtils.registerSubScriber(this, "pathIndexListener");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        try {
            MessageUtils mu = new MessageUtils();
            mu.unregisterSubScriber(this.messageConnectionHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "pathIndexListener");
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private synchronized Long queueing(Long countL) {
        ++this.count;
        if (countL != null) {
            this.queue.addElement(new Long(this.count));
            return null;
        }
        Long nextCount = null;
        if (this.queue.size() > 0) {
            nextCount = (Long)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
        }
        return nextCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (SessionController.getImportMode()) {
            return;
        }
        if (!this.eventController.checkMyEvent(this.jmsBean, msg)) {
            System.out.println("==== Path Index Service, got event ====");
            Long countL = new Long(this.count);
            this.queueing(countL);
            if (!this.isStarted()) {
                RoiTransactionHandler rth = null;
                while ((countL = this.queueing(null)) != null && !SessionController.getImportMode()) {
                    Connection conn = null;
                    ConnectionUtils cu = new ConnectionUtils(null);
                    Statement ps = null;
                    ResultSet rs = null;
                    try {
                        boolean hasMore = true;
                        while (hasMore && !SessionController.getImportMode()) {
                            this.connect();
                            conn = cu.getConnection();
                            String minSelect = "select min(SORTID) from topathindex";
                            ps = conn.prepareStatement(minSelect);
                            rs = ps.executeQuery();
                            long minSortId = -1L;
                            if (rs != null && rs.next()) {
                                minSortId = rs.getLong(1);
                            }
                            rs.close();
                            ps.close();
                            rs = null;
                            ps = null;
                            if (minSortId >= 0L) {
                                String select = "select ID,SORTID from topathindex where SORTID = ? ";
                                long id = -1L;
                                ps = conn.prepareStatement(select);
                                ps.setLong(1, minSortId);
                                rs = ps.executeQuery();
                                if (rs != null && rs.next()) {
                                    id = rs.getLong(1);
                                }
                                rs.close();
                                ps.close();
                                rs = null;
                                ps = null;
                                cu.closeConnection();
                                conn = null;
                                if (id > 0L) {
                                    try {
                                        this.pathWalker(id);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    this.connect();
                                    conn = cu.getConnection();
                                    rth = new RoiTransactionHandler();
                                    rth.begin();
                                    try {
                                        ps = conn.prepareStatement("delete from topathindex where ID=?");
                                        ps.setLong(1, id);
                                        ps.execute();
                                        ps.close();
                                        ps = null;
                                        rth.end();
                                        rth = null;
                                    }
                                    finally {
                                        if (rth != null) {
                                            rth.abort();
                                        }
                                        if (conn != null) {
                                            cu.closeConnection();
                                            conn = null;
                                        }
                                    }
                                }
                                hasMore = false;
                            } else {
                                hasMore = false;
                            }
                            if (conn == null) continue;
                            cu.closeConnection();
                            conn = null;
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception hasMore) {}
                        }
                        rs = null;
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Exception hasMore) {}
                        }
                        ps = null;
                        try {
                            if (conn == null) continue;
                            cu.closeConnection();
                        }
                        catch (Exception hasMore) {}
                    }
                }
                this.isStarted = false;
            }
        }
    }

    private void pathWalker(long id) throws Exception {
        try {
            System.out.println("PathIndex: Begin PathWalk: " + id);
            this.amount = 0L;
            this.globalRTH = new RoiTransactionHandler();
            this.globalRTH.begin();
            GlobalObjectClientBean obj = null;
            try {
                obj = this.sessionController.getGlobalObjectById(new Long(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj != null) {
                this.pathWalkerRec(obj, new HashSet<Long>());
            }
            System.out.println("PathIndex: End PathWalk");
            this.globalRTH.end();
            this.globalRTH = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            if (this.globalRTH != null) {
                try {
                    this.globalRTH.abort();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void pathWalkerRec(GlobalObjectClientBean gocb, Set<Long> ids) throws Exception {
        MessageUtils mu = new MessageUtils();
        mu.sendUpdatePathEvent(gocb, null);
        ++this.amount;
        ++this.globalAmount;
        if (this.amount > 100L) {
            String actFolder = null;
            try {
                actFolder = gocb.getAnyFolderPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("PathIndex: commit for " + this.globalAmount + ", " + actFolder);
            this.globalRTH.end();
            this.globalRTH = new RoiTransactionHandler();
            this.globalRTH.begin();
            this.amount = 0L;
        }
        if (gocb instanceof FolderObjectClientBean) {
            for (SuperObjectClientBean superObjectClientBean : ((FolderObjectClientBean)gocb).items()) {
                if (!ids.add(superObjectClientBean.getId())) continue;
                this.pathWalkerRec((GlobalObjectClientBean)superObjectClientBean, ids);
            }
        }
        stat.debug().objectId(gocb.getId()).send("PathIndex Object");
        for (SuperObjectClientBean superObjectClientBean : gocb.getIndexSubObjects()) {
            stat.debug().objectId(superObjectClientBean.getId()).send("PathIndex subobject");
            if (!(superObjectClientBean instanceof GlobalObjectClientBean) || superObjectClientBean.equals(gocb) || !ids.add(superObjectClientBean.getId())) continue;
            this.pathWalkerRec((GlobalObjectClientBean)superObjectClientBean, ids);
        }
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setModulInfo("PathIndexService");
                credential.setAuthInterface(new ServiceAuthInterface());
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }
}

