/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.roi.ejb.mbeans.GenericTimerServiceMBean;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class GenericTimerService
implements GenericTimerServiceMBean {
    private long delay = -1L;
    private long period = -1L;
    private String date = null;
    private String hour = null;
    private String minute = null;
    private SystemTimer timer = null;

    @Override
    public void start() {
        Date startDate = null;
        try {
            AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
            startLogger.writeDescToFile("Starting generic timer service...\n\n", "");
            if (this.date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                startDate = sdf.parse(this.date);
            } else if (this.hour != null && this.minute != null) {
                startDate = new Date();
                startDate.setHours(Integer.parseInt(this.hour));
                startDate.setMinutes(Integer.parseInt(this.minute));
                if (startDate.getTime() < System.currentTimeMillis()) {
                    startDate = new Date(startDate.getTime() + 86400000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("**************************************************");
        System.err.println("TimerTask, class: " + this.getClass().getName());
        if (this.delay != -1L && this.period != -1L) {
            System.err.println("Timer: Delay: " + this.delay + ", Period: " + this.period);
            this.timer = SystemTimer.ofDelay((long)(this.delay * 1000L * 60L), (long)(this.period * 1000L * 60L)).name("GenericTimerService").call(this.getTimerTask());
        } else if (this.delay != -1L) {
            System.err.println("Timer: Delay: " + this.delay);
            this.timer = SystemTimer.ofDelay((long)(this.delay * 1000L * 60L)).name("GenericTimerService").call(this.getTimerTask());
        } else if (startDate != null && this.period != -1L) {
            System.err.println("Timer: StartDate: " + startDate + ", Period: " + this.period);
            this.timer = SystemTimer.ofDate((Date)startDate, (long)(this.period * 1000L * 60L)).name("GenericTimerService").call(this.getTimerTask());
        } else if (startDate != null) {
            System.err.println("Timer: StartDate: " + startDate);
            this.timer = SystemTimer.ofDate((Date)startDate).name("GenericTimerService").call(this.getTimerTask());
        } else {
            this.timer = SystemTimer.ofDelay((long)0L).name("GenericTimerService").call(this.getTimerTask());
        }
        this.initialize();
        System.err.println("**************************************************");
    }

    @Override
    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }

    protected abstract Runnable getTimerTask();

    protected void initialize() {
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public void setPeriod(long period) {
        this.period = period;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    public String getHour() {
        return this.hour;
    }

    @Override
    public void setHour(String hour) {
        this.hour = hour;
    }

    public String getMinute() {
        return this.minute;
    }

    @Override
    public void setMinute(String minute) {
        this.minute = minute;
    }
}

