/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.EventAssistanceRemovalServiceMBean;

public class EventAssistanceRemovalService
implements EventAssistanceRemovalServiceMBean {
    private SessionController sessionController = null;
    private static EventAssistanceRemovalService instance = null;

    @Override
    public void start() {
        System.err.println("---------- Starting EventAssistance Removal Service -----------");
        this.getInstance();
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting eventassistance removal service...\n\n", "");
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping EventAssistance Removal Service -----------");
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            System.err.println("Not connected, so reconnect...");
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("EventAssistanceRemovalService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                this.sessionController = null;
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    public void run() {
        this.getInstance();
        instance.runInternal();
    }

    private void runInternal() {
        if (ServiceUtils.autoupdateFinished()) {
            if (SessionController.getImportMode()) {
                return;
            }
            System.err.println("**************************************************");
            System.err.println("EventAssistanceRemovalService: Timer has been called");
            System.err.println("**************************************************");
            RoiTransactionHandler rth = null;
            try {
                this.connect();
                rth = new RoiTransactionHandler();
                rth.begin();
                this.sessionController.eventAssistanceDeleteExpirationObjects();
                rth.end();
                rth = null;
                this.sessionController.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (rth != null) {
                    try {
                        rth.abort();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private EventAssistanceRemovalService getInstance() {
        if (instance == null) {
            instance = this;
        }
        return instance;
    }
}

