/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cron.CronBaseTask;
import agorum.commons.cron.CrontabHandler;
import agorum.commons.cron.SystemTimer;
import agorum.commons.cron.Trace;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.roi.common.Startup;
import agorum.roi.cron.RoiCronTask;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.mbeans.CronJobServiceMBean;
import java.util.Enumeration;
import java.util.Hashtable;

public class CronJobService
implements CronJobServiceMBean {
    private static final Statistic stat = CoreStatistic.getInstance();
    private SystemTimer cronJobTimer;
    private Hashtable<String, String> cronEntries;

    @Override
    public void start() {
        stat.debug("Starting CronJob Service");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting cronjob service...\n\n", "");
        this.cronEntries = new Hashtable();
        Startup.whenReady(() -> {
            stat.debug("CronJobService: Server is started");
            this.cronJobTimer = SystemTimer.ofDelay((long)0L, (long)30000L).name("CronJobTimer").call((Runnable)new CronJobTask());
        });
    }

    @Override
    public void stop() {
        stat.debug("Stopping CronJob Service");
        if (this.cronJobTimer != null) {
            this.cronJobTimer.cancel();
        }
        CrontabHandler.removeAllCronTasks((String)"CronJobService_");
    }

    private class CronJobTask
    implements Runnable {
        private CronJobTask() {
        }

        @Override
        public void run() {
            try (Trace.Auto trace = Trace.auto((String)"agorum cron-job task");){
                try {
                    trace.working("Looking for changed cron entries");
                    MetaDb metaDb = SessionControllerAdmin.getService(CronJobService.class).getMetaDbInstance();
                    Hashtable<String, String> newEntries = new Hashtable<String, String>();
                    String baseKey = "MAIN_MODULE_MANAGEMENT/cronjob/control";
                    String[] entries = metaDb.listSimplePropertyBundle(baseKey);
                    if (entries != null) {
                        int len = entries.length;
                        for (int i = 0; i < len; ++i) {
                            String cronTime = null;
                            String cronClass = null;
                            try {
                                cronTime = metaDb.getSimplePropertyValue(baseKey + "/" + entries[i] + "/CronTime")[0];
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                cronClass = metaDb.getSimplePropertyValue(baseKey + "/" + entries[i] + "/Class")[0];
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (cronTime == null || cronClass == null) continue;
                            boolean addNew = false;
                            String key = cronClass + ":" + cronTime;
                            if (CronJobService.this.cronEntries.containsKey(entries[i])) {
                                String oldKey = (String)CronJobService.this.cronEntries.get(entries[i]);
                                CronJobService.this.cronEntries.remove(entries[i]);
                                if (!oldKey.equals(key)) {
                                    trace.working("Removing old cron job: " + entries[i]);
                                    CrontabHandler.removeCronTask((String)("CronJobService_" + entries[i]));
                                    addNew = true;
                                }
                            } else {
                                addNew = true;
                            }
                            if (addNew && !cronTime.startsWith("#")) {
                                trace.working("Adding new cron job");
                                RoiCronTask task = new RoiCronTask(entries[i], cronClass);
                                CrontabHandler.addCronTask((String)("CronJobService_" + entries[i]), (String)cronTime, (CronBaseTask)task);
                            }
                            newEntries.put(entries[i], key);
                        }
                    }
                    trace.working("Removing old cron entries");
                    Enumeration enumer = CronJobService.this.cronEntries.keys();
                    while (enumer.hasMoreElements()) {
                        String key = (String)enumer.nextElement();
                        CrontabHandler.removeCronTask((String)("CronJobService_" + key));
                    }
                    CronJobService.this.cronEntries = newEntries;
                    trace.ended();
                }
                catch (Throwable t) {
                    trace.failed();
                    stat.error(t);
                }
            }
        }
    }
}

