/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.Statistic;
import agorum.roi.contenthash.common.ContentHashUtils;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.GenericMultiQueueHelper;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.mbeans.ContentHashServiceMBean;
import agorum.roi.statistic.ContentHashServiceStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ContentHashService
implements ContentHashServiceMBean,
Runnable {
    private SessionController sessionController;
    static final Statistic stat = ContentHashServiceStatistic.getInstance();
    public static boolean killTest = false;
    public static boolean stopTest = false;
    private boolean running = false;
    boolean hasMoreQueueEntries;
    private static Set<Long> workingIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private static boolean working;

    @Override
    public void start() {
        stat.info("---------- Starting ContentHash Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting ContentHash service...\n\n", "");
        this.running = true;
        final ContentHashService self = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                new Thread(self).start();
            }
        });
    }

    @Override
    public void stop() {
        this.running = true;
        stat.info("---------- Stopping ContentHash Service -------------");
    }

    @Override
    public void run() {
        stat.info("ContentHashService: Service is started");
        try {
            this.connect();
            this.doJob();
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
    }

    public static boolean isWorking(Long id) {
        return workingIds.contains(id);
    }

    public static boolean isWorking() {
        return working;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJob() {
        while (this.running) {
            if (SessionController.getImportMode()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            GenericMultiQueueHelper qHelper = new GenericMultiQueueHelper();
            try {
                if (!this.hasMoreQueueEntries) {
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.connect();
                for (GenericMultiQueueBean b : this.getQueueEntries(500L)) {
                    if (SessionController.getImportMode()) break;
                    working = true;
                    this.connect();
                    GlobalObjectClientBean obj = null;
                    try {
                        block31: {
                            this.connect();
                            try {
                                obj = this.sessionController.getGlobalObjectById(b.id);
                            }
                            catch (Exception e) {
                                stat.error().exception((Throwable)e).objectId(b.id).send("Unable to get global object from id");
                            }
                            if (obj != null) {
                                try {
                                    workingIds.add(b.id);
                                    if (!(obj instanceof ContentInterface)) break block31;
                                    try (Transaction rth = new Transaction();){
                                        ContentHashUtils.createHashes(this.sessionController, (ContentInterface)((Object)obj));
                                        rth.commit();
                                    }
                                }
                                finally {
                                    workingIds.remove(b.id);
                                }
                            }
                        }
                        this.connect();
                    }
                    catch (Exception e) {
                        stat.error().exception((Throwable)e).object(obj).send("Error creating content hash for object");
                    }
                    qHelper.deleteQueueEntry(b.id, b.sortId, b.ident);
                }
            }
            catch (Throwable e) {
                stat.error().exception(e).send("Global error creating content hash");
            }
            working = false;
        }
    }

    private List<GenericMultiQueueBean> getQueueEntries(long maxAmount) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        ArrayList<GenericMultiQueueBean> result = new ArrayList<GenericMultiQueueBean>();
        this.hasMoreQueueEntries = false;
        String select = null;
        select = "select id, sortid, ident from genericmultiqueue where ident=? order by ident, sortid asc";
        try (RoiTransactionHandler rth = new RoiTransactionHandler();){
            rth.begin(true);
            long amount = 0L;
            try (Connection conn = cu.getConnection();
                 PreparedStatement psel = conn.prepareStatement(select);){
                psel.setString(1, "ContentHashQueue");
                try (ResultSet rs = psel.executeQuery();){
                    while (rs.next()) {
                        Long resId = rs.getLong(1);
                        Long sortId = rs.getLong(2);
                        String ident = rs.getString(3);
                        GenericMultiQueueBean b = new GenericMultiQueueBean();
                        b.id = resId;
                        b.sortId = sortId;
                        b.ident = ident;
                        result.add(b);
                        if (++amount <= maxAmount) continue;
                        this.hasMoreQueueEntries = true;
                        break;
                    }
                }
            }
            rth.end();
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
        return result;
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setModulInfo("ContentHashService");
                credential.setAuthInterface(new ServiceAuthInterface());
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                stat.error((Throwable)e);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }
}

