/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AppUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBean;
import agorum.roi.ejb.client.beans.ContentQuotaObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InfoUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.InfoUserProfileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.PrimaryUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.PrimaryUserProfileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AuthenticationHandler;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.CredentialManager;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiCredentialManager;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManagerAppUserProfileBean;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.ejb.messaging.common.MessageBean;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.adminsync.AdminSyncServiceCaller;
import agorum.roi.sessionfacade.beans.AppUserProfileObjectSessionFacade;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UserManager {
    private SessionController sessionController;
    private DirectoryUserObjectClientBean userObject;
    private FolderObjectClientBean homeFolder;
    private FolderObjectClientBean tmpFolder;
    private boolean userPasswordSet;

    public UserManager(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void updateAllUser() throws Exception {
        if (this.sessionController.isAdminEnabled()) {
            this.updateAllDirectoryUsers();
        } else {
            ExceptionUtils.handleException("You need admin access", "agorum.roi.remote.exception.NoAdminAccess", 22);
        }
    }

    private void updateAllDirectoryUsers() throws Exception {
        RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
        String defaultEmailDomain = rpmd.getEmailDomain();
        DirectoryUserObjectClientBean[] duocb = this.sessionController.getAllDirectoryUsers();
        if (duocb != null) {
            int len = duocb.length;
            for (int i = 0; i < len; ++i) {
                this.sessionController.changePasswordToDes(duocb[i].getName());
                this.createOrUpdatePrivateFolders(duocb[i].getPrimrayUserProfile().getHomeFolder(), duocb[i], duocb[i].getPrimrayUserProfile(), null);
                if (duocb[i].getEmailUserProfiles() == null) {
                    String[] addresses = new String[]{duocb[i].getName() + "@" + defaultEmailDomain};
                    duocb[i].setEmailAddresses(this.sessionController, addresses);
                }
                if (duocb[i].getInfoUserProfile() == null) {
                    UserManagerBean umbX = new UserManagerBean();
                    umbX.setGivenName(duocb[i].getName());
                    this.createInfoUserProfile(umbX, duocb[i]);
                    System.err.println("Create InfoUserProfile for user : " + duocb[i].getName());
                }
                duocb[i].setAcl(duocb[i].getAcl());
            }
        }
    }

    public boolean check(UserManagerBean userManagerBean, DirectoryUserObjectClientBean user) throws Exception {
        String password;
        String[] aliases;
        String[] mailAddresses;
        String existingUserName;
        String newUserName = userManagerBean.getUserName();
        String oldUserName = null;
        if (user != null) {
            oldUserName = user.getName();
        }
        if (newUserName == null && oldUserName != null) {
            newUserName = oldUserName;
        } else if (oldUserName == null && newUserName == null) {
            ExceptionUtils.handleException("Attribute 'name' is not defined!", "agorum.roi.remote.exception.AttributeNotDefined", 74);
        }
        String destFolder = userManagerBean.getDestinationFolder();
        FolderObjectClientBean destFolderObject = null;
        if (destFolder != null) {
            destFolderObject = (FolderObjectClientBean)this.sessionController.asAdmin().findGlobalObjectByPath(destFolder);
        } else if (user != null) {
            GlobalObjectClientBean userAdmin = this.sessionController.asAdmin().getGlobalObjectById(user.getId());
            destFolderObject = userAdmin.getParents()[0];
        }
        if ((user == null && destFolderObject != null || oldUserName != null && newUserName != null && !oldUserName.equalsIgnoreCase(newUserName)) && destFolderObject != null && destFolderObject.hasItem(newUserName)) {
            return false;
        }
        if (oldUserName == null && destFolder == null && newUserName != null || destFolder != null && destFolderObject == null) {
            ExceptionUtils.handleException("Destination folder \"" + destFolder + "\" does not exist.", "agorum.roi.remote.exception.DestinationFolderNotFound", 103);
        }
        if (newUserName != null && (oldUserName == null || !oldUserName.equalsIgnoreCase(newUserName)) && (existingUserName = this.sessionController.getUserNameByAliasName(newUserName)) != null && existingUserName.equalsIgnoreCase(newUserName)) {
            return false;
        }
        if (oldUserName == null && newUserName != null) {
            oldUserName = newUserName;
        }
        if ((mailAddresses = userManagerBean.getEmailAddresses()) != null && oldUserName != null) {
            int len = mailAddresses.length;
            for (int i = 0; i < len; ++i) {
                DirectoryUserObjectClientBean userTmp;
                if (mailAddresses[i] == null || mailAddresses[i].length() <= 0 || (userTmp = this.sessionController.getDirectoryUserFromEmailAddress(mailAddresses[i])) == null || userTmp.getName().equalsIgnoreCase(oldUserName)) continue;
                ExceptionUtils.handleException("Mail address \"" + mailAddresses[i] + "\" already exists.", "agorum.roi.remote.exception.MailAddressAlreadyExists", 202);
            }
        }
        if ((aliases = userManagerBean.getAliases()) != null && oldUserName != null) {
            int len = aliases.length;
            for (int i = 0; i < len; ++i) {
                String userName;
                if (newUserName != null && newUserName.equalsIgnoreCase(aliases[i])) {
                    ExceptionUtils.handleException("The alias name \"" + aliases[i] + "\" and the user name are equal.", "agorum.roi.remote.exception.AliasNameAndNameAreEqual", 207);
                }
                if ((userName = this.sessionController.getUserNameByAliasName(aliases[i])) == null || userName.equalsIgnoreCase(oldUserName)) continue;
                ExceptionUtils.handleException("Alias name \"" + aliases[i] + "\" already exists.", "agorum.roi.remote.exception.AliasNameAlreadyExists", 203);
            }
        }
        if ((password = userManagerBean.getPassWord()) != null && password.length() > 0 && newUserName != null) {
            String callerId = null;
            try {
                callerId = userManagerBean.getCredentialCaller().getCallerId();
            }
            catch (Exception userName) {
                // empty catch block
            }
            AdminSyncServiceCaller assCaller = new AdminSyncServiceCaller();
            if (!assCaller.checkPassWordValidity(this.sessionController, password, user, newUserName, destFolderObject, callerId)) {
                ExceptionUtils.handleException("Password is not valid (on the remote system)", "agorum.roi.remote.exception.InvalidPassword", 31);
            }
        }
        return true;
    }

    public DirectoryUserObjectClientBean createBaseUser(UserManagerBean userManagerBean) throws Exception {
        this.createCredential(userManagerBean);
        this.createUser(userManagerBean);
        this.sessionController.getSystemSessionRemote().setPasswordsDirect(this.sessionController, userManagerBean.getUserName(), userManagerBean.getPassWord(), userManagerBean.getSambaLMPassword(), userManagerBean.getSambaNTPassword(), userManagerBean.getCredentialCaller(), this.userObject);
        this.changeAliases(userManagerBean);
        return this.userObject;
    }

    public DirectoryUserObjectClientBean updateBaseUser(UserManagerBean userManagerBean, DirectoryUserObjectClientBean user) throws Exception {
        this.sessionController.getSystemSessionRemote().changeDistinguisheName(this.sessionController, user.getName(), userManagerBean.getUserName(), userManagerBean.getCredentialCaller());
        this.updateUser(userManagerBean, user, userManagerBean.getUserName());
        this.sessionController.getSystemSessionRemote().setPasswordsDirect(this.sessionController, userManagerBean.getUserName(), userManagerBean.getPassWord(), userManagerBean.getSambaLMPassword(), userManagerBean.getSambaNTPassword(), userManagerBean.getCredentialCaller(), user);
        this.changeAliases(userManagerBean);
        return user;
    }

    public DirectoryUserObjectClientBean create(UserManagerBean userManagerBean) throws Exception {
        boolean doNotCreate = false;
        try {
            if (!this.check(userManagerBean, null)) {
                doNotCreate = true;
            }
        }
        catch (RoiException e) {
            if (userManagerBean.getNoErrorIfExist() && e.getErrorCode() == 200) {
                e.printStackTrace(System.err);
                doNotCreate = true;
            }
            throw e;
        }
        if (!doNotCreate) {
            this.createCredential(userManagerBean);
            this.createUser(userManagerBean);
            this.createEmailUserProfile(userManagerBean);
            this.createHomeFolder(userManagerBean);
            this.createOrUpdatePrivateFolders(this.homeFolder, this.userObject, null, userManagerBean);
            PrimaryUserProfileObjectClientBean pup = this.createPrimaryUserProfile(userManagerBean);
            this.createContentQuotaObjectClientBean(pup, userManagerBean);
            this.createInfoUserProfile(userManagerBean, this.userObject);
            this.createMandatorIdentifier(userManagerBean, this.userObject);
            FolderObjectClientBean parentFolder = this.getParentFolder(userManagerBean, this.userObject);
            if (parentFolder == null) {
                ExceptionUtils.handleException("Destination folder is empty or not valid.", "agorum.roi.remote.exception.FolderNotFound", 64);
            }
            AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
            assu.syncObject(this.sessionController, (UserManagerBean)userManagerBean.clone(), parentFolder, null, null, false, null, "create");
            this.createAddToFolder(parentFolder, this.userObject);
            this.createOrUpdateAppUserProfile(userManagerBean, this.userObject);
            this.updatePassword(userManagerBean);
            this.changeAliases(userManagerBean);
        }
        return this.userObject;
    }

    private FolderObjectClientBean getParentFolder(UserManagerBean userManagerBean, DirectoryUserObjectClientBean userObject) throws Exception {
        String destinationFolder = userManagerBean.getDestinationFolder();
        if (destinationFolder == null) {
            destinationFolder = "/agorum/roi/Administration/User";
        }
        FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(destinationFolder);
        return folder;
    }

    private void createAddToFolder(FolderObjectClientBean folder, DirectoryUserObjectClientBean userObject) throws Exception {
        if (folder != null) {
            folder.add(userObject);
        }
    }

    private void updateAddToFolder(UserManagerBean userManagerBean, DirectoryUserObjectClientBean userObject) throws Exception {
        FolderObjectClientBean folder;
        if (userManagerBean.getDestinationFolder() != null && (folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(userManagerBean.getDestinationFolder())) != null) {
            FolderObjectClientBean[] parents = userObject.getParents();
            if (parents != null) {
                int len = parents.length;
                for (int i = 0; i < len; ++i) {
                    if (parents[i] == null) continue;
                    parents[i].removeItem(userObject);
                }
            }
            folder.add(userObject);
        }
    }

    public DirectoryUserObjectClientBean update(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du) throws Exception {
        if (this.check(userManagerBean, du)) {
            FolderObjectClientBean parentFolder;
            UserManagerBean clonedUMB;
            String newUserName = userManagerBean.getUserName();
            this.updateCredential(userManagerBean, du, newUserName);
            String callerId = null;
            try {
                callerId = userManagerBean.getCredentialCaller().getCallerId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (du == null) {
                throw new Exception("User not found (newUserName): " + userManagerBean.getUserName());
            }
            String oldUserName = du.getName();
            if (newUserName == null || newUserName.equalsIgnoreCase(du.getName())) {
                newUserName = null;
            }
            AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
            String tempPassWord = null;
            if (userManagerBean.getPassWord() != null) {
                boolean valid;
                String name = oldUserName;
                if (newUserName != null) {
                    name = newUserName;
                }
                if (!(valid = assu.checkPassWordValidity(this.sessionController, userManagerBean.getPassWord(), du, name, null, callerId))) {
                    ExceptionUtils.handleException("Password is not valid (on the remote system)", "agorum.roi.remote.exception.InvalidPassword", 31);
                }
                this.userPasswordSet = true;
                if (newUserName != null) {
                    UserManagerBean userManagerBeanPW = new UserManagerBean();
                    userManagerBeanPW.setCredentialCaller(userManagerBean.getCredentialCaller());
                    userManagerBeanPW.setPassWord(userManagerBean.getPassWord());
                    this.updateCredential(userManagerBeanPW, du, null);
                    tempPassWord = userManagerBean.getPassWord();
                    userManagerBean.setPassWord(null);
                }
            } else if (userManagerBean.getSambaNTPassword() != null) {
                this.userPasswordSet = true;
            }
            this.updateEmailUserProfile(userManagerBean, du, newUserName);
            this.updatePrimaryUserProfile(userManagerBean, du, newUserName);
            this.updateContentQuotaObjectClientBean(userManagerBean, du, newUserName);
            this.updateInfoUserProfile(userManagerBean, du);
            this.updateUser(userManagerBean, du, newUserName);
            this.updateHomeFolder(userManagerBean, du, newUserName);
            this.updateMandatorIdentifier(userManagerBean, du);
            this.createOrUpdateAppUserProfile(userManagerBean, du);
            this.changeAliases(userManagerBean);
            this.updateCredentialManager(userManagerBean, du, newUserName);
            this.updateAddToFolder(userManagerBean, du);
            if (tempPassWord != null) {
                userManagerBean.setPassWord(tempPassWord);
            }
            if (((clonedUMB = (UserManagerBean)userManagerBean.clone()).getDestinationFolder() == null || clonedUMB.getDestinationFolder().length() == 0) && (parentFolder = du.getFirstParent()) != null) {
                clonedUMB.setDestinationFolder(parentFolder.getAnyFolderPath());
            }
            assu.syncObject(this.sessionController, clonedUMB, null, null, oldUserName, false, null, "update", callerId);
            if (userManagerBean.getSambaNTPassword() != null) {
                this.setLMAndNTHashes(userManagerBean, null, userManagerBean.getSambaNTPassword().toLowerCase());
            }
        }
        return du;
    }

    public DirectoryUserObjectClientBean addItemNotification(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du) throws Exception {
        AdminSyncServiceCaller assu = new AdminSyncServiceCaller();
        assu.syncObject(this.sessionController, userManagerBean, null, du.getName(), du.getName(), false, null, "executeAfterItemAdded");
        return du;
    }

    public void createMandatorIdentifier(UserManagerBean userManagerBean, DirectoryUserObjectClientBean userObject) throws Exception {
        if (userManagerBean.getMandatorIdentifier() != null) {
            AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(this.sessionController);
            auposf.setWithTransaction(true);
            auposf.setValue(userManagerBean.getMandatorIdentifier());
            auposf.setKeyword("agorum.roi.MandatorIdentifier");
            auposf.setApplication("roi");
            auposf.setDirectoryUserObject(userObject);
            auposf.create();
        }
    }

    public void updateMandatorIdentifier(UserManagerBean userManagerBean, DirectoryUserObjectClientBean userObject) throws Exception {
        if (userManagerBean.getMandatorIdentifier() != null) {
            AppUserProfileObjectClientBean aupocb = userObject.getApplicationUserProfile("roi", "agorum.roi.MandatorIdentifier");
            if (userManagerBean.getMandatorIdentifier().length() > 0) {
                AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(this.sessionController);
                auposf.setWithTransaction(true);
                if (aupocb != null) {
                    auposf.setGlobalObject(aupocb);
                    auposf.setValue(userManagerBean.getMandatorIdentifier());
                    auposf.setDirectoryUserObject(userObject);
                    auposf.update();
                } else {
                    auposf.setKeyword("agorum.roi.MandatorIdentifier");
                    auposf.setApplication("roi");
                    auposf.setDirectoryUserObject(userObject);
                    auposf.setValue(userManagerBean.getMandatorIdentifier());
                    auposf.create();
                }
            } else if (aupocb != null) {
                aupocb.delete();
            }
        }
    }

    private void updateCredential(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        if (userName != null) {
            this.sessionController.getSystemSessionRemote().changeDistinguisheName(this.sessionController, du.getName(), userName, userManagerBean.getCredentialCaller());
        }
        if (userManagerBean.getPassWord() != null && userManagerBean.getPassWord().length() > 0) {
            String pwUser;
            String string = pwUser = userName == null ? du.getName() : userName;
            if ("roi".equalsIgnoreCase(pwUser)) {
                new RoiProperties().setRoiSystemPassword(userManagerBean.getPassWord());
            }
            if ("guest".equalsIgnoreCase(pwUser)) {
                new RoiProperties().setRoiGuestPassword(userManagerBean.getPassWord());
            }
            this.sessionController.getSystemSessionRemote().changePassword(this.sessionController, pwUser, userManagerBean.getPassWord(), userManagerBean.getCredentialCaller());
        }
    }

    public boolean updatePasswords(DirectoryUserObjectClientBean du) throws Exception {
        return this.sessionController.getSystemSessionRemote().updatePasswords(this.sessionController, du);
    }

    private void updateEmailUserProfile(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String newUserName) throws Exception {
        if (userManagerBean.getEmailAddresses() != null && userManagerBean.getEmailAddresses().length > 0) {
            du.setEmailAddresses(this.sessionController, userManagerBean.getEmailAddresses());
        }
    }

    private void updateHomeFolder(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        if (userName != null && userName.length() > 0) {
            PrimaryUserProfileObjectClientBean pup = du.getPrimrayUserProfile();
            pup.getHomeFolder().setName(userName);
            this.createOrUpdatePrivateFolders(pup.getHomeFolder(), du, pup, userManagerBean);
        }
    }

    private void updatePrimaryUserProfile(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        if (userName != null && userName.length() > 0) {
            PrimaryUserProfileObjectClientBean pup = du.getPrimrayUserProfile();
            PrimaryUserProfileObjectClientBeanDefinition primUpDef = (PrimaryUserProfileObjectClientBeanDefinition)pup.getNewDefinition(this.sessionController);
            primUpDef.setName(userName + "-Primary Profile");
            primUpDef.setDescription(userName + "-Primary Profile");
            pup.update(primUpDef);
        }
    }

    private void updateInfoUserProfile(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du) throws Exception {
        String userName = du.getName();
        if (userName != null && userName.length() > 0) {
            InfoUserProfileObjectClientBean iup = du.getInfoUserProfile();
            InfoUserProfileObjectClientBeanDefinition infoUpDef = (InfoUserProfileObjectClientBeanDefinition)iup.getNewDefinition(this.sessionController);
            infoUpDef.setName(userName + "-Info Profile");
            infoUpDef.setDescription(userName + "-Info Profile");
            if (userManagerBean.getGivenName() != null) {
                infoUpDef.setGivenName(userManagerBean.getGivenName());
            }
            if (userManagerBean.getFamilyName() != null) {
                infoUpDef.setFamilyName(userManagerBean.getFamilyName());
            }
            if (userManagerBean.getLanguage() != null) {
                infoUpDef.setLanguage(userManagerBean.getLanguage());
            }
            iup.update(infoUpDef);
        }
    }

    private void updateUser(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        long systemFlags;
        boolean emptyPasswordLockFlag;
        DirectoryUserObjectClientBeanDefinition def = (DirectoryUserObjectClientBeanDefinition)du.getNewDefinition(this.sessionController);
        if (userName != null && userName.length() > 0) {
            def.setName(userName);
            def.setDistinguishedName(userName.toUpperCase());
            def.setUniqueName(userName.toUpperCase());
        }
        if (userManagerBean.getDescription() != null) {
            def.setDescription(userManagerBean.getDescription());
        }
        CredentialObject co = new CredentialObject();
        co.setUserName(userManagerBean.getUserName());
        co.setPassWord(userManagerBean.getPassWord());
        co.setModulInfo("UserManager");
        co.setCredentialManager(userManagerBean.getCredentialManager());
        CredentialManager cm = BaseCredentialManager.getCredentialManager(co);
        AuthenticationHandler authHandler = null;
        if (cm instanceof RoiCredentialManager) {
            RoiCredentialManager rcm = (RoiCredentialManager)cm;
            authHandler = rcm.getAuthClass(null, co);
        }
        boolean bl = emptyPasswordLockFlag = ((systemFlags = du.getSystemFlags()) & GlobalObjectClientBean.SYSTEMFLAG_EMPTYPASSWORDLOCK) != 0L;
        if (authHandler != null || emptyPasswordLockFlag && this.userPasswordSet) {
            def.setSystemFlags(systemFlags & (GlobalObjectClientBean.SYSTEMFLAG_EMPTYPASSWORDLOCK ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (userManagerBean.getLockstate() != null && (userManagerBean.forceLockState || authHandler != null || this.userPasswordSet || !emptyPasswordLockFlag)) {
            def.setAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Integer(userManagerBean.getLockstate())));
        } else if (authHandler != null || this.userPasswordSet && emptyPasswordLockFlag) {
            def.setAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Integer(0)));
        }
        if (userManagerBean.isAdminEnabled() != null && userManagerBean.isAdminEnabled().booleanValue() && !this.sessionController.isAdminEnabled()) {
            ExceptionUtils.handleException("No access to create an admin user", "agorum.roi.remote.exception.NoAdminAccess", 22);
        } else if (userManagerBean.isAdminEnabled() != null) {
            def.setAdminEnabled(userManagerBean.isAdminEnabled());
        }
        if (userManagerBean.getDefaultRoleName() != null && du.getDefaultRole() != null && !userManagerBean.getDefaultRoleName().equalsIgnoreCase(du.getDefaultRole().getName())) {
            def.setDefaultRole(this.sessionController.getUserByName(userManagerBean.getDefaultRoleName()));
        }
        if (userManagerBean.isIsAssoiciatedRolesNameSet()) {
            if (userManagerBean.getAssoiciatedRolesName() != null) {
                if (du.getAssociatedRoles() == null || du.getAssociatedRoles().getId().longValue() != this.sessionController.getGroupByName(userManagerBean.getAssoiciatedRolesName()).getId().longValue()) {
                    def.setAssociatedRoles(this.sessionController.getGroupByName(userManagerBean.getAssoiciatedRolesName()));
                }
            } else if (du.getAssociatedRoles() != null) {
                def.setAssociatedRoles(null);
            }
        }
        if (userManagerBean.getIsRole() != null) {
            def.setIsRole(Boolean.parseBoolean(userManagerBean.getIsRole()));
        }
        du.update(def);
        if (userManagerBean.isReadOnlyMode() != null) {
            du.setReadOnlyMode(userManagerBean.isReadOnlyMode());
        }
    }

    private void updateCredentialManager(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        DirectoryUserObjectClientBeanDefinition def = (DirectoryUserObjectClientBeanDefinition)du.getNewDefinition(this.sessionController);
        if (userManagerBean.getCredentialManager() != null) {
            def.setAttribute(DirectoryUserObjectClientBean.CREDENTIALMANAGER_ATTRIBUTE, AttributeValue.newAttributeValueObject(userManagerBean.getCredentialManager()));
            du.update(def);
        }
    }

    private void createEmailUserProfile(UserManagerBean userManagerBean) throws Exception {
        if (userManagerBean.getEmailAddresses() == null) {
            RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
            String defaultEmailDomain = rpmd.getEmailDomain();
            String[] addresses = new String[]{userManagerBean.getUserName() + "@" + defaultEmailDomain};
            this.userObject.setEmailAddresses(this.sessionController, addresses);
        } else {
            this.userObject.setEmailAddresses(this.sessionController, userManagerBean.getEmailAddresses());
        }
    }

    private void createCredential(UserManagerBean userManagerBean) throws Exception {
        if (userManagerBean.getPassWord() == null || userManagerBean.getPassWord().length() == 0) {
            System.err.println("No password set for user '" + userManagerBean.getUserName() + "'. User will be locked!");
            this.userPasswordSet = false;
            userManagerBean.setPassWord("DummyPassWord");
            userManagerBean.setLockstate(String.valueOf(1));
        } else {
            this.userPasswordSet = true;
        }
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userManagerBean.getUserName());
        credential.setPassWord(userManagerBean.getPassWord());
        credential.setModulInfo("UserManager");
        credential.setCredentialManager(userManagerBean.getCredentialManager());
        this.sessionController.getSystemSessionRemote().createCredential(this.sessionController, credential, userManagerBean.getCredentialCaller());
    }

    private void updatePassword(UserManagerBean userManagerBean) throws Exception {
        this.sessionController.getSystemSessionRemote().changePassword(this.sessionController, userManagerBean.getUserName(), userManagerBean.getPassWord(), userManagerBean.getCredentialCaller());
    }

    public void setLMAndNTHashes(UserManagerBean userManagerBean, String lmHash, String ntHash) throws Exception {
        this.sessionController.getSystemSessionRemote().setLMAndNTHashes(this.sessionController, userManagerBean.getUserName(), lmHash, ntHash, userManagerBean.getCredentialCaller());
    }

    private void changeAliases(UserManagerBean userManagerBean) throws Exception {
        if (userManagerBean.getAliasesset()) {
            String user = userManagerBean.getUserName() == null ? userManagerBean.getMakeUpdateFromUserName() : userManagerBean.getUserName();
            this.sessionController.getSystemSessionRemote().changeAliases(this.sessionController, user, userManagerBean.getAliases());
        }
    }

    public String[] getAliases(String userName) throws Exception {
        return this.sessionController.getSystemSessionRemote().getAliases(this.sessionController, userName);
    }

    private void createUser(UserManagerBean userManagerBean) throws Exception {
        String credential;
        DirectoryUserObjectClientBeanDefinition userDef = new DirectoryUserObjectClientBeanDefinition(this.sessionController);
        userDef.setName(userManagerBean.getUserName());
        if (userManagerBean.userUuid != null) {
            userDef.setUUID(userManagerBean.userUuid);
        }
        userDef.setDescription(userManagerBean.getDescription());
        userDef.setDistinguishedName(userManagerBean.getUserName().toUpperCase());
        if (userManagerBean.isAdminEnabled() != null) {
            userDef.setAdminEnabled(userManagerBean.isAdminEnabled());
            userDef.setSystemAdminEnabled(userManagerBean.isAdminEnabled());
        } else {
            userDef.setAdminEnabled(false);
            userDef.setSystemAdminEnabled(false);
        }
        boolean hasAuthClass = false;
        CredentialObject co = new CredentialObject();
        co.setUserName(userManagerBean.getUserName());
        co.setPassWord(userManagerBean.getPassWord());
        co.setModulInfo("UserManager");
        co.setCredentialManager(userManagerBean.getCredentialManager());
        CredentialManager cm = BaseCredentialManager.getCredentialManager(co);
        AuthenticationHandler authHandler = null;
        if (cm instanceof RoiCredentialManager) {
            RoiCredentialManager rcm = (RoiCredentialManager)cm;
            authHandler = rcm.getAuthClass(null, co);
        }
        if (userManagerBean.getLockstate() != null) {
            userDef.setAttribute(GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Integer(userManagerBean.getLockstate())));
        }
        if (!this.userPasswordSet && !hasAuthClass) {
            userDef.setSystemFlags(GlobalObjectClientBean.SYSTEMFLAG_EMPTYPASSWORDLOCK);
        }
        if ((credential = userManagerBean.getCredentialManager()) == null) {
            credential = "roi";
        }
        userDef.setCredentialManager(credential);
        userDef.setUniqueName(userManagerBean.getUserName().toUpperCase());
        if (userManagerBean.getDefaultRoleName() != null) {
            userDef.setDefaultRole(this.sessionController.getUserByName(userManagerBean.getDefaultRoleName()));
        }
        if (userManagerBean.getAssoiciatedRolesName() != null) {
            userDef.setAssociatedRoles(this.sessionController.getGroupByName(userManagerBean.getAssoiciatedRolesName()));
        }
        if (userManagerBean.getIsRole() != null) {
            userDef.setIsRole(Boolean.parseBoolean(userManagerBean.getIsRole()));
        }
        if (userManagerBean.isAdminEnabled() != null && userManagerBean.isAdminEnabled().booleanValue() && !this.sessionController.isAdminEnabled()) {
            ExceptionUtils.handleException("No access to create an admin user", "agorum.roi.remote.exception.NoAdminAccess", 22);
        } else {
            this.userObject = (DirectoryUserObjectClientBean)this.sessionController.createGlobalObject(userDef);
            this.userObject.setOwner(this.userObject);
        }
        if (userManagerBean.isReadOnlyMode() != null) {
            this.userObject.setReadOnlyMode(userManagerBean.isReadOnlyMode());
        }
    }

    private void createHomeFolder(UserManagerBean userManagerBean) throws Exception {
        FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home");
        this.homeFolder = this.createOrUpdateFolder(folder, userManagerBean.getUserName(), null, "Home Folder", this.sessionController.getAclByName("Private"), this.userObject, null, null, null);
        this.tmpFolder = this.createOrUpdateFolder(this.homeFolder, "tmp", null, "tmp Folder", this.sessionController.getAclByName("Private"), this.userObject, null, null, null);
    }

    private FolderObjectClientBean createOrUpdateFolder(FolderObjectClientBean sourceFolder, String folderName, String areaName, String description, AccessControlListObjectClientBean acl, DirectoryUserObjectClientBean owner, String textkey, Long systemflags, String uuid) throws Exception {
        AppUserProfileObjectClientBean appUp;
        FolderObjectClientBean focb = null;
        GlobalObjectClientBean gocb = sourceFolder.getItem(folderName);
        if (gocb != null) {
            focb = (FolderObjectClientBean)gocb;
            focb.setDescription(description);
            focb.setLastModifier(owner);
            try {
                focb.setSystemFlag(systemflags, GlobalObjectClientBean.SYSTEMFLAGSMODE_ADD);
            }
            catch (Exception exception) {}
        } else {
            FolderObjectClientBeanDefinition fDef = new FolderObjectClientBeanDefinition(this.sessionController);
            fDef.setName(folderName);
            fDef.setAddToFolderOption(sourceFolder);
            fDef.setDescription(description);
            fDef.setAcl(acl);
            if (systemflags != null) {
                fDef.setSystemFlags(systemflags);
            }
            if (uuid != null) {
                fDef.setUUID(uuid);
            }
            if (areaName != null) {
                fDef.setAreaName(areaName);
            }
            if (textkey != null) {
                fDef.setObjectTextKey(textkey);
            }
            fDef.setOwner(owner);
            fDef.setLastModifier(owner);
            focb = (FolderObjectClientBean)this.sessionController.createGlobalObject(fDef);
        }
        if (textkey != null && textkey.equals("agorum.roi.objects.mail.Inbox") && (appUp = owner.getApplicationUserProfile("EventAssistance", String.valueOf(focb.getId()))) == null) {
            AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(this.sessionController);
            auposf.setWithTransaction(true);
            auposf.setApplication("EventAssistance");
            auposf.setKeyword(String.valueOf(focb.getId()));
            auposf.setValue("");
            auposf.setDirectoryUserObject(owner);
            appUp = (AppUserProfileObjectClientBean)auposf.create();
            MessageUtils mu = new MessageUtils();
            MessageBean mb = new MessageBean();
            mb.setObjectProperty("value", owner.getId());
            mb.setObjectProperty("eventType", "eventAssistanceSettingsListener");
            mb.setObjectProperty("className", "");
            mu.publishToTopic("eventAssistanceSettingsListener", mb, true);
        }
        return focb;
    }

    private void createOrUpdateAppUserProfile(UserManagerBean userManagerBean, DirectoryUserObjectClientBean owner) throws Exception {
        Vector v = userManagerBean.getAddToAppUserProfile();
        if (v != null) {
            int len = v.size();
            for (int i = 0; i < len; ++i) {
                try {
                    AppUserProfileObjectClientBean appUp;
                    UserManagerAppUserProfileBean appBean = (UserManagerAppUserProfileBean)v.elementAt(i);
                    if (appBean == null) continue;
                    String keyword = appBean.getKeyword();
                    if (appBean.getKeywordAttribute() != null) {
                        String reftype = null;
                        String tostring = null;
                        Hashtable h = appBean.getKeywordAttribute();
                        Enumeration en = h.keys();
                        while (en.hasMoreElements()) {
                            String key = (String)en.nextElement();
                            if ("RefType".equalsIgnoreCase(key)) {
                                reftype = (String)h.get(key);
                                continue;
                            }
                            if (!"ToString".equalsIgnoreCase(key)) continue;
                            tostring = (String)h.get(key);
                        }
                        if (reftype != null) {
                            GlobalObjectClientBean clientBean = owner.getSessionController().findGlobalObjectByPath(keyword);
                            keyword = tostring != null && tostring.equalsIgnoreCase("ID") ? String.valueOf(clientBean.getId()) : clientBean.getAttribute(tostring).toString(owner.getSessionController());
                        }
                    }
                    if ((appUp = owner.getApplicationUserProfile(appBean.getApplication(), keyword)) != null) continue;
                    AppUserProfileObjectSessionFacade auposf = new AppUserProfileObjectSessionFacade(this.sessionController);
                    auposf.setWithTransaction(true);
                    auposf.setApplication(appBean.getApplication());
                    auposf.setKeyword(keyword);
                    auposf.setValue(appBean.getValue());
                    auposf.setDirectoryUserObject(owner);
                    appUp = (AppUserProfileObjectClientBean)auposf.create();
                    MessageUtils mu = new MessageUtils();
                    MessageBean mb = new MessageBean();
                    mb.setObjectProperty("value", owner.getId());
                    mb.setObjectProperty("eventType", "eventAssistanceSettingsListener");
                    mb.setObjectProperty("className", "");
                    mu.publishToTopic("eventAssistanceSettingsListener", mb, true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private PrimaryUserProfileObjectClientBean createPrimaryUserProfile(UserManagerBean userManagerBean) throws Exception {
        PrimaryUserProfileObjectClientBeanDefinition primUpDef = new PrimaryUserProfileObjectClientBeanDefinition(this.sessionController);
        primUpDef.setName(userManagerBean.getUserName() + "-Primary Profile");
        primUpDef.setDescription(userManagerBean.getUserName() + "-Primary Profile");
        primUpDef.setDirectoryUserObject(this.userObject);
        primUpDef.setHomeFolder(this.homeFolder);
        primUpDef.setTmpFolder(this.tmpFolder);
        primUpDef.setDefaultAcl(this.sessionController.getAclByName("Published"));
        primUpDef.setOwner(this.userObject);
        PrimaryUserProfileObjectClientBean pup = (PrimaryUserProfileObjectClientBean)this.sessionController.createGlobalObject(primUpDef);
        return pup;
    }

    private ContentQuotaObjectClientBean createContentQuotaObjectClientBean(PrimaryUserProfileObjectClientBean pup, UserManagerBean userManagerBean) throws Exception {
        ContentQuotaObjectClientBeanDefinition def = new ContentQuotaObjectClientBeanDefinition(pup.getSessionController());
        def.setName("UserQuotaObject");
        def.setUniqueName("UserQuotaObject");
        def.setAssociatedGlobalObject(this.userObject);
        def.setOwner(this.userObject);
        def.setConsumedStorage(-1L);
        def.setAllocatedStorage(userManagerBean.getQuotaAllocatedStorage());
        ContentQuotaObjectClientBean quota = (ContentQuotaObjectClientBean)pup.getSessionController().createGlobalObject(def);
        pup.setContentQuotaObject(quota);
        return quota;
    }

    private void updateContentQuotaObjectClientBean(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du, String userName) throws Exception {
        ContentQuotaObjectClientBean quota;
        if (userManagerBean.getQuotaAllocatedStorage() != -1L && (quota = du.getPrimrayUserProfile().getContentQuotaObject()) != null) {
            SuperObjectClientBeanDefinition def = quota.getNewDefinition(du.getSessionController());
            if (userManagerBean.getQuotaAllocatedStorage() != -1L) {
                def.setAttribute(ContentQuotaObjectClientBean.ALLOCATEDSTORAGE_ATTRIBUTE, AttributeValue.newAttributeValueObject(userManagerBean.getQuotaAllocatedStorage()));
            }
            quota.update(def);
        }
    }

    private void createInfoUserProfile(UserManagerBean userManagerBean, DirectoryUserObjectClientBean du) throws Exception {
        InfoUserProfileObjectClientBeanDefinition infoUpDef = new InfoUserProfileObjectClientBeanDefinition(this.sessionController);
        infoUpDef.setName(userManagerBean.getUserName() + "-Info Profile");
        infoUpDef.setDescription(userManagerBean.getUserName() + "-Info Profile");
        infoUpDef.setDirectoryUserObject(du);
        infoUpDef.setGivenName(userManagerBean.getGivenName());
        infoUpDef.setFamilyName(userManagerBean.getFamilyName());
        infoUpDef.setLanguage(userManagerBean.getLanguage());
        infoUpDef.setOwner(du);
        this.sessionController.createGlobalObject(infoUpDef);
    }

    private long getSystemFlagsForHomeFolders() {
        return GlobalObjectClientBean.SYSTEMFLAG_NOTCHANGENAME + GlobalObjectClientBean.SYSTEMFLAG_ADMINREMOVEITEMONLY + GlobalObjectClientBean.SYSTEMFLAG_ADMINDELETEONLY;
    }

    private void createOrUpdatePrivateFolders(FolderObjectClientBean folder, DirectoryUserObjectClientBean user, PrimaryUserProfileObjectClientBean pup, UserManagerBean userManagerBean) throws Exception {
        long systemflags = this.getSystemFlagsForHomeFolders();
        FolderObjectClientBean focb = null;
        AccessControlListObjectClientBean acl = this.sessionController.getAclByName("Private");
        this.createOrUpdateFolder(folder, "MyFiles", "MyFiles", "MyFilesFolder from user " + user.getName(), acl, user, null, systemflags, null).setObjectTextKey("agorum.folders.myfiles");
        System.err.println("PrimaryUserProfileObjectClientBean = " + pup);
        if (pup != null && pup.getTmpFolder() == null) {
            focb = this.createOrUpdateFolder(folder, "tmp", null, "tmp folder", acl, user, null, systemflags, null);
            user.getPrimrayUserProfile().setAttribute(PrimaryUserProfileObjectClientBean.TMPFOLDER_ATTRIBUTE, AttributeValue.newAttributeValueObject(focb));
        }
        this.createOrUpdateFolder(folder, "MyAdmin", "MyAdmin", "MyAdminFolder from user " + user.getName(), acl, user, null, systemflags, null);
        focb = this.getMyMailFolder(folder, user, acl);
        this.createOrUpdateFolder(focb, "inbox", null, "inbox from user " + user.getName(), acl, user, "agorum.roi.objects.mail.Inbox", systemflags, null);
        this.createOrUpdateFolder(focb, "outbox", null, "outbox from user " + user.getName(), acl, user, "agorum.roi.objects.mail.Outbox", systemflags, null);
        this.createOrUpdateFolder(focb, "sentbox", null, "sentbox from user " + user.getName(), acl, user, "agorum.roi.objects.mail.Sentbox", systemflags, null);
        this.getMyMailFilterFolder(folder, user, acl);
        this.getMyRecyclingFolder(folder, user, acl);
    }

    public FolderObjectClientBean getMyMailFolder(FolderObjectClientBean home, DirectoryUserObjectClientBean user, AccessControlListObjectClientBean acl) throws Exception {
        return this.createOrUpdateFolder(home, "Mail", "Mail", "MailFolder from user " + user.getName(), acl, user, null, this.getSystemFlagsForHomeFolders(), null);
    }

    public FolderObjectClientBean getMyMailFilterFolder(FolderObjectClientBean home, DirectoryUserObjectClientBean user, AccessControlListObjectClientBean acl) throws Exception {
        return this.createOrUpdateFolder(home, "MyMailFilter", "MyMailFilter", "MyMailFilter from user " + user.getName(), acl, user, "agorum.roi.objects.mailfilter.MyMailFilter", this.getSystemFlagsForHomeFolders(), null);
    }

    public FolderObjectClientBean getMyRecyclingFolder(FolderObjectClientBean home, DirectoryUserObjectClientBean user, AccessControlListObjectClientBean acl) throws Exception {
        return this.createOrUpdateFolder(home, "MyRecycling", "MyRecycling", "MyRecycling from user " + user.getName(), acl, user, "agorum.roi.objects.myrecycling.MyRecycling", this.getSystemFlagsForHomeFolders(), null);
    }

    public UserManagerBean getUserManagerBeanFromUserObject(DirectoryUserObjectClientBean user) throws Exception {
        EmailUserProfileObjectClientBean[] emailUserProfiles;
        UserManagerBean umb = new UserManagerBean();
        umb.setDirectoryUserName(user.getName());
        umb.setUserName(user.getName());
        umb.setDescription(user.getDescription());
        umb.setAdminEnabled(user.getAdminenabled());
        umb.setCredentialManager(user.getCredentialManager());
        umb.setLockstate(String.valueOf(user.getLockState()));
        String anyFolderPath = user.getAnyFolderPath();
        umb.setDestinationFolder(anyFolderPath.substring(0, anyFolderPath.length() - user.getName().length() - 1));
        umb.setDefaultRoleName(user.getDefaultRole().getName());
        umb.setIsRole(String.valueOf(user.getIsRole()));
        if (user.getAssociatedRoles() != null) {
            umb.setAssoiciatedRolesName(user.getAssociatedRoles().getName());
            umb.setIsAssoiciatedRolesNameSet(true);
        } else {
            umb.setIsAssoiciatedRolesNameSet(false);
        }
        String[] aliases = this.getAliases(user.getName());
        if (aliases != null && aliases.length > 0) {
            umb.setAliases(aliases);
            umb.setAliasesset(true);
        } else {
            umb.setAliasesset(false);
        }
        AppUserProfileObjectClientBean aupocb = user.getApplicationUserProfile("roi", "agorum.roi.MandatorIdentifier");
        if (aupocb != null) {
            umb.setMandatorIdentifier(aupocb.getAppValue());
        }
        if ((emailUserProfiles = user.getEmailUserProfiles()) != null && emailUserProfiles.length > 0) {
            int len = emailUserProfiles.length;
            String[] emailAddresses = new String[len];
            for (int i = 0; i < len; ++i) {
                emailAddresses[i] = emailUserProfiles[i].getEmailAddress();
            }
            umb.setEmailAddresses(emailAddresses);
        }
        umb.setPassWord(this.getDecodedSystemPassword(user));
        InfoUserProfileObjectClientBean infoUserProfile = user.getInfoUserProfile();
        umb.setGivenName(infoUserProfile.getGivenName());
        umb.setFamilyName(infoUserProfile.getFamilyName());
        umb.setLanguage(infoUserProfile.getLanguage());
        return umb;
    }

    private String getDecodedSystemPassword(DirectoryUserObjectClientBean user) {
        String password = null;
        try {
            password = this.sessionController.getDecodedSystemPassword(user.getName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return password;
    }
}

