/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.utils.LockHandle;
import agorum.commons.utils.LockMaster;
import agorum.roi.ejb.common.Transaction;
import java.util.ArrayList;
import java.util.List;

public class TransactionLock {
    private static LockMaster<String> pool = new LockMaster();
    private static final String KEY = TransactionLock.class.getName();

    public static void acquire(String key, boolean exclusive) throws Exception {
        ArrayList<LockHandle> locks = (ArrayList<LockHandle>)Transaction.get(KEY);
        if (locks == null) {
            locks = new ArrayList<LockHandle>();
            Transaction.put(KEY, locks);
        }
        locks.add(pool.lock((Object)key, exclusive));
        ArrayList<LockHandle> transactionLocks = locks;
        Transaction.afterCommit(KEY, () -> TransactionLock.release(transactionLocks));
        Transaction.afterRollback(KEY, () -> TransactionLock.release(transactionLocks));
    }

    private static void release(List<LockHandle> locks) {
        for (LockHandle lock : locks) {
            lock.close();
        }
    }
}

