/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.beans.SystemSessionEJB;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.common.ApplicationHashtable;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueDataBaseObjectClientBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.DbPrimaryKey;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.home.AttributeObjectEntityHome;
import agorum.roi.ejb.interfaces.home.AttributeObjectHome;
import agorum.roi.ejb.interfaces.home.ClassObjectEntityHome;
import agorum.roi.ejb.interfaces.home.ClassObjectHome;
import agorum.roi.ejb.interfaces.remote.AttributeObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.AttributeObjectRemote;
import agorum.roi.ejb.interfaces.remote.ClassObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.ClassObjectRemote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.rmi.PortableRemoteObject;

public class StartupInitializer {
    private static Hashtable effectiveAttributes = null;
    private static Hashtable allFormatObjects = null;
    private static Hashtable allClassObjects = null;
    private static Hashtable allClassObjectsByName = null;
    private static Hashtable allAttributes = null;
    private static boolean initialized;

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static synchronized void addFormat(String extension, FormatObjectClientBean formatObject) {
        if (allFormatObjects != null) {
            allFormatObjects.put(extension.toUpperCase(), formatObject);
        }
    }

    public static synchronized void init(SessionController sessionController, SystemSessionEJB sessEJB) throws Exception {
        try {
            System.err.println("init effective attr");
            StartupInitializer.initEffectiveAttributes(sessionController);
            System.err.println("initClassObjects");
            StartupInitializer.initClassObjects(sessionController);
            System.err.println("init format objects");
            StartupInitializer.initFormatObjects(sessionController, sessEJB);
            System.err.println("finished init");
        }
        finally {
            initialized = true;
        }
    }

    public static synchronized void reInit(SessionController sessionController, SystemSessionEJB sessEJB) throws Exception {
        if (!initialized) {
            return;
        }
        initialized = false;
        effectiveAttributes = null;
        allFormatObjects = null;
        allClassObjects = null;
        allClassObjectsByName = null;
        allAttributes = null;
        StartupInitializer.init(sessionController, sessEJB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initEffectiveAttributes(SessionController sessionController) throws Exception {
        if (effectiveAttributes != null) {
            StartupInitializer.cloneEffectiveAttributes(sessionController);
            return;
        }
        effectiveAttributes = sessionController.getEffectiveAttributes().getHashtable();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            pstmt = conn.prepareStatement("select ID from DATABASEOBJECT where ACTIVE = 1 and CLASSID=10");
            rs = pstmt.executeQuery();
            AttributeObjectEntityHome home = (AttributeObjectEntityHome)EJBHomeHolder.getHome("ejb/AttributeObjectEntity");
            Object objref = EJBHomeHolder.getHome("ejb/AttributeObject");
            AttributeObjectHome home1 = (AttributeObjectHome)PortableRemoteObject.narrow((Object)objref, AttributeObjectHome.class);
            AttributeObjectRemote remote1 = home1.create();
            while (rs.next()) {
                Long id = new Long(rs.getLong(1));
                DbPrimaryKey pk = new DbPrimaryKey();
                pk.id = id;
                AttributeObjectEntityRemote remote = null;
                try {
                    remote = home.findByPrimaryKey(sessionController, pk, pk.getAttributes());
                }
                catch (Exception e) {
                    ExceptionUtils.handleException(e);
                }
                Hashtable allAttributes = remote.getAttributeObjectHash();
                AttributeObjectClientBean clientBean = new AttributeObjectClientBean();
                clientBean.init(remote1, remote, sessionController, id);
                Enumeration keys = allAttributes.keys();
                while (keys.hasMoreElements()) {
                    String attrName = keys.nextElement().toString();
                    AttributeValue value = (AttributeValue)allAttributes.get(attrName);
                    clientBean.setAttributeInternal(attrName, value);
                }
                AttributeValueDataBaseObjectClientBean av = (AttributeValueDataBaseObjectClientBean)clientBean.getAttribute(AttributeObjectClientBean.CLASS_ATTRIBUTE);
                Long classId = av.getId();
                AttributeValue av1 = clientBean.getAttribute(AttributeObjectClientBean.DATABASEOBJECTNAME_ATTRIBUTE);
                String attrName = clientBean.getAttribute(AttributeObjectClientBean.NAME_ATTRIBUTE).getString().toUpperCase();
                Hashtable subHash = null;
                if (!effectiveAttributes.containsKey(classId)) {
                    subHash = new Hashtable();
                    effectiveAttributes.put(classId, subHash);
                } else {
                    subHash = (Hashtable)effectiveAttributes.get(classId);
                }
                subHash.put(attrName, clientBean);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initFormatObjects(SessionController sessionController, SystemSessionEJB sessEJB) throws Exception {
        if (allFormatObjects != null) {
            StartupInitializer.cloneFormatObjects(sessionController);
            return;
        }
        allFormatObjects = sessionController.getAllFormatObjects().getHashtable();
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        ResultSet rs = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String select = "select ID from INTERNALOBJECT where CLASSID=26";
            pstmt = conn.prepareStatement(select);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Long id = new Long(rs.getLong(1));
                FormatObjectClientBean clientBean = (FormatObjectClientBean)sessEJB.getInternalObjectById(sessionController, id);
                allFormatObjects.put(clientBean.getExtension().toUpperCase(), clientBean);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initClassObjects(SessionController sessionController) throws Exception {
        if (allClassObjects != null) {
            StartupInitializer.cloneClassObjects(sessionController);
            return;
        }
        allClassObjects = sessionController.getAllClassObjects().getHashtable();
        allClassObjectsByName = sessionController.getAllClassObjectsByName().getHashtable();
        allAttributes = sessionController.getAllAttributes().getHashtable();
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        ResultSet rs = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String select = "select ID from DATABASEOBJECT where ACTIVE = 1 and CLASSID=9";
            pstmt = conn.prepareStatement(select);
            rs = pstmt.executeQuery();
            ClassObjectEntityHome home = (ClassObjectEntityHome)EJBHomeHolder.getHome("ejb/ClassObjectEntity");
            Object objref = EJBHomeHolder.getHome("ejb/ClassObject");
            ClassObjectHome homeEJB = (ClassObjectHome)PortableRemoteObject.narrow((Object)objref, ClassObjectHome.class);
            ClassObjectRemote remoteEJB = homeEJB.create();
            while (rs.next()) {
                Long id = new Long(rs.getLong(1));
                DbPrimaryKey pk = new DbPrimaryKey();
                pk.id = id;
                ClassObjectEntityRemote remote = null;
                try {
                    remote = home.findByPrimaryKey(sessionController, pk, pk.getAttributes());
                    remote.getId(sessionController);
                }
                catch (Exception e) {
                    ExceptionUtils.handleException(e);
                }
                ClassObjectClientBean clientBean = new ClassObjectClientBean();
                clientBean.init(remoteEJB, remote, sessionController, pk.id);
                allClassObjects.put(clientBean.getId(), clientBean);
                String className = clientBean.getName().toUpperCase();
                System.err.println("Classname = " + className);
                allClassObjectsByName.put(className, clientBean);
                allAttributes.put(clientBean.getId(), new Hashtable());
            }
            StartupInitializer.reInitEffectiveAttributes(sessionController);
            Enumeration coEnum = allClassObjects.keys();
            while (coEnum.hasMoreElements()) {
                Object key = coEnum.nextElement();
                ClassObjectClientBean co = (ClassObjectClientBean)allClassObjects.get(key);
                Hashtable allAttrHash = (Hashtable)allAttributes.get(co.getId());
                SystemSessionEJB.getAllAttributes(sessionController, co, allAttrHash);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    private static void reInitEffectiveAttributes(SessionController sessionController) throws RemoteException, Exception {
        Enumeration coEnum = allClassObjects.keys();
        while (coEnum.hasMoreElements()) {
            Long classId = (Long)coEnum.nextElement();
            if (effectiveAttributes.containsKey(classId)) continue;
            effectiveAttributes.put(classId, new Hashtable());
        }
    }

    private static void cloneEffectiveAttributes(SessionController sessionController) throws Exception {
        Hashtable myEffectiveAttributes = sessionController.getEffectiveAttributes().getHashtable();
        Enumeration enumer = effectiveAttributes.keys();
        while (enumer.hasMoreElements()) {
            Long classId = (Long)enumer.nextElement();
            Hashtable mySubHash = null;
            if (!myEffectiveAttributes.containsKey(classId)) {
                mySubHash = new Hashtable();
                myEffectiveAttributes.put(classId, mySubHash);
            } else {
                mySubHash = (Hashtable)myEffectiveAttributes.get(classId);
            }
            Hashtable subHash = (Hashtable)effectiveAttributes.get(classId);
            Enumeration enumSub = subHash.keys();
            while (enumSub.hasMoreElements()) {
                String attrName = enumSub.nextElement().toString();
                AttributeObjectClientBean clientBean = (AttributeObjectClientBean)subHash.get(attrName);
                mySubHash.put(attrName, clientBean.clone(sessionController));
            }
        }
        sessionController.setEffectiveAttributes(new ApplicationHashtable(sessionController, myEffectiveAttributes, 6));
    }

    private static void cloneFormatObjects(SessionController sessionController) throws Exception {
        Hashtable myAllFormatObjects = sessionController.getAllFormatObjects().getHashtable();
        Enumeration enumer = allFormatObjects.keys();
        while (enumer.hasMoreElements()) {
            String key = enumer.nextElement().toString();
            FormatObjectClientBean clientBean = (FormatObjectClientBean)allFormatObjects.get(key);
            myAllFormatObjects.put(key, clientBean.clone(sessionController));
        }
        sessionController.setAllFormatObjects(new ApplicationHashtable(sessionController, myAllFormatObjects, 2));
    }

    private static void cloneClassObjects(SessionController sessionController) throws Exception {
        Hashtable<Long, ClassObjectClientBean> myAllClassObjects = new Hashtable<Long, ClassObjectClientBean>();
        Hashtable<String, ClassObjectClientBean> myAllClassObjectsByName = new Hashtable<String, ClassObjectClientBean>();
        Hashtable myAllAttributes = new Hashtable();
        Enumeration enumer = allClassObjects.keys();
        while (enumer.hasMoreElements()) {
            Long id = (Long)enumer.nextElement();
            ClassObjectClientBean clientBean = (ClassObjectClientBean)allClassObjects.get(id);
            ClassObjectClientBean clon = (ClassObjectClientBean)clientBean.clone(sessionController);
            myAllClassObjects.put(id, clon);
            String className = clon.getName().toUpperCase();
            myAllClassObjectsByName.put(className, clon);
            myAllAttributes.put(id, new Hashtable());
        }
        Enumeration enumer1 = allAttributes.keys();
        while (enumer1.hasMoreElements()) {
            Long id = (Long)enumer1.nextElement();
            Hashtable subHash = (Hashtable)allAttributes.get(id);
            Hashtable mySubHash = (Hashtable)myAllAttributes.get(id);
            Enumeration enumer2 = subHash.keys();
            while (enumer2.hasMoreElements()) {
                String attrName = enumer2.nextElement().toString();
                AttributeObjectClientBean clientBean = (AttributeObjectClientBean)subHash.get(attrName);
                mySubHash.put(attrName, clientBean.clone(sessionController));
            }
        }
        sessionController.setAllClassObjects(new ApplicationHashtable(sessionController, myAllClassObjects, 1));
        sessionController.setAllClassObjectsByName(new ApplicationHashtable(sessionController, myAllClassObjectsByName, 4));
        sessionController.setAllAttributes(new ApplicationHashtable(sessionController, myAllAttributes, 3));
    }
}

