/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.common.beans.AutoUpdateInfo;
import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.RemoteRelationObjectClientBean;
import agorum.roi.ejb.client.beans.RemoteRelationObjectClientBeanDefinition;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.search.SearchClass;
import java.io.Serializable;

public class RemoteRelationUtils
implements Serializable {
    private SessionController sessionController = null;

    public RemoteRelationUtils(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public RemoteRelationObjectClientBean[] getRemoteRelationObject(GlobalObjectClientBean globalObject, String remoteId, String systemId) throws Exception {
        return this.getRemoteRelationObject(globalObject.getId(), remoteId, systemId);
    }

    public RemoteRelationObjectClientBean[] getRemoteRelationObject(Long id, String remoteId, String systemId) throws Exception {
        try {
            if (AutoUpdateInfo.inAutoUpdate && this.sessionController.getClassObject(RemoteRelationObjectClientBean.CLASS_NAME) == null) {
                return null;
            }
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, RemoteRelationObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, RemoteRelationObjectClientBean.CLASS_NAME, null);
            if (id != null) {
                sc.setAttributeEQUAL(RemoteRelationObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)id, false);
                sc.setSearchClauseAND();
            }
            if (remoteId != null) {
                sc.setAttributeEQUAL(RemoteRelationObjectClientBean.CLASS_NAME, "REMOTEID", (Object)remoteId, false);
                sc.setSearchClauseAND();
            }
            if (systemId != null) {
                sc.setAttributeEQUAL(RemoteRelationObjectClientBean.CLASS_NAME, "SYSTEMID", (Object)systemId, false);
                sc.setSearchClauseAND();
            }
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return (RemoteRelationObjectClientBean[])ju.convertArray(accb, RemoteRelationObjectClientBean.class.getName());
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public GlobalObjectClientBean getGlobalObjectFromRemoteId(String remoteId, String systemId) throws Exception {
        RemoteRelationObjectClientBean[] relObj = this.getRemoteRelationObject((Long)null, remoteId, systemId);
        if (relObj != null && relObj.length > 0) {
            return relObj[0].getReferenceObject();
        }
        return null;
    }

    public String getRemoteIdFromGlobalObject(GlobalObjectClientBean globalObject, String systemId) throws Exception {
        RemoteRelationObjectClientBean[] relObj = this.getRemoteRelationObject(globalObject, null, systemId);
        if (relObj != null && relObj.length > 0) {
            return relObj[0].getRemoteId();
        }
        return null;
    }

    public RemoteRelationObjectClientBean[] getRemoteIdsFromGlobalObject(GlobalObjectClientBean globalObject) throws Exception {
        RemoteRelationObjectClientBean[] relObj = this.getRemoteRelationObject(globalObject, null, null);
        return relObj;
    }

    public void deleteRemoteRelationObject(GlobalObjectClientBean clientBean, String remoteId, String systemId) throws Exception {
        RemoteRelationObjectClientBean[] acocb = null;
        acocb = this.getRemoteRelationObject(clientBean.getId(), remoteId, systemId);
        if (acocb != null) {
            for (int i = 0; i < acocb.length; ++i) {
                acocb[i].delete();
            }
        }
    }

    public void createRemoteRelation(GlobalObjectClientBean clientBean, String remoteId, String systemId) throws Exception {
        RemoteRelationObjectClientBean[] remRel = this.getRemoteRelationObject(clientBean.getId(), remoteId, systemId);
        if (remRel != null && remRel.length > 0) {
            RemoteRelationObjectClientBeanDefinition relDef = (RemoteRelationObjectClientBeanDefinition)remRel[0].getDefinition(this.sessionController);
            relDef.setReferenceObject(clientBean);
            relDef.setRemoteId(remoteId);
            relDef.setSystemId(systemId);
            remRel[0].update(relDef);
        } else {
            RemoteRelationObjectClientBeanDefinition relDef = new RemoteRelationObjectClientBeanDefinition(this.sessionController);
            relDef.setReferenceObject(clientBean);
            relDef.setRemoteId(remoteId);
            relDef.setSystemId(systemId);
            this.sessionController.createInternalObject(relDef);
        }
    }
}

