/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.statistic.metadata.MetadataInheritanceStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;

public class QueueUtils {
    public static final String QUEUE_TOMETADATAINHERITANCEINDEX = "tometadatainheritanceindex";
    public static final String QUEUE_TOPATHINDEX = "topathindex";
    private static final MetadataInheritanceStatistic stat = MetadataInheritanceStatistic.getInstance();
    private static final String ME = QueueUtils.class.getName();

    public static void remove(Connection conn, String table, long id, long sortId) throws SQLException {
        QueueUtils.delete(conn, table, id, sortId);
    }

    private static void delete(Connection conn, String table, long id, long sortId) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("delete from " + table + " where id=? and sortid=?");){
            ps.setLong(1, id);
            ps.setLong(2, sortId);
            ps.execute();
        }
    }

    public static void add(String table, long id, WakeHandler handler) throws Exception {
        if (RoiTransactionHandler.getThreadTransaction() == null) {
            throw new IllegalStateException(table + " consistency violation: Enclosing transaction required");
        }
        HashSet<Long> entries = (HashSet<Long>)Transaction.get(ME + "_" + table);
        if (entries == null) {
            entries = new HashSet<Long>();
            Transaction.put(ME + "_" + table, entries);
            HashSet<Long> myEntries = entries;
            Transaction.beforeCommit(ME + "_" + table, () -> {
                try (Connection conn = new ConnectionUtils().getConnection();){
                    for (Long entry : myEntries) {
                        stat.debug().objectId(entry).send("put entry to queue");
                        QueueUtils.insert(conn, table, entry);
                    }
                }
            });
            Transaction.afterCommit(ME + "_" + table, () -> handler.run());
        }
        entries.add(id);
    }

    public static void clearDuplicates(Connection conn, String table, long id, long sortId) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("select sortid from " + table + " where id=? and sortid<>?");){
            ps.setLong(1, id);
            ps.setLong(2, sortId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    QueueUtils.delete(conn, table, id, rs.getLong(1));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static long count(String table) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void insert(Connection conn, String table, long id) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("insert into " + table + " (id) values (?)");){
            ps.setLong(1, id);
            ps.execute();
        }
    }

    public static interface WakeHandler {
        public void run() throws Exception;
    }
}

