/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.UpdateCounterCacheHandler;
import java.util.ArrayList;

public class ObjectUpdateHandler {
    private static final String UPDATECOUNTER_TRANS_CACHE_KEY = "UpdateCounterAfterCommit";
    private static int MIN_CACHE_SIZE = 100000;
    public static ObjectUpdateHandler objectUpdateHandler = new ObjectUpdateHandler();
    private GenericCache objectHash = null;
    private int cacheSize = MIN_CACHE_SIZE;
    public static Object syncLock = new Object();

    public ObjectUpdateHandler() {
        this.objectHash = GenericCache.getInstance((Object)"ObjectUpdateHandler", (int)this.cacheSize, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
    }

    public static ObjectUpdateHandler getInstance() {
        return objectUpdateHandler;
    }

    public void setCacheSize(int size) {
        if (size < MIN_CACHE_SIZE) {
            size = MIN_CACHE_SIZE;
        }
        if (this.cacheSize != size) {
            this.cacheSize = size;
            this.objectHash.setMaxItems(this.cacheSize);
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public static long getUpdateCounterStatic(Long id) {
        return ObjectUpdateHandler.getInstance().getUpdateCounter(id);
    }

    public static long getUpdateCounterInitStatic(Long id) {
        return ObjectUpdateHandler.getInstance().getUpdateCounterInit(id);
    }

    public static long incrementUpdateCounterStatic(Long id) {
        return ObjectUpdateHandler.getInstance().incrementUpdateCounter(id);
    }

    public static void removeUpdateCounterStatic(Long id) {
        ObjectUpdateHandler.getInstance().removeUpdateCounter(id);
    }

    public long getUpdateCounter(Long id) {
        if (!this.objectHash.contains((Object)id)) {
            this.objectHash.put((Object)id, (Object)new Long(-1L));
            return -1L;
        }
        return (Long)this.objectHash.get((Object)id);
    }

    public long getUpdateCounterInit(Long id) {
        if (!this.objectHash.contains((Object)id)) {
            this.objectHash.put((Object)id, (Object)new Long(0L));
            return 0L;
        }
        return (Long)this.objectHash.get((Object)id);
    }

    public synchronized long incrementUpdateCounter(Long id) {
        this.rememberUpdateCounterId(id);
        if (!this.objectHash.contains((Object)id)) {
            this.objectHash.put((Object)id, (Object)new Long(1L));
            return 1L;
        }
        long uc = (Long)this.objectHash.get((Object)id);
        this.objectHash.put((Object)id, (Object)new Long(++uc));
        return uc;
    }

    public synchronized void removeUpdateCounter(Long id) {
        this.rememberUpdateCounterId(id);
        if (this.objectHash.contains((Object)id)) {
            this.objectHash.remove((Object)id);
        }
    }

    private void rememberUpdateCounterId(Long id) {
        if (!RoiTransactionHandler.isTransactionActive()) {
            return;
        }
        ArrayList<Long> updateCounterIds = (ArrayList<Long>)Transaction.get(UPDATECOUNTER_TRANS_CACHE_KEY);
        if (updateCounterIds == null) {
            final ArrayList<Long> finalUpdateCounterIds = updateCounterIds = new ArrayList<Long>();
            Transaction.put(UPDATECOUNTER_TRANS_CACHE_KEY, updateCounterIds);
            try {
                Transaction.afterCommit(UPDATECOUNTER_TRANS_CACHE_KEY, new RoiTransactionHandler.Handler(){

                    @Override
                    public void run() throws Exception {
                        for (Long objId : finalUpdateCounterIds) {
                            UpdateCounterCacheHandler.removeUpdateCounter(objId);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        updateCounterIds.add(id);
    }
}

