/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;

public class MoveGlobalObjectsFromFolderToFolder {
    private SessionController sessionController = null;

    public MoveGlobalObjectsFromFolderToFolder(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void move(String sourceFolder, String destinationFolder) throws Exception {
        FolderObjectClientBean mySourceFolder = null;
        FolderObjectClientBean myDestinationFolder = null;
        if (sourceFolder != null) {
            mySourceFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(sourceFolder);
        }
        if (destinationFolder != null) {
            myDestinationFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(destinationFolder);
        }
        this.move(mySourceFolder, myDestinationFolder);
    }

    public void move(FolderObjectClientBean sourceFolder, FolderObjectClientBean destinationFolder) throws Exception {
        if (sourceFolder != null && destinationFolder != null) {
            GlobalObjectClientBean[] items = sourceFolder.getItems();
            RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
            if (items != null) {
                int len = items.length;
                for (int i = 0; i < len; ++i) {
                    rfs.move(sourceFolder, destinationFolder, items[i]);
                    items[i].leaveAcl(destinationFolder.getAcl(), null);
                }
            }
        }
    }

    public void moveAllHomeObjects(String baseHomePath, String destinationPath) throws Exception {
        if (baseHomePath != null) {
            FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(baseHomePath);
            this.moveAllHomeObjects(folder, destinationPath);
        }
    }

    public void moveAllHomeObjects(FolderObjectClientBean folder, String destinationPath) throws Exception {
        GlobalObjectClientBean[] items;
        boolean depth = false;
        if (folder != null && (items = folder.getItems()) != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                if (!(items[i] instanceof FolderObjectClientBean) || depth) continue;
                StringUtils su = new StringUtils();
                String myDestPath = su.strReplace(destinationPath, "$$USERNAME$$", items[i].getName());
                FolderObjectClientBean myDestinationPath = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(myDestPath);
                this.move((FolderObjectClientBean)items[i], myDestinationPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setAuthInterface(new ServiceAuthInterface());
            credential.setModulInfo("MoveGlobalObjectsFromFolderToFolder");
            SessionController sessionController = SessionController.connect(credential);
            MoveGlobalObjectsFromFolderToFolder moveGlobalObjectsFromFolderToFolder = new MoveGlobalObjectsFromFolderToFolder(sessionController);
            RoiTransactionHandler rth = null;
            try {
                rth = new RoiTransactionHandler();
                rth.begin();
                moveGlobalObjectsFromFolderToFolder.moveAllHomeObjects("/agorum/roi/Files/d4wdemo/Home", "/Home/$$USERNAME$$/MyFiles/profile");
                rth.end();
                rth = null;
            }
            catch (Exception exception) {
            }
            finally {
                if (rth != null) {
                    try {
                        rth.abort();
                        rth = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Programm ende");
    }
}

