/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AuthenticationHandler;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;

public class LdapGatewayAuthenticationHandler
implements AuthenticationHandler {
    private static SessionController sessionController = null;
    private static Object syncer = new Object();

    @Override
    public boolean authenticate(Connection conn, CredentialObject credential) {
        URL url = null;
        try {
            url = new URL("http://localhost:8081/provisioning-gw/user/authenticate");
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            System.err.println("Invalid url in LDAP GW Handler");
            return false;
        }
        try {
            this.connect();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Unable to connect to SessionController, fallback to default LDAP GW URL");
            return this.authenticate(credential, url);
        }
        String key = "MAIN_MODULE_MANAGEMENT/dataspace/control";
        MetaDb mdb = null;
        try {
            mdb = sessionController.getMetaDbInstance();
        }
        catch (MetaDbException e1) {
            System.err.println(e1.getMessage());
            System.err.println("Unable to connect to MetaDb, fallback to default LDAP GW URL");
            return this.authenticate(credential, url);
        }
        try {
            url = new URL(mdb.getSimplePropertyValue(key + "/LdapGWHost")[0]);
        }
        catch (Exception e) {
            System.out.println("LDAP GW Url not configured, fallback to default URL");
        }
        return this.authenticate(credential, url);
    }

    private boolean authenticate(CredentialObject credential, URL url) {
        URLConnection connection;
        HttpURLConnection httpConnection = null;
        try {
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                httpConnection = (HttpURLConnection)connection;
                httpConnection.setDoInput(true);
                httpConnection.setDoOutput(true);
                httpConnection.setUseCaches(false);
                httpConnection.setRequestMethod("POST");
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.err.println("Unable to urlopen in LDAP GW Handler");
            return false;
        }
        String authString = "{\"username\":\"" + credential.getUserName() + "\",\"password\":\"" + credential.getClearTextPassword() + "\"}";
        DirectoryUserObjectClientBean userObj = credential.getUserObject();
        if (null != userObj) {
            try {
                String dn = null;
                AttributeValue av = userObj.getExtendedAttribute("dirorigin");
                if (null != av) {
                    dn = av.getString();
                }
                if (null != dn && !dn.isEmpty()) {
                    authString = "{\"username\":\"" + credential.getUserName() + "\",\"password\":\"" + credential.getClearTextPassword() + "\",\"origin\":\"" + dn + "\"}";
                }
            }
            catch (Exception dn) {
                // empty catch block
            }
        }
        try {
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "GDS2 LDAP-Gateway AuthenticationHandler");
            connection.setRequestProperty("Content-Length", Integer.toString(authString.length()));
            connection.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.err.println("Unable to url connect in LDAP GW Handler");
            return false;
        }
        if (null != httpConnection) {
            block23: {
                String response;
                int code;
                try {
                    DataOutputStream output = new DataOutputStream(httpConnection.getOutputStream());
                    output.writeBytes(authString);
                    output.flush();
                    output.close();
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    System.err.println("Unable to send request in LDAP GW Handler");
                    return false;
                }
                try {
                    code = httpConnection.getResponseCode();
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    System.err.println("Unable to fetch response code in LDAP GW Handler");
                    return false;
                }
                System.out.println("Authenticating user " + credential.getUserName() + " against LDAP GW " + url.toString() + " => " + Integer.toString(code));
                if (code == 200) {
                    try {
                        response = "";
                        String tmp = null;
                        DataInputStream input = new DataInputStream(httpConnection.getInputStream());
                        while (null != (tmp = input.readLine())) {
                            response = response + tmp;
                        }
                        input.close();
                        System.out.println("Authresponse='" + response + "'");
                        if (response.contains("\"success\":true")) {
                            return true;
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                        System.err.println("Unable to fetch response content in LDAP GW Handler");
                        return false;
                    }
                }
                try {
                    response = "";
                    String tmp = null;
                    DataInputStream input = new DataInputStream(httpConnection.getInputStream());
                    while (null != (tmp = input.readLine())) {
                        response = response + tmp;
                    }
                    input.close();
                    System.out.println("Authresponse='" + response + "'");
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    System.err.println("Unable to fetch response content in LDAP GW Handler");
                    return false;
                }
            }
            return false;
        }
        System.err.println("error - not a http request!");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws Exception {
        Object object = syncer;
        synchronized (object) {
            if (sessionController == null) {
                try {
                    RoiProperties rp = new RoiProperties();
                    CredentialObject credential = new CredentialObject();
                    credential.setUserName(rp.getRoiSystemUser());
                    credential.setAuthInterface(new ServiceAuthInterface());
                    credential.setModulInfo("RadiusAuthentication");
                    sessionController = SessionController.connect(credential);
                }
                catch (Exception exception) {}
            } else {
                sessionController.reconnectIfNeeded();
            }
        }
    }

    @Override
    public boolean checkWithLoginLogoutHandler() {
        return false;
    }
}

