/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.roi.common.utils.Beans;
import agorum.roi.common.utils.DataHandler;
import agorum.roi.common.utils.DataHandlerFactory;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.ChangeHistoryRelationObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AclUserResolver;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.virtual.VirtualFolderDescription;
import agorum.roi.ejb.virtual.VirtualFolderDescriptionProvider;
import agorum.roi.ejb.virtual.VirtualFolderHelper;
import agorum.roi.ejb.virtual.VirtualFolderMetadataHandler;
import agorum.roi.ejb.virtual.VirtualRuleDescription;
import agorum.roi.ejb.virtual.VirtualRuleProcessor;
import agorum.roi.exception.RoiException;
import agorum.roi.searchengine.AdvancedSearchQuery;
import agorum.roi.searchengine.AdvancedSearchResult;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.SmartFolderStatistic;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FolderObjectClientBeanWrapper
extends FolderObjectClientBean {
    private static final long serialVersionUID = -4721869596748408272L;
    private static final String TRANSLATION_METADB_PATH = "MAIN_MODULE_MANAGEMENT/asf/translation";
    private static final String MAX_ROWS = "MAIN_MODULE_MANAGEMENT/asf/max_row";
    private static final int DEFAULT_MAX_ROWS = 50;
    private static final String CACHE_LIFETIME = "MAIN_MODULE_MANAGEMENT/asf/cache_lifetime";
    private static final int DEFAULT_CACHE_LIFETIME = 30;
    private SmartFolderStatistic sfs = SmartFolderStatistic.getInstance();
    private FolderObjectClientBeanWrapper parent;
    private FolderObjectClientBean entryPoint;
    private VirtualFolderDescriptionProvider virtualFolderDescriptionProvider = null;
    private VirtualFolderMetadataHandler virtualFolderMetadataHandler = null;
    private String value;
    private String query;

    public FolderObjectClientBeanWrapper(FolderObjectClientBeanWrapper parent, FolderObjectClientBean entryPoint) {
        this.parent = parent;
        this.entryPoint = entryPoint;
        this.value = null;
        this.virtualFolderDescriptionProvider = new VirtualFolderDescriptionProvider(entryPoint);
        this.virtualFolderMetadataHandler = new VirtualFolderMetadataHandler(this);
    }

    public FolderObjectClientBeanWrapper(FolderObjectClientBeanWrapper parent, FolderObjectClientBean entryPoint, String value, VirtualFolderDescription description) {
        this.parent = parent;
        this.entryPoint = entryPoint;
        this.value = value;
        this.virtualFolderDescriptionProvider = new VirtualFolderDescriptionProvider(entryPoint, description);
        this.virtualFolderMetadataHandler = new VirtualFolderMetadataHandler(this);
    }

    @Override
    public SessionController getSessionController() {
        return this.entryPoint.getSessionController();
    }

    @Override
    public AttributeValue getAttribute(String attribute) throws Exception {
        if (attribute.equals("name")) {
            return AttributeValue.newAttributeValueObject(this.value);
        }
        if (attribute.equals(LOCKSTATE_ATTRIBUTE)) {
            return AttributeValue.newAttributeValueObject(0);
        }
        return this.entryPoint.getAttribute(attribute);
    }

    @Override
    public String getClassName() throws Exception {
        return this.entryPoint.getClassName();
    }

    @Override
    public String getID() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> parentValues = new ArrayList<String>();
        sb.append("asf:");
        sb.append(this.entryPoint.getUUID());
        if (this.parent != null && this.parent.getFacetValue() != null) {
            FolderObjectClientBeanWrapper currentParent = this.parent;
            do {
                parentValues.add(currentParent.getFacetValue());
            } while ((currentParent = currentParent.getParent()) != null && currentParent.getFacetValue() != null);
        }
        Collections.reverse(parentValues);
        for (String parentValue : parentValues) {
            sb.append(":");
            sb.append(parentValue);
        }
        if (this.value != null) {
            sb.append(":");
            sb.append(this.value);
        }
        return sb.toString();
    }

    @Override
    public String getUUID() {
        return this.getID();
    }

    @Override
    public Long getId() {
        return 0L;
    }

    @Override
    public String getAnyFolderPath() throws Exception {
        String currentID = this.getID();
        currentID = currentID.substring(currentID.indexOf(this.entryPoint.getUUID()) + this.entryPoint.getUUID().length() + 1);
        String[] iterableID = currentID.split(":");
        StringBuilder anyFolderPath = new StringBuilder();
        anyFolderPath.append(this.entryPoint.getAnyFolderPath());
        for (int index = 0; index <= iterableID.length - 1; ++index) {
            anyFolderPath.append("/");
            anyFolderPath.append(iterableID[index]);
        }
        return anyFolderPath.toString();
    }

    @Override
    public void delete(SuperObjectClientBeanDefinition def) throws Exception {
        if (this.parent == null) {
            this.entryPoint.delete(def);
        } else {
            ExceptionUtils.noAccess("Virtual folders may not be deleted");
        }
    }

    @Override
    public RelationObjectClientBean[] getRelations(String relationName, String attributeNameThis, String attributeNameObject, Object valueObject) throws Exception {
        RelationObjectClientBean[] rocb = new RelationObjectClientBean[]{};
        FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
        if (targetFolder != null) {
            rocb = targetFolder.getRelations(relationName, attributeNameThis, attributeNameObject, valueObject);
        }
        return rocb;
    }

    @Override
    public long[] getScopeAclsById() throws RemoteException, Exception {
        return new long[0];
    }

    @Override
    public GlobalObjectClientBean[] getAllAttachedTo() throws Exception {
        return null;
    }

    @Override
    public GlobalObjectClientBean[] getAllAttachments() throws Exception {
        return null;
    }

    @Override
    public String[] getScopeAclNames() throws RemoteException, Exception {
        return null;
    }

    @Override
    public GlobalObjectClientBean getBelongingObject() throws Exception {
        return null;
    }

    @Override
    public DirectoryUserObjectClientBean getCreator() throws Exception {
        return this.entryPoint.getSessionController().getUserByName("roi");
    }

    @Override
    public DirectoryUserObjectClientBean getOwner() throws Exception {
        return this.entryPoint.getSessionController().getUserByName("roi");
    }

    @Override
    public DirectoryUserObjectClientBean getLastModifier() throws Exception {
        return this.entryPoint.getSessionController().getUserByName("roi");
    }

    @Override
    public AccessControlListObjectClientBean getAcl() throws Exception {
        if (this.virtualFolderDescriptionProvider.getDescription().getAcl() != null) {
            return this.lookupACL(this.virtualFolderDescriptionProvider.getDescription().getAcl());
        }
        return this.lookupACL("acl:Published");
    }

    @Override
    public AccessControlListObjectClientBean[] getScopeAcls() {
        return null;
    }

    @Override
    public Map<String, AttributeValue> getStructuredExtendedAttributes() throws Exception {
        return this.virtualFolderMetadataHandler.getStructuredExtendedAttributes();
    }

    @Override
    public Map<String, AttributeValue[]> getStructuredExtendedAttributesAll() throws Exception {
        return this.virtualFolderMetadataHandler.getStructuredExtendedAttributesAll();
    }

    @Override
    public AttributeValue getExtendedAttribute(String attributeName) throws Exception {
        return this.virtualFolderMetadataHandler.getExtendedAttribute(attributeName);
    }

    @Override
    public AttributeValue[] getExtendedAttributeAll(String attributeName) throws Exception {
        return this.virtualFolderMetadataHandler.getExtendedAttributeAll(attributeName);
    }

    @Override
    public boolean isLinked() throws Exception {
        return false;
    }

    @Override
    public boolean isLinkedNotVisible() throws Exception {
        return false;
    }

    @Override
    public boolean getHasAttachments() throws Exception {
        return false;
    }

    @Override
    public boolean isAttached() throws Exception {
        return false;
    }

    @Override
    public boolean isTemporary() throws Exception {
        return this.entryPoint.isTemporary();
    }

    @Override
    public FolderObjectClientBean[] getParents() throws Exception {
        ArrayList<FolderObjectClientBean> parentList = new ArrayList<FolderObjectClientBean>();
        if (this.parent != null) {
            parentList.add(this.parent);
        } else {
            parentList.addAll(Arrays.asList(this.entryPoint.getParents()));
        }
        return parentList.toArray(new FolderObjectClientBean[0]);
    }

    @Override
    public String getName() throws Exception {
        return this.determineName();
    }

    @Override
    public String getDisplayName() throws Exception {
        return this.createDisplayName();
    }

    @Override
    public boolean getIsFolder() throws Exception {
        return true;
    }

    @Override
    public boolean getMayInsert() throws Exception {
        return this.checkEffectiveAccess(16384L);
    }

    @Override
    public boolean getMayRemove() throws Exception {
        return this.checkEffectiveAccess(32768L);
    }

    @Override
    public boolean getMayModify() throws Exception {
        return false;
    }

    @Override
    public boolean getMayDelete() throws Exception {
        boolean returnValue = false;
        if (this.parent == null) {
            returnValue = this.entryPoint.getMayDelete();
        }
        return returnValue;
    }

    @Override
    public Date getUpdateDate() throws Exception {
        return new Date();
    }

    @Override
    public Date getCreateDate() throws Exception {
        return new Date();
    }

    @Override
    public Date getLastModifyDate() throws Exception {
        return new Date();
    }

    @Override
    public int getFlags() throws Exception {
        return 4;
    }

    @Override
    public long getSystemFlags() throws Exception {
        return 3L;
    }

    @Override
    public boolean checkEffectiveAccess(long accessLevel) throws Exception {
        return this.checkEffectiveAccess(this.getAcl().getName(), accessLevel, null, null);
    }

    @Override
    public boolean checkEffectiveAccess(long accessLevel, String lockIdentifier) throws Exception {
        return this.checkEffectiveAccess(this.getAcl().getName(), accessLevel, lockIdentifier, null);
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        return this.checkEffectiveAccess(this.getAcl().getName(), accessLevel, null, ignoreSharedLock);
    }

    @Override
    public GlobalObjectClientBean[] getRightwardRelationObjects(String relationName) throws Exception {
        if (relationName.equals(ChangeHistoryRelationObjectClientBean.CLASS_NAME)) {
            return null;
        }
        return this.entryPoint.getRightwardRelationObjects(relationName);
    }

    @Override
    public void checkCycle(GlobalObjectClientBean gocb) throws Exception {
    }

    @Override
    public void addDeletedItem(GlobalObjectClientBean ro, boolean direct) throws Exception {
        FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
        if (targetFolder != null) {
            targetFolder.addDeletedItem(ro, direct);
        }
    }

    @Override
    public void removeItem(GlobalObjectClientBean gocb) throws Exception {
        FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
        if (targetFolder != null) {
            FolderObjectClientBean rawTargetFolder = (FolderObjectClientBean)targetFolder.asRaw();
            rawTargetFolder.removeItem(gocb);
        }
    }

    @Override
    public boolean canRemoveItem(SessionController sessionController, SuperObjectClientBean socb) throws Exception {
        boolean returnValue = false;
        FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
        if (targetFolder != null) {
            returnValue = targetFolder.canRemoveItem(sessionController, socb);
        }
        return returnValue;
    }

    @Override
    @Deprecated
    public void addItem(GlobalObjectClientBean ro) throws Exception {
        this.add(ro);
    }

    @Override
    @Deprecated
    public void addItem(GlobalObjectClientBean ro, SuperObjectClientBeanDefinition def) throws Exception {
        this.add(ro, def);
    }

    @Override
    public RelationObjectClientBean add(GlobalObjectClientBean ro) throws Exception {
        return this.add(ro, null);
    }

    @Override
    public RelationObjectClientBean add(GlobalObjectClientBean ro, SuperObjectClientBeanDefinition def) throws Exception {
        return this.addToTarget(ro, def);
    }

    @Override
    public boolean hasItem(String name) throws Exception {
        boolean hasItem = false;
        String query = this.prepareQuery();
        query = query + " name:\"" + name + "\"";
        AdvancedSearchResult asr = this.search(null, query, 0);
        if (asr.total > 0L) {
            hasItem = true;
        }
        return hasItem;
    }

    @Override
    public int getItemsCountNoFolder() throws Exception {
        return this.itemsCountNoFolder(this.virtualFolderDescriptionProvider.getDescription());
    }

    @Override
    public int getItemsCountOnlyFolder() throws Exception {
        return this.itemsCountOnlyFolder(this.virtualFolderDescriptionProvider.getDescription());
    }

    @Override
    public int getItemsCount() throws Exception {
        return this.getItems().length;
    }

    @Override
    public int getRealItemsCount() throws Exception {
        return this.getItemsCount();
    }

    @Override
    public GlobalObjectClientBean[] getItemsObjectsOnly(String[] objectClassNames) throws Exception {
        return this.getItems();
    }

    @Override
    public GlobalObjectClientBean getItem(String name, boolean useLike) throws Exception {
        GlobalObjectClientBean returnObject = null;
        returnObject = this.getItem(this.virtualFolderDescriptionProvider.getDescription(), name);
        return returnObject;
    }

    @Override
    public GlobalObjectClientBean[] getItems() throws Exception {
        return this.getItemsRecursive(this.virtualFolderDescriptionProvider.getDescription()).toArray(new GlobalObjectClientBean[0]);
    }

    @Override
    public FolderObjectClientBean createPath(String path) throws Exception {
        return this.createPath(path, null);
    }

    @Override
    public FolderObjectClientBean createPath(String path, AccessControlListObjectClientBean acl) throws Exception {
        FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
        if (targetFolder == null) {
            throw new RoiException("Target folder for smart folder could not be determined. Please check the log for further information");
        }
        FolderObjectClientBean rawClientBean = (FolderObjectClientBean)targetFolder.asRaw();
        return rawClientBean.createPath(path, acl);
    }

    public FolderObjectClientBean getEntryPoint() {
        return this.entryPoint;
    }

    public VirtualFolderMetadataHandler getVirtualFolderMetadataHandler() {
        return this.virtualFolderMetadataHandler;
    }

    public VirtualFolderDescriptionProvider getVirtualFolderDescriptionProvider() {
        return this.virtualFolderDescriptionProvider;
    }

    @Override
    public String toString() {
        return this.getUUID();
    }

    public String getQuery() throws Exception {
        return this.prepareQuery();
    }

    public String getFacetField() throws Exception {
        return this.virtualFolderDescriptionProvider.getDescription().getFacet();
    }

    public FolderObjectClientBeanWrapper getParent() {
        return this.parent;
    }

    public String getFacetValue() {
        return this.value;
    }

    private Long getCreationDifference() throws Exception {
        MetaDb metaDb = this.entryPoint.getSessionController().getMetaDbInstance();
        int definedLifeTime = 30;
        String[] cacheLifeTime = metaDb.getSimplePropertyValue(CACHE_LIFETIME);
        if (cacheLifeTime != null && cacheLifeTime.length > 0) {
            definedLifeTime = Integer.parseInt(cacheLifeTime[0]);
        }
        return new Long(definedLifeTime * 1000);
    }

    private RelationObjectClientBean addToTarget(GlobalObjectClientBean ro, SuperObjectClientBeanDefinition def) throws Exception {
        if (this.checkEffectiveAccess(16384L)) {
            FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
            if (targetFolder != null) {
                FolderObjectClientBean rawClientBean = (FolderObjectClientBean)targetFolder.asRaw();
                return rawClientBean.add(ro, def);
            }
        } else {
            ExceptionUtils.noAccess("No Access");
        }
        return null;
    }

    private AccessControlListObjectClientBean lookupACL(String acl) {
        if (!acl.contains("acl:")) {
            acl = "acl:" + acl;
        }
        return (AccessControlListObjectClientBean)Beans.lookup(this.entryPoint.getSessionController(), acl);
    }

    private boolean checkEffectiveAccess(String acl, long accessLevel, String lockIdentifier, Boolean ignoreSharedLock) throws Exception {
        if (Long.compare(accessLevel, 16384L) == 0 || Long.compare(accessLevel, 32768L) == 0) {
            FolderObjectClientBean targetDirectory = VirtualFolderHelper.determineTargetFolder(this);
            if (targetDirectory != null) {
                if (ignoreSharedLock != null) {
                    DirectoryUserObjectClientBean role = this.sessionController.getRole();
                    return targetDirectory.checkEffectiveAccess(role, accessLevel, ignoreSharedLock);
                }
                if (lockIdentifier != null && !lockIdentifier.isEmpty()) {
                    return targetDirectory.checkEffectiveAccess(accessLevel, lockIdentifier);
                }
                return targetDirectory.checkEffectiveAccess(accessLevel);
            }
            return false;
        }
        if (lockIdentifier != null && !lockIdentifier.isEmpty()) {
            return false;
        }
        if (ignoreSharedLock != null && ignoreSharedLock.booleanValue()) {
            return false;
        }
        if (acl != null && !acl.isEmpty()) {
            GenericCache aclCache = GenericCache.getInstance((Object)("Roi.FolderObjectClientBeanWrapper.ACL" + this.entryPoint.getSessionController().getSessionId()));
            Object cachedAccess = aclCache.get((Object)acl);
            if (cachedAccess == null) {
                long aclId = this.lookupACL(acl).getId();
                boolean access = AclUserResolver.checkEffectiveAccess(this.entryPoint.getSessionController().getLoginUser(), new long[]{aclId}, accessLevel);
                aclCache.put((Object)acl, (Object)access);
                return access;
            }
            return (Boolean)cachedAccess;
        }
        long aclId = 0L;
        AccessControlListObjectClientBean aclObject = this.lookupACL("Published");
        if (aclObject != null) {
            aclId = aclObject.getId();
        }
        return AclUserResolver.checkEffectiveAccess(this.entryPoint.getSessionController().getLoginUser(), new long[]{aclId}, accessLevel);
    }

    private int itemsCountNoFolder(VirtualFolderDescription localDescription) throws Exception {
        int itemsCount = 0;
        if (localDescription.getRules() != null) {
            VirtualFolderDescription ruleItem = VirtualRuleProcessor.processRules(localDescription.getRules(), this.value);
            itemsCount = this.itemsCountNoFolder(ruleItem);
        } else if (localDescription.getFacet() == null) {
            StringBuilder localQuery = new StringBuilder();
            localQuery.append("(").append(this.prepareQuery()).append(") isfolder:false");
            AdvancedSearchResult asr = this.search(null, localQuery.toString(), 0);
            itemsCount = new Long(asr.total).intValue();
        }
        return itemsCount;
    }

    private int itemsCountOnlyFolder(VirtualFolderDescription localDescription) throws Exception {
        int folderCount = 0;
        if (localDescription.getFolders() != null) {
            folderCount = localDescription.getFolders().size();
        } else if (localDescription.getFacet() != null) {
            AdvancedSearchResult asr = this.search(localDescription.getFacet(), this.prepareQuery(), 0);
            folderCount = new Long(asr.total).intValue();
        } else if (localDescription.getRules() != null) {
            VirtualFolderDescription ruleItem = VirtualRuleProcessor.processRules(localDescription.getRules(), this.value);
            folderCount = this.itemsCountOnlyFolder(ruleItem);
        } else {
            StringBuilder localQuery = new StringBuilder();
            localQuery.append("(").append(this.prepareQuery()).append(") isfolder:true");
            AdvancedSearchResult asr = this.search(null, localQuery.toString(), 0);
            folderCount = new Long(asr.total).intValue();
        }
        return folderCount;
    }

    private int getMaxRowCount() {
        int maxRows = 0;
        MetaDb metaDb = this.entryPoint.getSessionController().getMetaDbInstance();
        String[] maxRow = metaDb.getSimplePropertyValue(MAX_ROWS);
        maxRows = maxRow != null && maxRow.length > 0 ? Integer.parseInt(maxRow[0]) : 50;
        return maxRows;
    }

    private AdvancedSearchResult search() throws Exception {
        return this.search(null, null, null);
    }

    private AdvancedSearchResult search(String facetField, String searchQuery, Integer maxRows) throws Exception {
        IndexHandlerInterface ihd = IndexHelper.getIndexHandlerDefault();
        if (searchQuery == null || searchQuery.isEmpty()) {
            searchQuery = this.prepareQuery();
        }
        AdvancedSearchQuery asq = new AdvancedSearchQuery(this.entryPoint.getSessionController(), ihd, searchQuery);
        if (facetField != null && !facetField.isEmpty()) {
            asq.facetMinCount(1);
            asq.facetFields(facetField);
        }
        if (maxRows == null) {
            maxRows = this.getMaxRowCount();
        }
        asq.rows(maxRows);
        return asq.search(new String[0]);
    }

    private boolean isValidName(String name) throws Exception {
        boolean isValid = true;
        SmartFolderStatistic sfs = SmartFolderStatistic.getInstance();
        if (name != null && !name.isEmpty()) {
            RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
            String endChars = rpmd.getNameEndNotWithChars();
            String notAllowedChars = rpmd.getNotAllowedNameChars();
            if (endChars.indexOf(name.charAt(name.length() - 1)) > -1) {
                isValid = false;
                sfs.error("AgorumSmartFolder: Name used with invalid ending \"" + name.charAt(name.length() - 1) + "\". Full name: " + name);
            }
            if (isValid) {
                int index = 0;
                do {
                    if (name.indexOf(notAllowedChars.charAt(index)) <= -1) continue;
                    isValid = false;
                    sfs.error("AgorumSmartFolder: Name used with invalid character \"" + notAllowedChars.charAt(index) + "\". Full name: " + name);
                } while (++index < notAllowedChars.length() - 1 && isValid);
            }
        }
        return isValid;
    }

    private GlobalObjectClientBean getItem(VirtualFolderDescription description, String name) throws Exception {
        Map<String, VirtualFolderDescription> folders = description.getFolders();
        VirtualRuleDescription[] rules = description.getRules();
        GlobalObjectClientBean returnObject = null;
        if (folders != null && folders.size() > 0) {
            for (Map.Entry<String, VirtualFolderDescription> entry : folders.entrySet()) {
                if (!entry.getKey().toLowerCase().equals(name.toLowerCase())) continue;
                returnObject = new FolderObjectClientBeanWrapper(this, this.entryPoint, name, entry.getValue());
            }
        } else if (rules != null) {
            VirtualFolderDescription ruleItem = VirtualRuleProcessor.processRules(rules, name);
            if (ruleItem != null) {
                returnObject = new FolderObjectClientBeanWrapper(this, this.entryPoint, name, ruleItem);
            }
        } else {
            FolderObjectClientBean targetFolder;
            returnObject = this.searchForItem(name);
            if (returnObject == null && (targetFolder = VirtualFolderHelper.determineTargetFolder(this)) != null) {
                returnObject = targetFolder.getItem(name);
            }
        }
        return returnObject;
    }

    private GlobalObjectClientBean searchForItem(String name) throws Exception {
        GlobalObjectClientBean returnObject = null;
        AdvancedSearchResult asr = this.search();
        List<Map<String, AttributeInfo>> rows = asr.rows;
        ArrayList<GlobalObjectClientBean> searchResultBeans = new ArrayList<GlobalObjectClientBean>();
        for (Map<String, AttributeInfo> entry : rows) {
            GlobalObjectClientBean dbBean = (GlobalObjectClientBean)Beans.tryLookup(this.entryPoint.getSessionController(), (String)entry.get((Object)"uuid").value);
            searchResultBeans.add(dbBean);
        }
        for (GlobalObjectClientBean gocb : searchResultBeans) {
            String objectName = gocb.getName().toLowerCase();
            if (!objectName.equals(name.toLowerCase()) || gocb.isDeleted()) continue;
            returnObject = gocb;
        }
        return returnObject;
    }

    private List<GlobalObjectClientBean> getItemsRecursive(VirtualFolderDescription description) throws Exception {
        ArrayList<GlobalObjectClientBean> facetResults;
        block8: {
            Map<String, VirtualFolderDescription> folders;
            block7: {
                facetResults = new ArrayList<GlobalObjectClientBean>();
                String facetField = description.getFacet();
                folders = description.getFolders();
                VirtualRuleDescription[] rules = description.getRules();
                if (facetField == null || facetField.isEmpty()) break block7;
                AdvancedSearchResult asr = this.search(facetField, null, null);
                Map<String, Long> facetValues = asr.facetFields.get(facetField);
                if (facetValues == null) break block8;
                for (Map.Entry<String, Long> entry : facetValues.entrySet()) {
                    VirtualFolderDescription ruleItem = VirtualRuleProcessor.processRules(rules, entry.getKey());
                    if (ruleItem == null || !this.checkEffectiveAccess(ruleItem.getAcl(), 1L, null, null) || !this.isValidName(entry.getKey())) continue;
                    facetResults.add(new FolderObjectClientBeanWrapper(this, this.entryPoint, entry.getKey(), ruleItem));
                }
                break block8;
            }
            if (folders != null && folders.size() > 0) {
                for (Map.Entry<String, VirtualFolderDescription> entry : folders.entrySet()) {
                    if (!this.checkEffectiveAccess(entry.getValue().getAcl(), 1L, null, null) || !this.isValidName(entry.getKey())) continue;
                    facetResults.add(new FolderObjectClientBeanWrapper(this, this.entryPoint, entry.getKey(), entry.getValue()));
                }
            } else {
                Long range;
                GlobalObjectClientBean[] newlyCreatedElements;
                AdvancedSearchResult asr = this.search();
                List<Map<String, AttributeInfo>> rows = asr.rows;
                for (Map<String, AttributeInfo> entry : rows) {
                    String entryUUID = (String)entry.get((Object)"uuid").value;
                    GlobalObjectClientBean dbBean = (GlobalObjectClientBean)Beans.tryLookup(this.entryPoint.getSessionController(), entryUUID);
                    if (dbBean == null || dbBean.isDeleted()) continue;
                    facetResults.add(dbBean);
                }
                FolderObjectClientBean targetFolder = VirtualFolderHelper.determineTargetFolder(this);
                if (targetFolder != null && (newlyCreatedElements = targetFolder.getItems(false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.CREATEDATE_ATTRIBUTE}, new Object[]{new Date(range = Long.valueOf(System.currentTimeMillis() - this.getCreationDifference()))}, new int[]{3}, new boolean[]{false}, new int[]{1}, null, null, null)) != null) {
                    for (GlobalObjectClientBean bean : newlyCreatedElements) {
                        if (facetResults.contains(bean)) continue;
                        facetResults.add(bean);
                    }
                }
            }
        }
        return facetResults;
    }

    private String determineName() throws Exception {
        String name = null;
        name = this.parent == null ? this.entryPoint.getName() : this.value;
        return name;
    }

    private String prepareQuery() throws Exception {
        if (this.query == null) {
            if (this.parent != null && this.virtualFolderDescriptionProvider.getDescription().isStandaloneQuery()) {
                this.query = this.getQueryFromDefinition();
            } else {
                String definitionQuery;
                StringBuilder sb = new StringBuilder();
                if (this.parent != null) {
                    sb.append(this.parent.getQuery());
                    String facetField = this.parent.getFacetField();
                    if (facetField != null && !facetField.isEmpty()) {
                        if (sb.length() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(facetField);
                        sb.append(":\"");
                        sb.append(this.value);
                        sb.append("\"");
                    }
                }
                if ((definitionQuery = this.getQueryFromDefinition()) != null && !definitionQuery.isEmpty()) {
                    if (sb.length() > 0) {
                        sb.append(" AND ");
                    }
                    sb.append("(");
                    sb.append(this.getQueryFromDefinition());
                    sb.append(")");
                }
                this.query = sb.toString();
            }
        }
        return this.query;
    }

    private String getQueryFromDefinition() throws Exception {
        String descriptionQuery = VirtualFolderHelper.getResolvedQuery(this);
        if (descriptionQuery != null && descriptionQuery.isEmpty()) {
            this.sfs.error("Empty query defined within definition for entry point with uuid: " + this.entryPoint.getUUID());
        }
        return descriptionQuery;
    }

    private String createDisplayName() throws Exception {
        String displayName = this.determineName();
        String language = this.entryPoint.getSessionController().getLoginUser().getInfoUserProfile().getLanguage();
        if (language != null && !language.isEmpty() && this.value != null) {
            String translation;
            Object csvObject;
            DataHandler csvHandler = DataHandlerFactory.getHandler(this.entryPoint.getSessionController(), TRANSLATION_METADB_PATH);
            List<Map<String, Object>> csvResult = null;
            try {
                csvResult = csvHandler.read(this.value, new HashMap<String, Object>());
            }
            catch (NullPointerException npe) {
                SmartFolderStatistic sfs = SmartFolderStatistic.getInstance();
                sfs.debug(npe, "CSV Handler for global translation file can not be found");
            }
            if (csvResult != null && csvResult.size() > 0 && (csvObject = csvResult.get(0).get(language)) != null && !(translation = (String)csvObject).isEmpty()) {
                displayName = translation;
            }
        }
        return displayName;
    }
}

