/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import java.util.Date;
import java.util.Hashtable;

public class FileObjectClientBeanWrapper
extends FileObjectClientBean {
    private static final long serialVersionUID = 1L;
    private String content = "";
    private String fileName = "";
    private Date fileDate = new Date();
    private VirtualFormatObjectClientBean vfocb;

    public FileObjectClientBeanWrapper(String fileName) {
        this.fileName = fileName;
        this.vfocb = new VirtualFormatObjectClientBean();
    }

    public int read(long offset, byte[] buffer, int bufOffset, int len) {
        int readBytes = 0;
        byte[] bytesOfContent = this.content.getBytes();
        if (offset > (long)bytesOfContent.length) {
            readBytes = -1;
        }
        int index = new Long(offset).intValue();
        int bufferPosition = bufOffset;
        while (index < len && index < bytesOfContent.length) {
            buffer[bufferPosition] = bytesOfContent[index];
            ++bufferPosition;
            ++index;
            ++readBytes;
        }
        return readBytes;
    }

    @Override
    public Hashtable<String, AttributeValue> getExtendedAttributes() throws Exception {
        return null;
    }

    @Override
    public Date getUpdateDate() throws Exception {
        return this.fileDate;
    }

    @Override
    public Date getCreateDate() throws Exception {
        return this.fileDate;
    }

    @Override
    public Date getLastModifyDate() throws Exception {
        return this.fileDate;
    }

    @Override
    public String getName() throws Exception {
        return this.fileName;
    }

    @Override
    public boolean getIsFolder() throws Exception {
        return false;
    }

    @Override
    public int getFlags() throws Exception {
        return 6;
    }

    @Override
    public long getSystemFlags() throws Exception {
        return 0L;
    }

    @Override
    public boolean checkEffectiveAccess(long accessLevel, String lockIdentifier) throws Exception {
        if (lockIdentifier != null && !lockIdentifier.isEmpty()) {
            return false;
        }
        DirectoryUserObjectClientBean role = this.sessionController.getRole();
        return this.checkEffectiveAccess(role, accessLevel, false);
    }

    @Override
    public boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long accessLevel, boolean ignoreSharedLock) throws Exception {
        if (ignoreSharedLock) {
            return false;
        }
        return super.checkEffectiveAccess(directoryObject, accessLevel, ignoreSharedLock);
    }

    @Override
    public int getLockState() throws Exception {
        return 0;
    }

    @Override
    public String getID() {
        return "virtualFile:" + this.fileName;
    }

    @Override
    public FormatObjectClientBean getFormat() throws Exception {
        return this.vfocb;
    }

    @Override
    public String getContentString() throws Exception {
        return this.content;
    }

    @Override
    public void setContentString(String text) throws Exception {
        this.content = text;
    }

    @Override
    public long getContentSize() throws Exception {
        return this.getContentSize(false);
    }

    @Override
    public long getContentSize(boolean doNotGenerateContent) throws Exception {
        return new Integer(this.content.length()).longValue();
    }

    private class VirtualFormatObjectClientBean
    extends FormatObjectClientBean {
        private static final long serialVersionUID = 1L;
        private String mimeType;

        private VirtualFormatObjectClientBean() {
        }

        @Override
        public String getMimeType() throws Exception {
            return this.mimeType;
        }

        @Override
        public void setMimeType(String value) throws Exception {
            this.mimeType = value;
        }
    }
}

