/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBHomeHolder {
    private Hashtable homeCache = new Hashtable();
    private InitialContext initialContext = null;
    public static final EJBHomeHolder ejbHomeHolder = new EJBHomeHolder();

    public static Object getHome(String jndiName) throws NamingException {
        return ejbHomeHolder.getCachedHome(jndiName);
    }

    public static InitialContext getInitialContext() {
        return ejbHomeHolder.getCachedInitialContext();
    }

    public InitialContext getCachedInitialContext() {
        if (this.initialContext == null) {
            this.initialContext = this.initInitialContext();
        }
        return this.initialContext;
    }

    private Object getCachedHome(String jndiName) throws NamingException {
        if (this.homeCache.containsKey(jndiName)) {
            return this.homeCache.get(jndiName);
        }
        return this.storeEJBHome(jndiName);
    }

    private synchronized Object storeEJBHome(String jndiName) throws NamingException {
        if (this.homeCache.containsKey(jndiName)) {
            return this.homeCache.get(jndiName);
        }
        if (this.initialContext == null) {
            this.initialContext = this.initInitialContext();
        }
        Object ejbHome = this.initialContext.lookup(jndiName);
        this.homeCache.put(jndiName, ejbHome);
        return ejbHome;
    }

    private InitialContext initInitialContext() {
        try {
            ResourceBundle prb = PropertyResourceBundle.getBundle("jndi");
            Hashtable<String, String> env = null;
            try {
                env = new Hashtable<String, String>();
                String providerUrl = prb.getString("java.naming.provider.url");
                System.err.println(providerUrl);
                if (providerUrl != null) {
                    env.put("java.naming.provider.url", providerUrl);
                }
                String initial = prb.getString("java.naming.factory.initial");
                System.err.println(initial);
                if (initial != null) {
                    env.put("java.naming.factory.initial", initial);
                }
                String pkgs = prb.getString("java.naming.factory.url.pkgs");
                System.err.println(pkgs);
                if (pkgs != null) {
                    env.put("java.naming.factory.url.pkgs", pkgs);
                }
                return new InitialContext(env);
            }
            catch (Exception exception) {
                return new InitialContext();
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

