/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.CryptKeyAuthInterface;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.home.CryptKeyHome;
import agorum.roi.ejb.interfaces.remote.CryptKeyRemote;
import java.util.ArrayList;

public class CryptKeyController {
    private CryptKeyRemote cryptKeyRemote = null;
    private ArrayList syncVar = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptKeyRemote getCryptKeyRemote() throws Exception {
        ArrayList arrayList = this.syncVar;
        synchronized (arrayList) {
            try {
                if (this.cryptKeyRemote == null) {
                    CryptKeyHome home = (CryptKeyHome)EJBHomeHolder.getHome("ejb/CryptKey");
                    this.cryptKeyRemote = home.create();
                }
                return this.cryptKeyRemote;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ExceptionUtils.handleException(e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPublicKey(String ident, SessionController sessionController) throws Exception {
        byte[] publicKey = null;
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            publicKey = this.getCryptKeyRemote().getPublicKey(ident, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decrypt(String encryptedStr, String ident, SessionController sessionController) throws Exception {
        String unencrypted = null;
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            unencrypted = this.getCryptKeyRemote().decrypt(encryptedStr, ident, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
        return unencrypted;
    }

    public String tryDecrypt(String encryptedStr, String ident, SessionController sessionController) {
        try {
            return this.decrypt(encryptedStr, ident, sessionController);
        }
        catch (Exception exception) {
            return encryptedStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String unencrypt(String encryptedStr, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        String unencrypted = null;
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            unencrypted = this.getCryptKeyRemote().unencrypt(encryptedStr, ident, caller, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
        return unencrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String unencryptedStr, String ident, SessionController sessionController) throws Exception {
        String encrypted = null;
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            encrypted = this.getCryptKeyRemote().encrypt(unencryptedStr, ident, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
        return encrypted;
    }

    public void createCryptKeyPair(String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        this.createCryptKeyPair(ident, caller, false, sessionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCryptKeyPair(String ident, CryptKeyAuthInterface caller, boolean overwriteKeys, SessionController sessionController) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            this.getCryptKeyRemote().createCryptKeyPair(ident, caller, overwriteKeys, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCryptKeyPair(String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            this.getCryptKeyRemote().deleteCryptKeyPair(ident, caller, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(String registerIdent, String registerClassName, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            this.getCryptKeyRemote().registerClass(registerIdent, registerClassName, ident, caller, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClass(String registerIdent, String registerClassName, String ident, CryptKeyAuthInterface caller, SessionController sessionController) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            this.getCryptKeyRemote().unregisterClass(registerIdent, registerClassName, ident, caller, sessionController);
            rth.end();
            rth = null;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception exception) {}
        }
    }
}

