/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.common.CheckCredentialInterface;
import agorum.roi.ejb.common.ClassBasedAuthInterface;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.statistic.SessionControllerStatistic;
import java.io.Serializable;

public class CredentialObject
implements Serializable {
    static final Statistic stat = SessionControllerStatistic.getInstance();
    private String userName = null;
    private String passWord = null;
    private String clearTextPassword = null;
    private boolean useDesEncryption = true;
    private boolean ownDesEncryption = false;
    private boolean notSetNtPassword = false;
    private String modulInfo = null;
    private String clientInfo = null;
    private String ip = null;
    private String mac = null;
    private String[] aliases = null;
    private String credentialManager = null;
    private CheckCredentialInterface checkCredentialInterface = null;
    private ClassBasedAuthInterface authInterface = null;
    private String oldPassword = null;
    private String originalUserName = null;
    private boolean authenticatedByHandler = false;
    private String loginInfo = null;
    private boolean authenticatedExternally;

    public boolean isAuthenticatedByHandler() {
        return this.authenticatedByHandler;
    }

    public void setAuthenticatedByHandler(boolean authenticatedByHandler) {
        this.authenticatedByHandler = authenticatedByHandler;
    }

    public String getOriginalUserName() {
        return this.originalUserName;
    }

    public void setOriginalUserName(String originalUserName) {
        this.originalUserName = originalUserName;
    }

    public String getClearTextPassword() {
        return this.clearTextPassword;
    }

    public void setClearTextPassword(String clearTextPassword) {
        this.clearTextPassword = clearTextPassword;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String newPassWord) {
        this.passWord = newPassWord;
    }

    public String getUserName() {
        return this.getRoleOrUserName("user");
    }

    public String getRoleName() {
        return this.getRoleOrUserName("role");
    }

    private String getRoleOrUserName(String type) {
        RoiProperties rp = new RoiProperties();
        String delim = rp.getRoleDelimiter();
        if (this.userName != null) {
            int roleDelimiterPos = this.userName.indexOf(delim);
            if (type.equals("user")) {
                if (roleDelimiterPos > 0) {
                    return this.userName.substring(0, roleDelimiterPos);
                }
                return this.userName;
            }
            if (type.equals("role")) {
                if (roleDelimiterPos > 0) {
                    return this.userName.substring(roleDelimiterPos + 1);
                }
                return null;
            }
        }
        return null;
    }

    public void setUserName(String newUserName) {
        int i;
        String newDomain = null;
        if (newUserName != null && (i = newUserName.indexOf("@")) > 0) {
            newDomain = newUserName.substring(i + 1);
            newUserName = newUserName.substring(0, i);
        }
        this.setUserName(newUserName, newDomain);
    }

    public void setUserName(String newUserName, String newDomain) {
        String role;
        if (this.userName != null && (role = this.getRoleOrUserName("role")) != null) {
            this.userName = newUserName + new RoiProperties().getRoleDelimiter() + role;
            return;
        }
        if (newUserName != null && newDomain != null) {
            this.userName = newUserName + "@" + newDomain;
            SessionController sc = SessionControllerAdmin.getService(CredentialObject.class);
            try {
                DirectoryUserObjectClientBean user = sc.getUserByName(this.userName);
                if (user == null) {
                    user = sc.getUserByName(newUserName);
                }
                if (user == null) {
                    user = sc.getDirectoryUserFromEmailAddress(this.userName);
                }
                if (user != null) {
                    this.userName = user.getName();
                }
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Error looking up user name: " + newUserName + ", domain: " + newDomain);
            }
        } else {
            this.userName = newUserName;
        }
    }

    public boolean getUseDesEncryption() {
        return this.useDesEncryption;
    }

    public void setUseDesEncryption(boolean useDesEncryption) {
        this.useDesEncryption = useDesEncryption;
    }

    public boolean isOwnDesEncryption() {
        return this.ownDesEncryption;
    }

    public void setOwnDesEncryption(boolean ownDesEncryption) {
        this.ownDesEncryption = ownDesEncryption;
    }

    public String getModulInfo() {
        return this.modulInfo;
    }

    public void setModulInfo(String modulInfo) {
        this.modulInfo = modulInfo;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(String clientInfo) {
        this.clientInfo = clientInfo;
    }

    public boolean getNotSetNtPassword() {
        return this.notSetNtPassword;
    }

    public void setNotSetNtPassword(boolean notSetNtPassword) {
        this.notSetNtPassword = notSetNtPassword;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public String getCredentialManager() {
        return this.credentialManager == null ? "roi" : this.credentialManager;
    }

    public void setCredentialManager(String credentialManager) {
        this.credentialManager = credentialManager;
    }

    public CheckCredentialInterface getCheckCredentialInterface() {
        return this.checkCredentialInterface;
    }

    public void setCheckCredentialInterface(CheckCredentialInterface checkCredentialInterface) {
        this.checkCredentialInterface = checkCredentialInterface;
    }

    public ClassBasedAuthInterface getAuthInterface() {
        return this.authInterface;
    }

    public void setAuthInterface(ClassBasedAuthInterface authInterface) {
        this.authInterface = authInterface;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public String getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(String loginInfo) {
        this.loginInfo = loginInfo;
    }

    public boolean isAuthenticatedExternally() {
        return this.authenticatedExternally;
    }

    public void setAuthenticatedExternally(boolean authenticatedExternally) {
        this.authenticatedExternally = authenticatedExternally;
    }

    public DirectoryUserObjectClientBean getUserObject() {
        String userName = this.getUserName();
        if (userName != null) {
            try {
                return SessionControllerAdmin.getSessionControllerAdmin("CredentialObject").getUserByName(userName);
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not get user with the name " + userName);
                return null;
            }
        }
        return null;
    }
}

