/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.encrypt.ntlm.DesEncryption;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.utils.ChallengeGenerator;
import agorum.roi.ejb.common.CheckCredentialInterface;
import agorum.roi.ejb.common.CredentialObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class CheckCredentialSASLNtlm
implements CheckCredentialInterface {
    private byte[] serverNonce = null;
    private String domain = null;
    private String host = null;
    private String user = null;
    private byte[] lmResponse = null;
    private byte[] ntResponse = null;
    private static byte[] ntlmSignature = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};

    public void setType1Message(byte[] msg) throws Exception {
        if (!this.checkMessageSignatur(msg)) {
            throw new Exception("Bad type 1 NTLM message");
        }
        int msgLen = msg.length;
        if (msgLen <= 9 || msg[8] != 1) {
            throw new Exception("Bad type 1 NTLM message");
        }
        int flags = 0;
        if (msgLen <= 14) {
            throw new Exception("Bad type 1 NTLM message");
        }
        flags = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[12], msg[13], msg[14], msg[15]});
        int domainLen = -1;
        int domainOffset = -1;
        if (msgLen > 20) {
            domainLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[16], msg[17], 0, 0});
        }
        if (msgLen >= 24) {
            domainOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[20], msg[21], msg[22], msg[23]});
        }
        int hostLen = -1;
        int hostOffset = -1;
        if (msgLen > 28) {
            hostLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[24], msg[25], 0, 0});
        }
        if (msgLen >= 32) {
            hostOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[28], msg[29], msg[30], msg[31]});
        }
        this.domain = CheckCredentialSASLNtlm.byteArrayToString(msg, domainLen, domainOffset, false);
        this.host = CheckCredentialSASLNtlm.byteArrayToString(msg, hostLen, hostOffset, false);
    }

    public void setType1Message(String msg) throws Exception {
        this.setType1Message(Base64.decode((String)msg));
    }

    public byte[] getType2Message() throws Exception {
        byte[] msg = new byte[40];
        CheckCredentialSASLNtlm.addBytesToByteArray(msg, ntlmSignature, 0);
        byte[] temp1 = new byte[]{2, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 1, -126, 0, 0};
        CheckCredentialSASLNtlm.addBytesToByteArray(msg, temp1, 8);
        this.serverNonce = ChallengeGenerator.getRealChallenge((int)8);
        CheckCredentialSASLNtlm.addBytesToByteArray(msg, this.serverNonce, 24);
        byte[] temp2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        CheckCredentialSASLNtlm.addBytesToByteArray(msg, temp2, 32);
        return msg;
    }

    public String getType2MessageB64() throws Exception {
        return new String(Base64.encode((byte[])this.getType2Message()));
    }

    public void setType3Message(byte[] msg) throws Exception {
        if (!this.checkMessageSignatur(msg)) {
            throw new Exception("Bad type 3 NTLM message");
        }
        int msgLen = msg.length;
        if (msgLen <= 9 || msg[8] != 3) {
            throw new Exception("Bad type 3 NTLM message");
        }
        int lmRespLen = -1;
        int lmRespOffset = -1;
        if (msgLen <= 14) {
            throw new Exception("Bad type 3 NTLM message");
        }
        lmRespLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[12], msg[13], 0, 0});
        if (msgLen <= 20) {
            throw new Exception("Bad type 3 NTLM message");
        }
        lmRespOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[16], msg[17], msg[18], msg[19]});
        int ntRespLen = -1;
        int ntRespOffset = -1;
        if (msgLen <= 22) {
            throw new Exception("Bad type 3 NTLM message");
        }
        ntRespLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[20], msg[21], 0, 0});
        if (msgLen <= 28) {
            throw new Exception("Bad type 3 NTLM message");
        }
        ntRespOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[24], msg[25], msg[26], msg[27]});
        int domainLen = -1;
        int domainOffset = -1;
        if (msgLen <= 30) {
            throw new Exception("Bad type 3 NTLM message");
        }
        domainLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[28], msg[29], 0, 0});
        if (msgLen <= 36) {
            throw new Exception("Bad type 3 NTLM message");
        }
        domainOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[32], msg[33], msg[34], msg[35]});
        int userLen = -1;
        int userOffset = -1;
        if (msgLen <= 38) {
            throw new Exception("Bad type 3 NTLM message");
        }
        userLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[36], msg[37], 0, 0});
        if (msgLen <= 44) {
            throw new Exception("Bad type 3 NTLM message");
        }
        userOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[40], msg[41], msg[42], msg[43]});
        int hostLen = -1;
        int hostOffset = -1;
        if (msgLen <= 46) {
            throw new Exception("Bad type 3 NTLM message");
        }
        hostLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[44], msg[45], 0, 0});
        if (msgLen <= 52) {
            throw new Exception("Bad type 3 NTLM message");
        }
        hostOffset = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[48], msg[49], msg[50], msg[51]});
        int messageLen = -1;
        if (msgLen >= 60) {
            messageLen = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[56], msg[57], msg[58], msg[59]});
        }
        int flags = -1;
        if (msgLen >= 64) {
            flags = CheckCredentialSASLNtlm.byteArrayToInt(new byte[]{msg[60], msg[61], msg[62], msg[63]});
        }
        this.domain = CheckCredentialSASLNtlm.byteArrayToString(msg, domainLen, domainOffset, true);
        this.user = CheckCredentialSASLNtlm.byteArrayToString(msg, userLen, userOffset, true);
        this.host = CheckCredentialSASLNtlm.byteArrayToString(msg, hostLen, hostOffset, true);
        this.lmResponse = CheckCredentialSASLNtlm.subByteArray(msg, lmRespLen, lmRespOffset);
        this.ntResponse = CheckCredentialSASLNtlm.subByteArray(msg, ntRespLen, ntRespOffset);
    }

    public void setType3Message(String type3MessageB64) throws Exception {
        this.setType3Message(Base64.decode((String)type3MessageB64));
    }

    public String getUserName() {
        return this.user;
    }

    @Override
    public boolean checkCredential(CredentialObject credential, String lmHash, String ntlmHash, String ngosPassword) throws Exception {
        boolean connected = false;
        DesEncryption des = new DesEncryption();
        byte[] lmPassword = des.getDesEncodedPasswordFromBase(lmHash, this.serverNonce);
        NTLMEncryption ntlme = new NTLMEncryption();
        byte[] ntlmPassword = NTLMEncryption.encryptFromHash((String)ntlmHash, (byte[])this.serverNonce);
        if (Arrays.equals(this.lmResponse, lmPassword) || Arrays.equals(this.ntResponse, ntlmPassword)) {
            connected = true;
        }
        if (!connected) {
            byte[] resultHash;
            String domain = this.domain;
            if (domain == null) {
                domain = "";
            }
            if (Arrays.equals(this.lmResponse, resultHash = NTLMEncryption.getCompletePasswordHash((byte[])this.lmResponse, (String)this.user, (String)ntlmHash, (String)domain, (byte[])this.serverNonce, (boolean)false))) {
                connected = true;
            }
            if (!connected) {
                resultHash = NTLMEncryption.getCompletePasswordHash((byte[])this.lmResponse, (String)this.user, (String)ntlmHash, (String)domain, (byte[])this.serverNonce, (boolean)true);
                if (Arrays.equals(this.lmResponse, resultHash)) {
                    connected = true;
                }
            }
        }
        return connected;
    }

    private boolean checkMessageSignatur(byte[] message) {
        boolean valide = false;
        int signatureLen = ntlmSignature.length;
        if (message != null && message.length > signatureLen) {
            for (int i = 0; i < signatureLen; ++i) {
                if (message[i] != ntlmSignature[i]) {
                    valide = false;
                    break;
                }
                valide = true;
            }
        }
        return valide;
    }

    public static byte[] subByteArray(byte[] bytes, int len, int offset) {
        byte[] subBytes = null;
        if (len > 0 && offset > 0) {
            subBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                subBytes[i] = bytes[offset + i];
            }
        }
        return subBytes;
    }

    public static int byteArrayToInt(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(bytes);
        return buffer.getInt(0);
    }

    public static String byteArrayToString(byte[] bytes, int len, int offset, boolean isUnicode) throws Exception {
        String str = null;
        byte[] subBytes = CheckCredentialSASLNtlm.subByteArray(bytes, len, offset);
        if (subBytes != null) {
            str = isUnicode ? new String(subBytes, "UTF-16LE") : new String(subBytes, "US-ASCII");
        }
        return str;
    }

    public static byte[] addBytesToByteArray(byte[] destinationBytes, byte[] sourceBytes, int destinationOffset) {
        int sourceLen = sourceBytes.length;
        if (sourceLen + destinationOffset <= destinationBytes.length) {
            for (int i = 0; i < sourceLen; ++i) {
                destinationBytes[i + destinationOffset] = sourceBytes[i];
            }
        }
        return destinationBytes;
    }
}

