/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;

public class AttributeValueIntegerArray
extends AttributeValueArray {
    public final String AVTABLENAME = "AVINTEGERARRAY";

    public AttributeValueIntegerArray(Integer counter) {
        this.attributeValue = counter;
    }

    public AttributeValueIntegerArray(AttributeValue[] values) {
        int len = values.length;
        Integer[] array = new Integer[len];
        this.attributeValue = len;
        this.attributeObjectArray = array;
        for (int i = 0; i < len; ++i) {
            array[i] = values[i].getObject();
        }
    }

    public AttributeValueIntegerArray(Integer[] value) {
        this.attributeObjectArray = value;
        this.attributeValue = new Integer(this.getArrayLength());
    }

    @Override
    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    public AttributeValueIntegerArray(int[] values) {
        int len;
        this.attributeObjectArray = null;
        Integer[] iArr = null;
        if (values != null && (len = values.length) != 0) {
            iArr = new Integer[len];
            for (int i = 0; i < len; ++i) {
                iArr[i] = new Integer(values[i]);
            }
            this.attributeObjectArray = iArr;
            this.attributeValue = new Integer(values.length);
        }
    }

    private Integer[] getValue() {
        return (Integer[])this.attributeObjectArray;
    }

    @Override
    public String getDataType() {
        return "INTEGER_ARRAY";
    }

    @Override
    public int getDataTypeInt() {
        return 16;
    }

    @Override
    public final String getTableName() throws Exception {
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        return dbi.getAvIntegerArrayTableName();
    }

    @Override
    public final String getValueType() {
        return "INTEGER";
    }

    @Override
    public int getArrayLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        Integer[] bArr = this.getIntegerArrayObject(sessionController);
        if (bArr != null) {
            int len = bArr.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.getXMLArrayStartTag(attributeName));
                sb.append(">");
                sb.append("" + bArr[i]);
                sb.append(this.getXMLArrayEndTag());
            }
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }
}

