/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;

public class AttributeValueBooleanArray
extends AttributeValueArray {
    public static final String AVTABLENAME = "AVBOOLEANARRAY";

    public AttributeValueBooleanArray(Integer counter) {
        this.attributeValue = counter;
    }

    public AttributeValueBooleanArray(AttributeValue[] values) {
        int len = values.length;
        Boolean[] array = new Boolean[len];
        this.attributeValue = len;
        this.attributeObjectArray = array;
        for (int i = 0; i < len; ++i) {
            array[i] = values[i].getObject();
        }
    }

    public AttributeValueBooleanArray(Boolean[] value) {
        this.attributeObjectArray = value;
        this.attributeValue = this.getArrayLength();
    }

    public AttributeValueBooleanArray(boolean[] values) {
        int len;
        this.attributeObjectArray = null;
        Boolean[] bArr = null;
        if (values != null && (len = values.length) != 0) {
            bArr = new Boolean[len];
            for (int i = 0; i < len; ++i) {
                bArr[i] = values[i];
            }
            this.attributeObjectArray = bArr;
            this.attributeValue = values.length;
        }
    }

    private Boolean[] getValue() {
        return (Boolean[])this.attributeObjectArray;
    }

    @Override
    public String getDataType() {
        return "BOOLEAN_ARRAY";
    }

    @Override
    public int getDataTypeInt() {
        return 17;
    }

    @Override
    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    @Override
    public final String getTableName() throws Exception {
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        return dbi.getAvBooleanArrayTableName();
    }

    @Override
    public final String getValueType() {
        return "BOOLEAN";
    }

    @Override
    public int getArrayLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        Boolean[] bArr = this.getBooleanArrayObject(sessionController);
        if (bArr != null) {
            int len = bArr.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.getXMLArrayStartTag(attributeName));
                sb.append(">");
                sb.append(bArr[i]);
                sb.append(this.getXMLArrayEndTag());
            }
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }
}

