/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.AttributeValueBasis;
import agorum.roi.ejb.common.AttributeValueBlob;
import agorum.roi.ejb.common.AttributeValueBoolean;
import agorum.roi.ejb.common.AttributeValueBooleanArray;
import agorum.roi.ejb.common.AttributeValueCIString;
import agorum.roi.ejb.common.AttributeValueDataBaseObjectClientBean;
import agorum.roi.ejb.common.AttributeValueDataBaseObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueDate;
import agorum.roi.ejb.common.AttributeValueDateArray;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBean;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueDouble;
import agorum.roi.ejb.common.AttributeValueDoubleArray;
import agorum.roi.ejb.common.AttributeValueFloat;
import agorum.roi.ejb.common.AttributeValueFloatArray;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueInteger;
import agorum.roi.ejb.common.AttributeValueIntegerArray;
import agorum.roi.ejb.common.AttributeValueInternalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueInternalObjectClientBeanArray;
import agorum.roi.ejb.common.AttributeValueList;
import agorum.roi.ejb.common.AttributeValueLong;
import agorum.roi.ejb.common.AttributeValueLongArray;
import agorum.roi.ejb.common.AttributeValueMap;
import agorum.roi.ejb.common.AttributeValueNull;
import agorum.roi.ejb.common.AttributeValueString;
import agorum.roi.ejb.common.AttributeValueStringArray;
import agorum.roi.ejb.common.AttributeValueText;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AttributeValue {
    protected Object attributeValue = null;
    protected Object attributeObjectArray = null;
    protected Long attributeID = null;
    protected Long objectID = null;
    protected static final String TOSTRING_DATEFORMAT = "yyyyMMddHHmmss z";
    protected static final String DATEXML_FORMAT = "yyyyMMddHHmmssSSS";
    protected static final String DATEXMLDATE_FORMAT = "yyyyMMdd";
    protected static final String DATEXMLTIME_FORMAT = "HHmmss";
    public static final String DOUBLEXML_FORMAT = "000000000000000.0000000000";
    public static final String INTEGERXML_FORMAT = "0000000000";
    public static final char DECIMALXML_SEPARATOR = '.';
    public static final int MAX_INT = Integer.MAX_VALUE;
    public static final int MIN_INT = 0;
    public static final double MAX_DOUBLE = 9.99999999999999E14;
    public static final double MIN_DOUBLE = 0.0;
    private boolean inheritable;
    private Long inheritedFrom = null;
    private boolean inherited;
    protected boolean add;

    public boolean getAdd() {
        return this.add;
    }

    public static final AttributeValue newAttributeValueObject(double value) throws Exception {
        return new AttributeValueDouble(value);
    }

    public static final AttributeValue newAttributeValueObject(int value) throws Exception {
        return new AttributeValueInteger(value);
    }

    public static final AttributeValue newAttributeValueObject(long value) throws Exception {
        return new AttributeValueLong(value);
    }

    public static final AttributeValue newAttributeValueObject(boolean value) throws Exception {
        return new AttributeValueBoolean(value);
    }

    public static final AttributeValue newAttributeValueObject(Boolean value) throws Exception {
        return new AttributeValueBoolean(value);
    }

    public static final AttributeValue newAttributeValueObject(Double value) throws Exception {
        return new AttributeValueDouble(value);
    }

    public static final AttributeValue newAttributeValueObject(Integer value) throws Exception {
        return new AttributeValueInteger(value);
    }

    public static final AttributeValue newAttributeValueObject(Long value) throws Exception {
        return new AttributeValueLong(value);
    }

    public static final AttributeValue newAttributeValueObject(byte[] value) throws Exception {
        return new AttributeValueBlob(value);
    }

    public static final AttributeValue newAttributeValueObject(String value) throws Exception {
        return new AttributeValueString(value);
    }

    public static final AttributeValue newAttributeValueCIObject(String value) throws Exception {
        return new AttributeValueCIString(value);
    }

    public static final AttributeValue newAttributeValueObject(Date value) throws Exception {
        return new AttributeValueDate(value);
    }

    public static final AttributeValue newAttributeValueObject(DirectoryObjectClientBean value) throws Exception {
        return new AttributeValueDirectoryObjectClientBean(value);
    }

    public static final AttributeValue newAttributeValueObject(GlobalObjectClientBean value) throws Exception {
        return new AttributeValueGlobalObjectClientBean(value);
    }

    public static final AttributeValue newAttributeValueObject(DataBaseObjectClientBean value) throws Exception {
        return new AttributeValueDataBaseObjectClientBean(value);
    }

    public static final AttributeValue newAttributeValueObject(InternalObjectClientBean value) throws Exception {
        return new AttributeValueInternalObjectClientBean(value);
    }

    public static final AttributeValue newAttributeValueObject(double[] values) throws Exception {
        return new AttributeValueDoubleArray(values);
    }

    public static final AttributeValue newAttributeValueObject(int[] values) throws Exception {
        return new AttributeValueIntegerArray(values);
    }

    public static final AttributeValue newAttributeValueObject(long[] values) throws Exception {
        return new AttributeValueLongArray(values);
    }

    public static final AttributeValue newAttributeValueObject(boolean[] values) throws Exception {
        return new AttributeValueBooleanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Boolean[] values) throws Exception {
        return new AttributeValueBooleanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Double[] values) throws Exception {
        return new AttributeValueDoubleArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Integer[] values) throws Exception {
        return new AttributeValueIntegerArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Long[] values) throws Exception {
        return new AttributeValueLongArray(values);
    }

    public static final AttributeValue newAttributeValueObject(String[] values) throws Exception {
        return new AttributeValueStringArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Date[] values) throws Exception {
        return new AttributeValueDateArray(values);
    }

    public static final AttributeValue newAttributeValueObject(DirectoryObjectClientBean[] values) throws Exception {
        return new AttributeValueDirectoryObjectClientBeanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(GlobalObjectClientBean[] values) throws Exception {
        return new AttributeValueGlobalObjectClientBeanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(DataBaseObjectClientBean[] values) throws Exception {
        return new AttributeValueDataBaseObjectClientBeanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(InternalObjectClientBean[] values) throws Exception {
        return new AttributeValueInternalObjectClientBeanArray(values);
    }

    public static final AttributeValue newAttributeValueObject(Object object) throws Exception {
        if (object instanceof AttributeValue) {
            return (AttributeValue)object;
        }
        if (object == null) {
            return new AttributeValueNull();
        }
        AttributeValue av = null;
        if (object instanceof Map) {
            HashMap<String, AttributeValue> pairs = new HashMap<String, AttributeValue>();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                AttributeValue subValue = AttributeValue.newAttributeValueObject(entry.getValue());
                if (subValue == null) continue;
                pairs.put(entry.getKey().toString(), subValue);
            }
            if (pairs.size() <= 0) {
                return null;
            }
            av = new AttributeValueMap(pairs);
        } else if (object instanceof Iterable) {
            ArrayList<AttributeValue> items = new ArrayList<AttributeValue>();
            for (Object item : (Iterable)object) {
                AttributeValue subValue = AttributeValue.newAttributeValueObject(item);
                if (subValue == null) continue;
                items.add(subValue);
            }
            if (items.size() <= 0) {
                return null;
            }
            av = new AttributeValueList(items);
        } else if (object instanceof Integer) {
            av = new AttributeValueInteger((Integer)object);
        } else if (object instanceof Long) {
            av = new AttributeValueLong((Long)object);
        } else if (object instanceof byte[]) {
            av = new AttributeValueBlob((byte[])object);
        } else if (object instanceof BigInteger) {
            av = new AttributeValueLong(((BigInteger)object).longValue());
        } else if (object instanceof String) {
            av = new AttributeValueString((String)object);
        } else if (object instanceof Boolean) {
            av = new AttributeValueBoolean((Boolean)object);
        } else if (object instanceof Double) {
            av = new AttributeValueDouble((Double)object);
        } else if (object instanceof Float) {
            av = new AttributeValueDouble(((Float)object).floatValue());
        } else if (object instanceof BigDecimal) {
            av = new AttributeValueDouble(((BigDecimal)object).doubleValue());
        } else if (object instanceof DirectoryObjectClientBean) {
            av = new AttributeValueDirectoryObjectClientBean((DirectoryObjectClientBean)object);
        } else if (object instanceof GlobalObjectClientBean) {
            av = new AttributeValueGlobalObjectClientBean((GlobalObjectClientBean)object);
        } else if (object instanceof DataBaseObjectClientBean) {
            av = new AttributeValueDataBaseObjectClientBean((DataBaseObjectClientBean)object);
        } else if (object instanceof InternalObjectClientBean) {
            av = new AttributeValueInternalObjectClientBean((InternalObjectClientBean)object);
        } else if (object instanceof Date) {
            av = new AttributeValueDate((Date)object);
        } else if (object instanceof boolean[]) {
            av = new AttributeValueBooleanArray((boolean[])object);
        } else if (object instanceof Boolean[]) {
            av = new AttributeValueBooleanArray((Boolean[])object);
        } else if (object instanceof int[]) {
            av = new AttributeValueIntegerArray((int[])object);
        } else if (object instanceof Integer[]) {
            av = new AttributeValueIntegerArray((Integer[])object);
        } else if (object instanceof long[]) {
            av = new AttributeValueLongArray((long[])object);
        } else if (object instanceof Long[]) {
            av = new AttributeValueLongArray((Long[])object);
        } else if (object instanceof double[]) {
            av = new AttributeValueDoubleArray((double[])object);
        } else if (object instanceof Double[]) {
            av = new AttributeValueDoubleArray((Double[])object);
        } else if (object instanceof float[]) {
            av = new AttributeValueFloatArray((float[])object);
        } else if (object instanceof Float[]) {
            av = new AttributeValueFloatArray((Float[])object);
        } else if (object instanceof Date[]) {
            av = new AttributeValueDateArray((Date[])object);
        } else if (object instanceof String[]) {
            av = new AttributeValueStringArray((String[])object);
        } else if (object instanceof DirectoryObjectClientBean[]) {
            av = new AttributeValueDirectoryObjectClientBeanArray((DirectoryObjectClientBean[])object);
        } else if (object instanceof GlobalObjectClientBean[]) {
            av = new AttributeValueGlobalObjectClientBeanArray((GlobalObjectClientBean[])object);
        } else if (object instanceof DataBaseObjectClientBean[]) {
            av = new AttributeValueDataBaseObjectClientBeanArray((DataBaseObjectClientBean[])object);
        } else if (object instanceof InternalObjectClientBean[]) {
            av = new AttributeValueInternalObjectClientBeanArray((InternalObjectClientBean[])object);
        }
        return av;
    }

    public static final AttributeValueArray newAttributeValueObject(SessionController sessionController, String dataType, String format, AttributeValue[] values) throws Exception {
        if (dataType == null) {
            ExceptionUtils.handleException("DataType is not set.", "agorum.roi.remote.exception.NoDataType", 77);
        } else {
            if (dataType.equalsIgnoreCase("STRING_ARRAY")) {
                return new AttributeValueStringArray(values);
            }
            if (dataType.equalsIgnoreCase("BOOLEAN_ARRAY")) {
                return new AttributeValueBooleanArray(values);
            }
            if (dataType.equalsIgnoreCase("INTEGER_ARRAY")) {
                return new AttributeValueIntegerArray(values);
            }
            if (dataType.equalsIgnoreCase("LONG_ARRAY")) {
                return new AttributeValueLongArray(values);
            }
            if (dataType.equalsIgnoreCase("FLOAT_ARRAY")) {
                return new AttributeValueFloatArray(values);
            }
            if (dataType.equalsIgnoreCase("DOUBLE_ARRAY")) {
                return new AttributeValueDoubleArray(values);
            }
            if (dataType.equalsIgnoreCase("DATE_ARRAY")) {
                return new AttributeValueDateArray(values);
            }
            ExceptionUtils.handleException("Unsupported DataType: " + dataType, "agorum.roi.remote.exception.AttributeNotDefined", 74);
        }
        return null;
    }

    public static final AttributeValue newAttributeValueObject(SessionController sessionController, String attrName, String dataType, String format, String value) throws Exception {
        AttributeValueBasis av = null;
        if (dataType == null) {
            ExceptionUtils.handleException("DataType is not set.", "agorum.roi.remote.exception.NoDataType", 77);
        } else if (dataType.equalsIgnoreCase("INTEGER")) {
            av = new AttributeValueInteger(Integer.valueOf(value));
        } else if (dataType.equalsIgnoreCase("LONG")) {
            av = new AttributeValueLong(Long.valueOf(value));
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            av = new AttributeValueBlob(value.getBytes("UTF-8"));
        } else if (dataType.equalsIgnoreCase("STRING")) {
            av = new AttributeValueString(value);
        } else if (dataType.equalsIgnoreCase("TEXT")) {
            av = new AttributeValueText(value);
        } else if (dataType.equalsIgnoreCase("CISTRING")) {
            av = new AttributeValueCIString(value);
        } else if (dataType.equalsIgnoreCase("BOOLEAN")) {
            av = new AttributeValueBoolean(Boolean.valueOf(value));
        } else if (dataType.equalsIgnoreCase("FLOAT")) {
            av = new AttributeValueFloat(Float.valueOf(value));
        } else if (dataType.equalsIgnoreCase("DOUBLE")) {
            av = new AttributeValueDouble(Double.valueOf(value));
        } else if (dataType.equalsIgnoreCase("DATE")) {
            av = new AttributeValueDate(AttributeValueDate.convertStringToDate(value, format));
        } else if (dataType.equalsIgnoreCase("DIRECTORYOBJECT")) {
            DirectoryObjectClientBean convertedValue = (DirectoryObjectClientBean)sessionController.getGlobalObjectById(Long.valueOf(value));
            av = new AttributeValueDirectoryObjectClientBean(convertedValue);
        } else if (dataType.equalsIgnoreCase("GLOBALOBJECT")) {
            GlobalObjectClientBean convertedValue = sessionController.getGlobalObjectById(Long.valueOf(value));
            av = new AttributeValueGlobalObjectClientBean(convertedValue);
        } else if (dataType.equalsIgnoreCase("DATABASEOBJECT")) {
            DataBaseObjectClientBean convertedValue = sessionController.getDataBaseObjectById(Long.valueOf(value));
            av = new AttributeValueDataBaseObjectClientBean(convertedValue);
        } else if (dataType.equalsIgnoreCase("INTERNALOBJECT")) {
            InternalObjectClientBean convertedValue = sessionController.getInternalObjectById(Long.valueOf(value));
            av = new AttributeValueInternalObjectClientBean(convertedValue);
        } else {
            ExceptionUtils.handleException("Unsupported DataType: " + dataType, "agorum.roi.remote.exception.AttributeNotDefined", 74);
        }
        return av;
    }

    public String getString() {
        return (String)this.attributeValue;
    }

    public void setString(String s) {
        this.attributeValue = s;
    }

    public boolean getBoolean() {
        return (Boolean)this.attributeValue;
    }

    public double getFloat() {
        return ((Float)this.attributeValue).floatValue();
    }

    public double getDouble() {
        return (Double)this.attributeValue;
    }

    public long getLong() {
        return (Long)this.attributeValue;
    }

    public byte[] getBlob() {
        return (byte[])this.attributeValue;
    }

    public int getInteger() {
        return (Integer)this.attributeValue;
    }

    public Date getDate() {
        return (Date)this.attributeValue;
    }

    public Boolean[] getBooleanArrayObject(SessionController sessionController) throws Exception {
        Boolean[] bArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Boolean[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                bArr = (Boolean[])this.attributeObjectArray;
            }
        } else {
            bArr = (Boolean[])this.attributeObjectArray;
        }
        return bArr;
    }

    public boolean[] getBooleanArray(SessionController sessionController) throws Exception {
        boolean[] bArr = null;
        Boolean[] BArr = this.getBooleanArrayObject(sessionController);
        if (BArr != null) {
            int len = BArr.length;
            bArr = new boolean[len];
            for (int i = 0; i < len; ++i) {
                bArr[i] = BArr[i];
            }
        }
        return bArr;
    }

    public Integer[] getIntegerArrayObject(SessionController sessionController) throws Exception {
        Integer[] iArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Integer[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                iArr = (Integer[])this.attributeObjectArray;
            }
        } else {
            iArr = (Integer[])this.attributeObjectArray;
        }
        return iArr;
    }

    public int[] getIntegerArray(SessionController sessionController) throws Exception {
        int[] iArr = null;
        Integer[] IArr = this.getIntegerArrayObject(sessionController);
        if (IArr != null) {
            int len = IArr.length;
            iArr = new int[len];
            for (int i = 0; i < len; ++i) {
                iArr[i] = IArr[i];
            }
        }
        return iArr;
    }

    public Long[] getLongArrayObject(SessionController sessionController) throws Exception {
        Long[] lArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Long[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                lArr = (Long[])this.attributeObjectArray;
            }
        } else {
            lArr = (Long[])this.attributeObjectArray;
        }
        return lArr;
    }

    public long[] getLongArray(SessionController sessionController) throws Exception {
        long[] lArr = null;
        Long[] LArr = this.getLongArrayObject(sessionController);
        if (LArr != null) {
            int len = LArr.length;
            lArr = new long[len];
            for (int i = 0; i < len; ++i) {
                lArr[i] = LArr[i];
            }
        }
        return lArr;
    }

    public Double[] getDoubleArrayObject(SessionController sessionController) throws Exception {
        Double[] dArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Double[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                dArr = (Double[])this.attributeObjectArray;
            }
        } else {
            dArr = (Double[])this.attributeObjectArray;
        }
        return dArr;
    }

    public Float[] getFloatArrayObject(SessionController sessionController) throws Exception {
        Float[] dArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Float[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                dArr = (Float[])this.attributeObjectArray;
            }
        } else {
            dArr = (Float[])this.attributeObjectArray;
        }
        return dArr;
    }

    public double[] getDoubleArray(SessionController sessionController) throws Exception {
        double[] dArr = null;
        Double[] DArr = this.getDoubleArrayObject(sessionController);
        if (DArr != null) {
            int len = DArr.length;
            dArr = new double[len];
            for (int i = 0; i < len; ++i) {
                dArr[i] = DArr[i];
            }
        }
        return dArr;
    }

    public Date[] getDateArrayObject(SessionController sessionController) throws Exception {
        Date[] dArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Date[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                dArr = (Date[])this.attributeObjectArray;
            }
        } else {
            dArr = (Date[])this.attributeObjectArray;
        }
        return dArr;
    }

    public String[] getStringArrayObject(SessionController sessionController) throws Exception {
        String[] sArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (String[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                sArr = (String[])this.attributeObjectArray;
                if (sArr != null) {
                    for (int i = 0; i < sArr.length; ++i) {
                        sArr[i] = sArr[i] == null ? "" : sArr[i];
                    }
                }
                this.attributeObjectArray = sArr;
            }
        } else {
            sArr = (String[])this.attributeObjectArray;
        }
        return sArr;
    }

    public Object[] getObjectArrayObject(SessionController sessionController) throws Exception {
        Object[] sArr = null;
        if (this.attributeObjectArray == null) {
            if (this.attributeValue != null && (Integer)this.attributeValue > 0) {
                this.attributeObjectArray = (Object[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
                this.attributeObjectArray = sArr = (Object[])this.attributeObjectArray;
            }
        } else {
            sArr = (Object[])this.attributeObjectArray;
        }
        return sArr;
    }

    public GlobalObjectClientBean[] getGlobalObjectClientBeanArray(SessionController sessionController) throws Exception {
        Long[] lArr;
        int len;
        GlobalObjectClientBean[] oArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.attributeObjectArray = (Long[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
        }
        if (this.attributeObjectArray != null && (len = (lArr = (Long[])this.attributeObjectArray).length) > 0) {
            oArr = new GlobalObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                oArr[i] = sessionController.getGlobalObjectById(lArr[i]);
            }
        }
        return oArr;
    }

    public Long[] getGlobalObjectClientBeanIDArray(SessionController sessionController) throws Exception {
        Long[] lArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.getGlobalObjectClientBeanArray(sessionController);
        }
        if (this.attributeObjectArray != null) {
            lArr = (Long[])this.attributeObjectArray;
        }
        return lArr;
    }

    public DataBaseObjectClientBean[] getDataBaseObjectClientBeanArray(SessionController sessionController) throws Exception {
        Long[] lArr;
        int len;
        DataBaseObjectClientBean[] oArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.attributeObjectArray = (Long[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
        }
        if (this.attributeObjectArray != null && (len = (lArr = (Long[])this.attributeObjectArray).length) > 0) {
            oArr = new DataBaseObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                oArr[i] = sessionController.getDataBaseObjectById(lArr[i]);
            }
        }
        return oArr;
    }

    public Long[] getDataBaseObjectClientBeanIDArray(SessionController sessionController) throws Exception {
        Long[] lArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.getDataBaseObjectClientBeanArray(sessionController);
        }
        if (this.attributeObjectArray != null) {
            lArr = (Long[])this.attributeObjectArray;
        }
        return lArr;
    }

    public InternalObjectClientBean[] getInternalObjectClientBeanArray(SessionController sessionController) throws Exception {
        Long[] lArr;
        int len;
        InternalObjectClientBean[] oArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.attributeObjectArray = (Long[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
        }
        if (this.attributeObjectArray != null && (len = (lArr = (Long[])this.attributeObjectArray).length) > 0) {
            oArr = new InternalObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                oArr[i] = sessionController.getInternalObjectById(lArr[i]);
            }
        }
        return oArr;
    }

    public Long[] getInternalObjectClientBeanIDArray(SessionController sessionController) throws Exception {
        Long[] lArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.getInternalObjectClientBeanArray(sessionController);
        }
        if (this.attributeObjectArray != null) {
            lArr = (Long[])this.attributeObjectArray;
        }
        return lArr;
    }

    public DirectoryObjectClientBean[] getDirectoryObjectClientBeanArray(SessionController sessionController) throws Exception {
        Long[] lArr;
        int len;
        DirectoryObjectClientBean[] oArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.attributeObjectArray = (Long[])sessionController.getSystemSessionRemote().getAttributeArray(sessionController, ((AttributeValueArray)this).getTableName(), ((AttributeValueArray)this).getDataType(), ((AttributeValueArray)this).getValueType(), ((AttributeValueArray)this).getObjectId(), ((AttributeValueArray)this).getAttributeId());
        }
        if (this.attributeObjectArray != null && (len = (lArr = (Long[])this.attributeObjectArray).length) > 0) {
            oArr = new DirectoryObjectClientBean[len];
            for (int i = 0; i < len; ++i) {
                oArr[i] = (DirectoryObjectClientBean)sessionController.getGlobalObjectById(lArr[i]);
            }
        }
        return oArr;
    }

    public Long[] getDirectoryObjectClientBeanIDArray(SessionController sessionController) throws Exception {
        Long[] lArr = null;
        if (this.attributeObjectArray == null && this.attributeValue != null && (Integer)this.attributeValue > 0) {
            this.getDirectoryObjectClientBeanArray(sessionController);
        }
        if (this.attributeObjectArray != null) {
            lArr = (Long[])this.attributeObjectArray;
        }
        return lArr;
    }

    public GlobalObjectClientBean getGlobalObjectClientBean(SessionController sessionController) throws Exception {
        GlobalObjectClientBean gocb = null;
        Long l = (Long)this.attributeValue;
        if (l != null && l > 0L) {
            gocb = sessionController.getGlobalObjectById((Long)this.attributeValue);
        }
        return gocb;
    }

    public DirectoryObjectClientBean getDirectoryObjectClientBean(SessionController sessionController) throws Exception {
        DirectoryObjectClientBean gocb = null;
        Long l = (Long)this.attributeValue;
        if (l != null && l > 0L) {
            gocb = (DirectoryObjectClientBean)sessionController.getGlobalObjectById((Long)this.attributeValue);
        }
        return gocb;
    }

    public InternalObjectClientBean getInternalObjectClientBean(SessionController sessionController) throws Exception {
        InternalObjectClientBean iocb = null;
        Long l = (Long)this.attributeValue;
        if (l != null && l > 0L) {
            iocb = sessionController.getInternalObjectById((Long)this.attributeValue);
        }
        return iocb;
    }

    public DataBaseObjectClientBean getDataBaseObjectClientBean(SessionController sessionController) throws Exception {
        DataBaseObjectClientBean docb = null;
        Long l = (Long)this.attributeValue;
        if (l != null && l > 0L) {
            docb = sessionController.getDataBaseObjectById((Long)this.attributeValue);
        }
        return docb;
    }

    public String getDataType() {
        return "UNKNOWN";
    }

    public int getDataTypeInt() {
        return 0;
    }

    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    public Object getObject() {
        return this.attributeValue == null ? this.attributeObjectArray : this.attributeValue;
    }

    public long getDateToDB() {
        Date d = this.getDate();
        return this.getDateToDB(d);
    }

    public long getDateToDB(Date d) {
        long dbdate = d.getTime();
        return dbdate;
    }

    public long getDateArrayObjectToDB(SessionController sessionController, int pos) throws Exception {
        Date[] dArr = this.getDateArrayObject(sessionController);
        return this.getDateToDB(dArr[pos]);
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        return "";
    }

    protected String setXMLStartTag(String attributeName) {
        String s = "<" + attributeName;
        if (this.inheritedFrom != null) {
            s = s + " Inherited=\"" + this.isInherited() + "\" InheritedFrom=\"" + this.getInheritedFrom() + "\" Inheritable=\"" + this.isInheritable() + "\"";
        }
        s = s + " DataType=\"" + this.getDataType() + "\" ";
        return s;
    }

    protected String setXMLEndTag(String attributeName) {
        return "</" + attributeName + ">";
    }

    protected String setXMLDateFormat() {
        return this.setXMLDateFormat(DATEXML_FORMAT);
    }

    protected String setXMLDateFormat(String format) {
        return " Format=\"" + format + "\" ";
    }

    protected String setXMLIntegerFormat() {
        return this.setXMLIntegerFormat(INTEGERXML_FORMAT);
    }

    protected String setXMLIntegerFormat(String format) {
        return " Format=\"" + format + "\" ";
    }

    protected String setXMLDoubleFormat() {
        return this.setXMLDoubleFormat(DOUBLEXML_FORMAT, '.');
    }

    protected String setXMLDoubleFormat(String format, char decimalSeparator) {
        return " Format=\"" + format + "\" DecimalSeparator=\"" + decimalSeparator + "\" ";
    }

    public String setDateValue(String format, Date d) {
        return " DateValueFormat=\"" + format + "\" DateValue=\"" + AttributeValueDate.convertDateToString(d, format) + "\" ";
    }

    protected String setTimeValue(String format, Date d) {
        return " TimeValueFormat=\"" + format + "\" TimeValue=\"" + AttributeValueDate.convertDateToString(d, format) + "\" ";
    }

    public static String setDoubleValue(String format, char decimalSeparator, double d) {
        DecimalFormat decFormat = new DecimalFormat(format);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(decimalSeparator);
        decFormat.setDecimalFormatSymbols(dfs);
        return decFormat.format(d);
    }

    public static String setIntegerValue(String format, int i) {
        DecimalFormat decFormat = new DecimalFormat(format);
        return decFormat.format(i);
    }

    public boolean equals(Object other) {
        if (other instanceof AttributeValue) {
            AttributeValue o = (AttributeValue)other;
            return this.attributeValue == o.attributeValue || this.attributeValue != null && this.attributeValue.equals(o.attributeValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.attributeValue != null) {
            return this.attributeValue.hashCode();
        }
        if (this.attributeObjectArray != null) {
            return this.attributeObjectArray.hashCode();
        }
        return 0;
    }

    public boolean equals(SessionController sessionController, AttributeValue av) throws Exception {
        return this.equals(sessionController, av, false);
    }

    public boolean equalsIgnoreCase(SessionController sessionController, AttributeValue av) throws Exception {
        return this.equals(sessionController, av, true);
    }

    private boolean checkDataType(AttributeValue av1, AttributeValue av2) {
        boolean b = false;
        if (av1.getDataTypeEquals() == av2.getDataTypeEquals()) {
            b = true;
        }
        return b;
    }

    public Object[] getAttributeValueArray(SessionController sessionController) throws Exception {
        switch (this.getDataTypeEquals()) {
            case 13: {
                return this.getDateArrayObject(sessionController);
            }
            case 14: {
                return this.getStringArrayObject(sessionController);
            }
            case 15: {
                return this.getDoubleArrayObject(sessionController);
            }
            case 16: {
                return this.getIntegerArrayObject(sessionController);
            }
            case 17: {
                return this.getBooleanArrayObject(sessionController);
            }
            case 18: {
                return this.getDirectoryObjectClientBeanIDArray(sessionController);
            }
            case 19: {
                long[] arr = this.getLongArray(sessionController);
                if (arr != null) {
                    return ArrayUtils.toObject((long[])arr);
                }
                return null;
            }
            case 20: {
                return this.getDataBaseObjectClientBeanIDArray(sessionController);
            }
            case 21: {
                return this.getInternalObjectClientBeanIDArray(sessionController);
            }
            case 22: {
                return this.getGlobalObjectClientBeanIDArray(sessionController);
            }
        }
        System.err.println("No getObjectArray defined for DataType : " + this.getDataTypeEquals() + " (" + this.getDataType() + ")");
        return null;
    }

    public boolean equals(SessionController sessionController, AttributeValue av, boolean ignoreCase) throws Exception {
        boolean isEquals = false;
        if (this.checkDataType(this, av)) {
            try {
                Object oThis = this.getAttributeValue();
                Object oAv = av.getAttributeValue();
                if (oThis == null && oAv == null) {
                    isEquals = true;
                } else if (oThis != null && oAv != null) {
                    switch (this.getDataTypeEquals()) {
                        case 1: {
                            Date dThis = this.getDate();
                            Date dAv = av.getDate();
                            isEquals = this.equalsObject(dThis, dAv, ignoreCase);
                            break;
                        }
                        case 2: {
                            String sThis = this.getString();
                            String sAv = av.getString();
                            isEquals = this.equalsObject(sThis, sAv, ignoreCase);
                            break;
                        }
                        case 3: {
                            String sThis = this.getString();
                            String sAv = av.getString();
                            isEquals = this.equalsObject(sThis, sAv, ignoreCase);
                            break;
                        }
                        case 23: {
                            String sThis = this.getString();
                            String sAv = av.getString();
                            isEquals = this.equalsObject(sThis, sAv, true);
                            break;
                        }
                        case 4: {
                            double dThis = this.getDouble();
                            double dAv = av.getDouble();
                            isEquals = this.equalsObject(dThis, dAv, ignoreCase);
                            break;
                        }
                        case 5: {
                            int iThis = this.getInteger();
                            int iAv = av.getInteger();
                            isEquals = this.equalsObject(iThis, iAv, ignoreCase);
                            break;
                        }
                        case 6: {
                            boolean bThis = this.getBoolean();
                            boolean bAv = av.getBoolean();
                            isEquals = this.equalsObject(bThis, bAv, ignoreCase);
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            Long lThis = (Long)this.getAttributeValue();
                            Long lAv = (Long)av.getAttributeValue();
                            isEquals = this.equalsObject(lThis, lAv, ignoreCase);
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 13: {
                            Object[] oArrThis = this.getDateArrayObject(sessionController);
                            Object[] oArrAv = av.getDateArrayObject(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 14: {
                            Object[] oArrThis = this.getStringArrayObject(sessionController);
                            Object[] oArrAv = av.getStringArrayObject(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 15: {
                            Object[] oArrThis = this.getDoubleArrayObject(sessionController);
                            Object[] oArrAv = av.getDoubleArrayObject(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 16: {
                            Object[] oArrThis = this.getIntegerArrayObject(sessionController);
                            Object[] oArrAv = av.getIntegerArrayObject(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 17: {
                            Object[] oArrThis = this.getBooleanArrayObject(sessionController);
                            Object[] oArrAv = av.getBooleanArrayObject(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 18: {
                            Object[] oArrThis = this.getDirectoryObjectClientBeanIDArray(sessionController);
                            Object[] oArrAv = av.getDirectoryObjectClientBeanIDArray(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 19: {
                            long[] oArrThis = this.getLongArray(sessionController);
                            long[] oArrAv = av.getLongArray(sessionController);
                            isEquals = this.equalsObjectArray(this.longToLongArray(oArrThis), this.longToLongArray(oArrAv), ignoreCase);
                            break;
                        }
                        case 20: {
                            Object[] oArrThis = this.getDataBaseObjectClientBeanIDArray(sessionController);
                            Object[] oArrAv = av.getDataBaseObjectClientBeanIDArray(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 21: {
                            Object[] oArrThis = this.getInternalObjectClientBeanIDArray(sessionController);
                            Object[] oArrAv = av.getInternalObjectClientBeanIDArray(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        case 22: {
                            Object[] oArrThis = this.getGlobalObjectClientBeanIDArray(sessionController);
                            Object[] oArrAv = av.getGlobalObjectClientBeanIDArray(sessionController);
                            isEquals = this.equalsObjectArray(oArrThis, oArrAv, ignoreCase);
                            break;
                        }
                        default: {
                            System.err.println("No equals define for DataType : " + this.getDataTypeEquals() + " (" + this.getDataType() + ")");
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isEquals;
    }

    private Long[] longToLongArray(long[] lA) throws Exception {
        Long[] lArr = null;
        if (lA != null) {
            int len = lA.length;
            lArr = new Long[len];
            for (int i = 0; i < len; ++i) {
                Long l;
                lArr[i] = l = new Long(lA[i]);
            }
        }
        return lArr;
    }

    private boolean equalsObject(Date o1, Date o2, boolean ignoreCase) throws Exception {
        return o1.getTime() == o2.getTime();
    }

    private boolean equalsObject(Long o1, Long o2, boolean ignoreCase) throws Exception {
        return this.equalsObject((long)o1, (long)o2, ignoreCase);
    }

    private boolean equalsObject(long o1, long o2, boolean ignoreCase) throws Exception {
        return o1 == o2;
    }

    private boolean equalsObject(int o1, int o2, boolean ignoreCase) throws Exception {
        return o1 == o2;
    }

    private boolean equalsObject(Integer o1, Integer o2, boolean ignoreCase) throws Exception {
        return this.equalsObject((int)o1, (int)o2, ignoreCase);
    }

    private boolean equalsObject(String o1, String o2, boolean ignoreCase) throws Exception {
        if (ignoreCase) {
            return o1.equalsIgnoreCase(o2);
        }
        return o1.equals(o2);
    }

    private boolean equalsObject(Boolean o1, Boolean o2, boolean ignoreCase) throws Exception {
        return this.equalsObject((boolean)o1, (boolean)o2, ignoreCase);
    }

    private boolean equalsObject(boolean o1, boolean o2, boolean ignoreCase) throws Exception {
        return o1 == o2;
    }

    private boolean equalsObject(Double o1, Double o2, boolean ignoreCase) throws Exception {
        return this.equalsObject((double)o1, (double)o2, ignoreCase);
    }

    private boolean equalsObject(double o1, double o2, boolean ignoreCase) throws Exception {
        return o1 == o2;
    }

    private boolean equalsObject(Object o1, Object o2, boolean ignoreCase) throws Exception {
        if (o1 != null && o2 != null) {
            if (o1 instanceof Date && o2 instanceof Date) {
                return this.equalsObject((Date)o1, (Date)o2, ignoreCase);
            }
            if (o1 instanceof String && o2 instanceof String) {
                return this.equalsObject((String)o1, (String)o2, ignoreCase);
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return this.equalsObject((Integer)o1, (Integer)o2, ignoreCase);
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return this.equalsObject((Double)o1, (Double)o2, ignoreCase);
            }
            if (o1 instanceof Long && o2 instanceof Long) {
                return this.equalsObject((Long)o1, (Long)o2, ignoreCase);
            }
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                return this.equalsObject((Boolean)o1, (Boolean)o2, ignoreCase);
            }
            return false;
        }
        return false;
    }

    private boolean equalsObjectArray(Object[] o1, Object[] o2, boolean ignoreCase) throws Exception {
        int len2;
        int len1;
        boolean b = false;
        if (o1 != null && o2 != null && (len1 = o1.length) == (len2 = o2.length)) {
            b = true;
            for (int i = 0; i < len1 && b; ++i) {
                b = this.equalsObject(o1[i], o2[i], ignoreCase);
            }
        }
        return b;
    }

    public String toString(SessionController sessionController) {
        StringBuffer sb = new StringBuffer();
        try {
            String dataType = this.getDataType();
            if (dataType.equalsIgnoreCase("DATE")) {
                Date d = this.getDate();
                if (d != null) {
                    this.fillStringToBuffer(AttributeValueDate.convertDateToString(d, TOSTRING_DATEFORMAT), sb);
                }
            } else if (dataType.equalsIgnoreCase("LONGTEXT")) {
                String s = this.getString();
                if (s != null) {
                    this.fillStringToBuffer(s, sb);
                }
            } else if (dataType.equalsIgnoreCase("STRING") || dataType.equalsIgnoreCase("CISTRING") || dataType.equalsIgnoreCase("TEXT")) {
                String s = this.getString();
                if (s != null) {
                    this.fillStringToBuffer(s, sb);
                }
            } else if (dataType.equalsIgnoreCase("DOUBLE")) {
                double d = this.getDouble();
                this.fillStringToBuffer("" + d, sb);
            } else if (dataType.equalsIgnoreCase("INTEGER")) {
                int i = this.getInteger();
                this.fillStringToBuffer("" + i, sb);
            } else if (dataType.equalsIgnoreCase("BOOLEAN")) {
                boolean o = this.getBoolean();
                this.fillStringToBuffer(o ? "true" : "false", sb);
            } else if (dataType.equalsIgnoreCase("DIRECTORYOBJECT")) {
                this.fillStringToBuffer("" + this.attributeValue, sb);
            } else if (dataType.equalsIgnoreCase("LONG")) {
                long o = this.getLong();
                this.fillStringToBuffer("" + o, sb);
            } else if (!dataType.equalsIgnoreCase("BLOB")) {
                if (dataType.equalsIgnoreCase("DATABASEOBJECT")) {
                    this.fillStringToBuffer("" + this.attributeValue, sb);
                } else if (dataType.equalsIgnoreCase("INTERNALOBJECT")) {
                    this.fillStringToBuffer("" + this.attributeValue, sb);
                } else if (dataType.equalsIgnoreCase("GLOBALOBJECT")) {
                    this.fillStringToBuffer("" + this.attributeValue, sb);
                } else if (!dataType.equalsIgnoreCase("OBJECTREFERENCE")) {
                    if (dataType.equalsIgnoreCase("DATE_ARRAY")) {
                        Date[] o = this.getDateArrayObject(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : AttributeValueDate.convertDateToString(o[i], TOSTRING_DATEFORMAT), sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("STRING_ARRAY")) {
                        String[] o = this.getStringArrayObject(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("DOUBLE_ARRAY")) {
                        Double[] o = this.getDoubleArrayObject(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("INTEGER_ARRAY")) {
                        Integer[] o = this.getIntegerArrayObject(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("BOOLEAN_ARRAY")) {
                        Boolean[] o = this.getBooleanArrayObject(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : (o[i] == true ? "true" : "false"), sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("DIRECTORYOBJECT_ARRAY")) {
                        Long[] o = this.getDirectoryObjectClientBeanIDArray(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("LONG_ARRAY")) {
                        long[] o = this.getLongArray(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer("" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("DATABASEOBJECT_ARRAY")) {
                        Long[] o = this.getDataBaseObjectClientBeanIDArray(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("INTERNALOBJECT_ARRAY")) {
                        Long[] o = this.getInternalObjectClientBeanIDArray(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else if (dataType.equalsIgnoreCase("GLOBALOBJECT_ARRAY")) {
                        Long[] o = this.getGlobalObjectClientBeanIDArray(sessionController);
                        if (o != null) {
                            int len = o.length;
                            for (int i = 0; i < len; ++i) {
                                this.fillStringToBuffer(o[i] == null ? "" : "" + o[i], sb);
                            }
                        }
                    } else {
                        System.err.println("No toString define for DataType : " + dataType);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private void fillStringToBuffer(String s, StringBuffer buffer) {
        if (s != null) {
            s = s.replace("\"", "\\\"");
        }
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append("\"");
        buffer.append(s == null ? "" : s);
        buffer.append("\"");
    }

    public Long getInheritedFrom() {
        return this.inheritedFrom;
    }

    public void setInheritedFrom(Long inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public Object unwrap() {
        return this.getObject();
    }

    @Deprecated
    public void setAttributeValueDirect(Object value) {
        this.attributeValue = value;
    }
}

