/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.common.AclCacheInvalidator;
import java.util.HashMap;
import java.util.Map;

public class AclUserResolverCache {
    private final Map<Long, Map<Long, Long>> aclCache = new HashMap<Long, Map<Long, Long>>();
    private final Map<Long, Map<Long, Long[]>> memberCache = new HashMap<Long, Map<Long, Long[]>>();
    private static final AclUserResolverCache resolverCache = new AclUserResolverCache();

    private AclUserResolverCache() {
    }

    public static AclUserResolverCache getInstance() {
        return resolverCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getResolvedAccessLevel(Long aclId, Long userGroupId) {
        Map<Long, Map<Long, Long>> map = this.aclCache;
        synchronized (map) {
            Long levelLong;
            Map<Long, Long> userGroupHash = this.aclCache.get(aclId);
            if (userGroupHash != null && (levelLong = userGroupHash.get(userGroupId)) != null) {
                return levelLong;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeResolvedAccessLevel(Long aclId, Long userGroupId, long accessLevel) {
        Map<Long, Map<Long, Long>> map = this.aclCache;
        synchronized (map) {
            this.aclCache.computeIfAbsent(aclId, k -> new HashMap()).put(userGroupId, accessLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getMembers(Long aclId, Long userGroupId) {
        Map<Long, Map<Long, Long[]>> map = this.memberCache;
        synchronized (map) {
            Map<Long, Long[]> userGroupHash = this.memberCache.get(aclId);
            if (userGroupHash != null) {
                return userGroupHash.get(userGroupId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(Long aclId, Long userGroupId, Long[] members) {
        Map<Long, Map<Long, Long[]>> map = this.memberCache;
        synchronized (map) {
            this.memberCache.computeIfAbsent(aclId, k -> new HashMap()).put(userGroupId, members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcl(AccessControlListObjectClientBean acl) throws Exception {
        Long objectId = acl.getId();
        Map<Long, Map<Long, Object>> map = this.memberCache;
        synchronized (map) {
            this.memberCache.remove(objectId);
        }
        map = this.aclCache;
        synchronized (map) {
            this.aclCache.remove(objectId);
        }
    }

    static {
        new AclCacheInvalidator();
    }
}

