/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.beans.GlobalObjectEJB;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBean;
import agorum.roi.ejb.client.beans.PermissionBundleObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.AclUserResolverCache;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AclUserResolver
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private static final Map<Long, Map<Long, Object>> syncAcl = new HashMap<Long, Map<Long, Object>>();
    private final Map<Long, Map<Long, Long>> aclHash = new HashMap<Long, Map<Long, Long>>();
    private final Map<Long, Set<Long>> aclRevokeHash = new HashMap<Long, Set<Long>>();
    private final SessionController sessionController;
    private List<Long> allAdminUsers;

    public AclUserResolver(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    private static synchronized Object getSyncObject(Long aclId, Long ugId) {
        Map aclEntry = syncAcl.computeIfAbsent(aclId, k -> new HashMap());
        return ugId == null ? aclEntry : aclEntry.computeIfAbsent(ugId, k -> new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAcl(AccessControlListObjectClientBean acl) throws Exception {
        Object object = AclUserResolver.getSyncObject(acl.getId(), null);
        synchronized (object) {
            SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(acl.getSessionController(), "UserAdminTmpMode");
            acl = (AccessControlListObjectClientBean)scAdmin.getGlobalObjectById(acl.getId());
            long t1 = System.currentTimeMillis();
            AclUserResolverCache.getInstance().removeAcl(acl);
            this.getUserHash(acl.getId()).putIfAbsent(0L, 0xFFFFFFL);
            AccessControlEntryObjectClientBean[] aces = acl.getAccessControlEntries();
            if (aces != null) {
                for (AccessControlEntryObjectClientBean ace : aces) {
                    DirectoryObjectClientBean member = null;
                    try {
                        member = ace.getGrantee();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (member == null) continue;
                    boolean isGranted = ace.getGranted();
                    long accessLevel = AclUserResolver.combineAccessLevels(ace.getPermissionBundleObjects());
                    if (member instanceof DirectoryGroupObjectClientBean && !scAdmin.isWorldGroup(member)) {
                        this.resolveAclGroup(acl, (DirectoryGroupObjectClientBean)member, isGranted, accessLevel);
                        continue;
                    }
                    this.resolveAclUser(acl, member.getId(), isGranted, accessLevel);
                }
            } else {
                this.aclHash.put(acl.getId(), new HashMap());
            }
            System.err.println("resolveAcl 1 time : " + (System.currentTimeMillis() - t1) + ", Acl : " + acl.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long resolveAcl(Long aclId, Long ugId) throws Exception {
        AclUserResolverCache cache = AclUserResolverCache.getInstance();
        long accessLevel = cache.getResolvedAccessLevel(aclId, ugId);
        if (accessLevel >= 0L) {
            return accessLevel;
        }
        Object object = AclUserResolver.getSyncObject(aclId, ugId);
        synchronized (object) {
            accessLevel = cache.getResolvedAccessLevel(aclId, ugId);
            if (accessLevel < 0L) {
                SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin("UserAdminTmpMode");
                DirectoryObjectClientBean directoryObject = (DirectoryObjectClientBean)scAdmin.getGlobalObjectById(ugId);
                AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)scAdmin.getGlobalObjectById(aclId);
                accessLevel = 0L;
                AccessControlEntryObjectClientBean[] aces = acl.getAccessControlEntries();
                if (aces != null) {
                    for (AccessControlEntryObjectClientBean ace : aces) {
                        Object object2;
                        DirectoryObjectClientBean memberObject = null;
                        try {
                            memberObject = ace.getGrantee();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (memberObject == null) continue;
                        long member = memberObject.getId();
                        boolean isGranted = ace.getGranted();
                        PermissionBundleObjectClientBean[] pb = ace.getPermissionBundleObjects();
                        long tmpAccessLevel = AclUserResolver.combineAccessLevels(pb);
                        accessLevel = AclUserResolver.mergeLevels(scAdmin, isGranted, member, directoryObject, accessLevel, tmpAccessLevel);
                        if (!(memberObject instanceof DirectoryGroupObjectClientBean)) continue;
                        Long[] subMembers = cache.getMembers(aclId, member);
                        if (subMembers == null) {
                            object2 = AclUserResolver.getSyncObject(aclId, -1L);
                            synchronized (object2) {
                                subMembers = cache.getMembers(aclId, member);
                                if (subMembers == null) {
                                    DirectoryObjectClientBean[] subMemberObjects = ((DirectoryGroupObjectClientBean)memberObject).getAllMembers();
                                    subMembers = subMemberObjects == null ? new Long[]{} : (Long[])Arrays.stream(subMemberObjects).map(SuperObjectClientBean::getId).toArray(Long[]::new);
                                    cache.setMembers(aclId, member, subMembers);
                                }
                            }
                        }
                        object2 = subMembers;
                        int n = ((Long[])object2).length;
                        for (int i = 0; i < n; ++i) {
                            long subMember = object2[i];
                            accessLevel = AclUserResolver.mergeLevels(scAdmin, isGranted, subMember, directoryObject, accessLevel, tmpAccessLevel);
                        }
                    }
                }
                AclUserResolverCache.getInstance().storeResolvedAccessLevel(aclId, ugId, accessLevel);
            }
        }
        return accessLevel;
    }

    public static long resolveAcl(DirectoryObjectClientBean directoryObject, Long aclId) throws Exception {
        return AclUserResolver.resolveAcl(aclId, directoryObject.getId());
    }

    public static long resolveAcl(DirectoryObjectClientBean directoryObject, AccessControlListObjectClientBean acl) throws Exception {
        return AclUserResolver.resolveAcl(acl.getId(), directoryObject.getId());
    }

    public static long getEffectiveAccess(DirectoryObjectClientBean directoryObject, long[] aclIds) throws Exception {
        SessionController sc = directoryObject.getSessionController();
        boolean isReadOnly = sc.getReadOnlyMode() || directoryObject instanceof DirectoryUserObjectClientBean && ((DirectoryUserObjectClientBean)directoryObject).getReadOnlyMode();
        boolean isAdmin = false;
        boolean isMainAdmin = false;
        if (directoryObject instanceof DirectoryUserObjectClientBean) {
            isAdmin = ((DirectoryUserObjectClientBean)directoryObject).getAdminenabled();
            isMainAdmin = sc.isMainAdmin(directoryObject.getId(), directoryObject.getId());
        }
        if (isMainAdmin) {
            return 0xFFFFFFFFL;
        }
        long effAccessLevel = 0L;
        if (aclIds != null) {
            for (long id : aclIds) {
                AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)sc.getGlobalObjectById(id);
                if (!isAdmin || acl.getAdminsAffected()) {
                    effAccessLevel |= AclUserResolver.resolveAcl(directoryObject, (Long)id);
                    continue;
                }
                effAccessLevel |= 0xFFFFFFFFL;
            }
        }
        if (isReadOnly) {
            effAccessLevel &= 5L;
        }
        return effAccessLevel;
    }

    public static boolean checkEffectiveAccess(DirectoryObjectClientBean directoryObject, long[] acl, long accessLevel) throws Exception {
        return (AclUserResolver.getEffectiveAccess(directoryObject, acl) & accessLevel) == accessLevel;
    }

    private static long mergeLevels(SessionController scAdmin, boolean isGranted, long member, DirectoryObjectClientBean directoryObject, long accessLevel, long newAccessLevel) throws Exception {
        if (member == directoryObject.getId() || scAdmin.isWorldGroup(member)) {
            accessLevel = isGranted ? (accessLevel |= newAccessLevel) : (accessLevel &= newAccessLevel ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return accessLevel;
    }

    public void resolveAffectedAcls(DirectoryGroupObjectClientBean group) throws Exception {
        SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(group.getSessionController(), "UserAdminTmpMode");
        AccessControlListObjectClientBean[] aclArr = this.getAffectedAcls(scAdmin, group = (DirectoryGroupObjectClientBean)scAdmin.getGlobalObjectById(group.getId()));
        if (aclArr != null) {
            for (AccessControlListObjectClientBean accessControlListObjectClientBean : aclArr) {
                this.resolveAcl(accessControlListObjectClientBean);
            }
        }
    }

    private Set<Long> getUserRevokeHash(Long aclId) {
        return this.aclRevokeHash.computeIfAbsent(aclId, k -> new HashSet());
    }

    private Map<Long, Long> getUserHash(Long aclId) {
        return this.aclHash.computeIfAbsent(aclId, k -> new HashMap());
    }

    public static void fillAffectedGroupsFromGroup(DirectoryGroupObjectClientBean group, List<DirectoryObjectClientBean> vAllGroup) throws Exception {
        vAllGroup.add(group);
        RelationObjectClientBean[] relArr = group.getLeftwardRelations(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (relArr != null) {
            for (RelationObjectClientBean relationObjectClientBean : relArr) {
                DirectoryGroupObjectClientBean dgcb = (DirectoryGroupObjectClientBean)relationObjectClientBean.getLeftObject();
                if (dgcb != null) {
                    AclUserResolver.fillAffectedGroupsFromGroup(dgcb, vAllGroup);
                    continue;
                }
                ExceptionUtils.handleException("No access to all groups you needed", "agorum.roi.remote.exception.NoAccessToAllGroups", 303);
            }
        }
    }

    private AccessControlListObjectClientBean[] getAffectedAcls(SessionController scAdmin, DirectoryGroupObjectClientBean group) throws Exception {
        int i;
        long t1 = System.currentTimeMillis();
        AccessControlListObjectClientBean[] aclRet = null;
        ArrayList<DirectoryObjectClientBean> vAllGroup = new ArrayList<DirectoryObjectClientBean>();
        AclUserResolver.fillAffectedGroupsFromGroup(group, vAllGroup);
        System.err.println("getAffectedAcls fillAffectedGroupsFromGroup Time :" + (System.currentTimeMillis() - t1));
        int len = vAllGroup.size();
        ClassObjectClientBean co = scAdmin.getClassObject(AccessControlEntryObjectClientBean.CLASS_NAME);
        ArrayList<AccessControlListObjectClientBean> vAllAcl = new ArrayList<AccessControlListObjectClientBean>();
        HashMap<Long, String> selectedAcls = new HashMap<Long, String>();
        for (i = 0; i < len; ++i) {
            SuperObjectClientBean[] socb = scAdmin.getSuperObjectByAttribute(scAdmin, AccessControlEntryObjectClientBean.GRANTEE_ATTRIBUTE, vAllGroup.get(i), false, co);
            if (socb == null) continue;
            int len1 = socb.length;
            for (int j = 0; j < len1; ++j) {
                AccessControlEntryObjectClientBean entry = (AccessControlEntryObjectClientBean)socb[j];
                AccessControlListObjectClientBean acl = entry.getAcl();
                if (acl == null || selectedAcls.containsKey(acl.getId())) continue;
                vAllAcl.add(acl);
                selectedAcls.put(acl.getId(), "");
            }
        }
        len = vAllAcl.size();
        if (len > 0) {
            aclRet = new AccessControlListObjectClientBean[len];
            for (i = 0; i < len; ++i) {
                aclRet[i] = (AccessControlListObjectClientBean)vAllAcl.get(i);
            }
        }
        System.err.println("getAffectedAcls Time : " + (System.currentTimeMillis() - t1));
        return aclRet;
    }

    private void resolveAclGroup(AccessControlListObjectClientBean acl, DirectoryGroupObjectClientBean group, boolean isGranted, long accessLevel) throws Exception {
        long t1 = System.currentTimeMillis();
        Set<Long> allUsers = group.getAllUserMembersDirect(acl.getSessionController());
        if (allUsers != null) {
            for (Long userId : allUsers) {
                this.resolveAclUser(acl, userId, isGranted, accessLevel);
            }
        }
        System.err.println("resolveAclGroup time : " + (System.currentTimeMillis() - t1));
    }

    private void resolveAclUser(AccessControlListObjectClientBean acl, Long userId, boolean isGranted, long accessLevel) {
        Long aclId = acl.getId();
        Map<Long, Long> userHash = this.getUserHash(aclId);
        Set<Long> userRevokeHash = this.getUserRevokeHash(aclId);
        Long al = userHash.get(userId);
        if (al == null) {
            if (isGranted) {
                userHash.put(userId, accessLevel);
                userRevokeHash.remove(userId);
            } else {
                userRevokeHash.add(userId);
            }
        } else {
            userHash.put(userId, isGranted ? al | accessLevel : al & (accessLevel ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(SessionController sessionController) throws Exception {
        ConnectionUtils connectionUtils = null;
        long t1 = System.currentTimeMillis();
        connectionUtils = new ConnectionUtils(sessionController);
        try (Connection conn = connectionUtils.getConnection();){
            for (Map.Entry<Long, Map<Long, Long>> entry : this.aclHash.entrySet()) {
                Object rSet;
                Long aclId = entry.getKey();
                Map<Long, Long> userHash = entry.getValue();
                Set<Long> userRevokeHash = this.getUserRevokeHash(aclId);
                HashSet<Long> curAclUserSet = new HashSet<Long>();
                try (PreparedStatement pstmt = conn.prepareStatement("select userid from ACLUSERTABLE where ACLID = ?");){
                    pstmt.setLong(1, aclId);
                    rSet = pstmt.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (rSet.next()) {
                            curAclUserSet.add(rSet.getLong(1));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rSet != null) {
                            if (throwable != null) {
                                try {
                                    rSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rSet.close();
                            }
                        }
                    }
                }
                HashSet<Long> curAclUserRevokeSet = new HashSet<Long>();
                PreparedStatement pstmt = conn.prepareStatement("select userid from ACLUSERREVOKE where ACLID = ?");
                rSet = null;
                try {
                    pstmt.setLong(1, aclId);
                    ResultSet rSet2 = pstmt.executeQuery();
                    Object object = null;
                    try {
                        while (rSet2.next()) {
                            curAclUserRevokeSet.add(rSet2.getLong(1));
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rSet2 != null) {
                            if (object != null) {
                                try {
                                    rSet2.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                rSet2.close();
                            }
                        }
                    }
                }
                catch (Throwable rSet2) {
                    rSet = rSet2;
                    throw rSet2;
                }
                finally {
                    if (pstmt != null) {
                        if (rSet != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable rSet2) {
                                ((Throwable)rSet).addSuppressed(rSet2);
                            }
                        } else {
                            pstmt.close();
                        }
                    }
                }
                HashSet<Long> aclUserToRevokeAddSet = new HashSet<Long>();
                boolean isWorldGroup = false;
                HashSet<Long> aclUserToAddSet = new HashSet<Long>();
                if (userHash.size() == 0) {
                    aclUserToAddSet.add(0L);
                }
                for (Map.Entry entry2 : userHash.entrySet()) {
                    long userId = (Long)entry2.getKey();
                    long al = (Long)entry2.getValue();
                    if ((al & 1L) != 0L) {
                        if (userId == 999L) {
                            isWorldGroup = true;
                            continue;
                        }
                        aclUserToAddSet.add(userId);
                        continue;
                    }
                    userRevokeHash.add(userId);
                }
                if (isWorldGroup) {
                    aclUserToAddSet.clear();
                    aclUserToAddSet.add(999L);
                    aclUserToAddSet.add(0L);
                    aclUserToRevokeAddSet.addAll(userRevokeHash);
                }
                HashSet<Long> aclUserToDelSet = new HashSet<Long>();
                HashSet<Long> hashSet = new HashSet<Long>();
                for (Long userId : curAclUserSet) {
                    if (aclUserToAddSet.remove(userId)) continue;
                    aclUserToDelSet.add(userId);
                }
                for (Long userId : curAclUserRevokeSet) {
                    if (aclUserToRevokeAddSet.remove(userId)) continue;
                    hashSet.add(userId);
                }
                try (PreparedStatement pstmt2 = conn.prepareStatement("insert into ACLUSERTABLE (ACLID, USERID) values (?, ?)");){
                    for (Long userId : aclUserToAddSet) {
                        pstmt2.setLong(1, aclId);
                        pstmt2.setLong(2, userId);
                        System.out.println("AclUserResolver: add: " + aclId + ", " + userId);
                        pstmt2.addBatch();
                    }
                    pstmt2.executeBatch();
                }
                pstmt2 = conn.prepareStatement("insert into ACLUSERREVOKE (ACLID, USERID) values (?, ?)");
                userId = null;
                try {
                    for (Long userId : aclUserToRevokeAddSet) {
                        pstmt2.setLong(1, aclId);
                        pstmt2.setLong(2, userId);
                        System.out.println("AclUserResolver: revoke: " + aclId + ", " + userId);
                        pstmt2.addBatch();
                    }
                    pstmt2.executeBatch();
                }
                catch (Throwable al) {
                    userId = al;
                    throw al;
                }
                finally {
                    if (pstmt2 != null) {
                        if (userId != null) {
                            try {
                                pstmt2.close();
                            }
                            catch (Throwable al) {
                                userId.addSuppressed(al);
                            }
                        } else {
                            pstmt2.close();
                        }
                    }
                }
                pstmt2 = conn.prepareStatement("delete from ACLUSERTABLE where aclid=? and userid=?");
                userId = null;
                try {
                    for (Long userId : aclUserToDelSet) {
                        pstmt2.setLong(1, aclId);
                        pstmt2.setLong(2, userId);
                        System.out.println("AclUserResolver: remove: " + aclId + ", " + userId);
                        pstmt2.addBatch();
                    }
                    pstmt2.executeBatch();
                }
                catch (Throwable al) {
                    userId = al;
                    throw al;
                }
                finally {
                    if (pstmt2 != null) {
                        if (userId != null) {
                            try {
                                pstmt2.close();
                            }
                            catch (Throwable al) {
                                userId.addSuppressed(al);
                            }
                        } else {
                            pstmt2.close();
                        }
                    }
                }
                pstmt2 = conn.prepareStatement("delete from ACLUSERREVOKE where aclid=? and userid=?");
                userId = null;
                try {
                    for (Long userId : hashSet) {
                        pstmt2.setLong(1, aclId);
                        pstmt2.setLong(2, userId);
                        System.out.println("AclUserResolver: remove revoke: " + aclId + ", " + userId);
                        pstmt2.addBatch();
                    }
                    pstmt2.executeBatch();
                }
                catch (Throwable al) {
                    userId = al;
                    throw al;
                }
                finally {
                    if (pstmt2 != null) {
                        if (userId != null) {
                            try {
                                pstmt2.close();
                            }
                            catch (Throwable al) {
                                userId.addSuppressed(al);
                            }
                        } else {
                            pstmt2.close();
                        }
                    }
                }
                ConnectionUtils cu = new ConnectionUtils(sessionController);
                Connection sqlConn = cu.getConnection();
                Object al = null;
                try {
                    PreparedStatement pstmt3 = sqlConn.prepareStatement("select aclid, userid from ACLADMINREVOKE where aclid=?");
                    Object object = null;
                    try {
                        pstmt3.setLong(1, aclId);
                        try (ResultSet rSet3 = pstmt3.executeQuery();){
                            while (rSet3.next()) {
                                PreparedStatement pstmtDel;
                                block196: {
                                    long delAclId = rSet3.getLong(1);
                                    long delUserId = rSet3.getLong(2);
                                    pstmtDel = sqlConn.prepareStatement("delete from ACLADMINREVOKE where aclid=? and userid=?");
                                    Throwable throwable = null;
                                    try {
                                        pstmtDel.setLong(1, delAclId);
                                        pstmtDel.setLong(2, delUserId);
                                        pstmtDel.execute();
                                        if (pstmtDel == null) continue;
                                        if (throwable == null) break block196;
                                    }
                                    catch (Throwable throwable4) {
                                        try {
                                            throwable = throwable4;
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            if (pstmtDel == null) throw throwable5;
                                            if (throwable == null) {
                                                pstmtDel.close();
                                                throw throwable5;
                                            }
                                            try {
                                                pstmtDel.close();
                                                throw throwable5;
                                            }
                                            catch (Throwable throwable6) {
                                                throwable.addSuppressed(throwable6);
                                                throw throwable5;
                                            }
                                        }
                                    }
                                    try {
                                        pstmtDel.close();
                                        continue;
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                        continue;
                                    }
                                }
                                pstmtDel.close();
                            }
                        }
                    }
                    catch (Throwable rSet3) {
                        object = rSet3;
                        throw rSet3;
                    }
                    finally {
                        if (pstmt3 != null) {
                            if (object != null) {
                                try {
                                    pstmt3.close();
                                }
                                catch (Throwable rSet3) {
                                    ((Throwable)object).addSuppressed(rSet3);
                                }
                            } else {
                                pstmt3.close();
                            }
                        }
                    }
                }
                catch (Throwable pstmt3) {
                    al = pstmt3;
                    throw pstmt3;
                }
                finally {
                    if (sqlConn != null) {
                        if (al != null) {
                            try {
                                sqlConn.close();
                            }
                            catch (Throwable pstmt3) {
                                ((Throwable)al).addSuppressed(pstmt3);
                            }
                        } else {
                            sqlConn.close();
                        }
                    }
                }
                boolean isAdminAffectingAcl = GlobalObjectEJB.isAdminAffectedAcl(sessionController, aclId);
                if (!isAdminAffectingAcl) continue;
                List<Long> allAdminUsers = this.getAllAdminUsers(sessionController);
                ArrayList<Long> adminsToAdd = new ArrayList<Long>();
                for (Long adminId : allAdminUsers) {
                    boolean seesAcl = AclUserResolver.seesAcl(sessionController, adminId, aclId);
                    if (seesAcl) continue;
                    adminsToAdd.add(adminId);
                }
                if (adminsToAdd.isEmpty()) continue;
                cu = new ConnectionUtils(sessionController);
                Connection sqlConn2 = cu.getConnection();
                Throwable throwable = null;
                try {
                    for (Long adminId : adminsToAdd) {
                        PreparedStatement pstmt4 = sqlConn2.prepareStatement("insert into ACLADMINREVOKE (ACLID, USERID) values (?, ?)");
                        Throwable throwable8 = null;
                        try {
                            pstmt4.setLong(1, aclId);
                            pstmt4.setLong(2, adminId);
                            pstmt4.execute();
                        }
                        catch (Throwable throwable9) {
                            throwable8 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (pstmt4 == null) continue;
                            if (throwable8 != null) {
                                try {
                                    pstmt4.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable8.addSuppressed(throwable10);
                                }
                                continue;
                            }
                            pstmt4.close();
                        }
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (sqlConn2 == null) continue;
                    if (throwable != null) {
                        try {
                            sqlConn2.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    sqlConn2.close();
                }
            }
        }
        System.out.println("execute Time : " + (System.currentTimeMillis() - t1));
    }

    private static boolean seesAcl(SessionController sessionController, Long userId, Long aclId) throws SQLException {
        long count2;
        Throwable throwable;
        ResultSet rSet2;
        Throwable throwable2;
        PreparedStatement pstmt;
        boolean seesAcl = false;
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection conn = cu.getConnection();){
            pstmt = conn.prepareStatement("select count(userid) from ACLUSERTABLE where aclid=? and (userid=? or userid=999)");
            throwable2 = null;
            try {
                pstmt.setLong(1, aclId);
                pstmt.setLong(2, userId);
                rSet2 = pstmt.executeQuery();
                throwable = null;
                try {
                    if (rSet2.next() && (count2 = rSet2.getLong(1)) > 0L) {
                        seesAcl = true;
                    }
                }
                catch (Throwable count2) {
                    throwable = count2;
                    throw count2;
                }
                finally {
                    if (rSet2 != null) {
                        if (throwable != null) {
                            try {
                                rSet2.close();
                            }
                            catch (Throwable count2) {
                                throwable.addSuppressed(count2);
                            }
                        } else {
                            rSet2.close();
                        }
                    }
                }
            }
            catch (Throwable rSet2) {
                throwable2 = rSet2;
                throw rSet2;
            }
            finally {
                if (pstmt != null) {
                    if (throwable2 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable rSet2) {
                            throwable2.addSuppressed(rSet2);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
        }
        if (seesAcl) {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            var6_6 = null;
            try {
                pstmt = conn.prepareStatement("select count(userid) from ACLUSERREVOKE where aclid=? and userid=?");
                throwable2 = null;
                try {
                    pstmt.setLong(1, aclId);
                    pstmt.setLong(2, userId);
                    rSet2 = pstmt.executeQuery();
                    throwable = null;
                    try {
                        if (rSet2.next() && (count2 = rSet2.getLong(1)) > 0L) {
                            seesAcl = false;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rSet2 != null) {
                            if (throwable != null) {
                                try {
                                    rSet2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                rSet2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt != null) {
                        if (throwable2 != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            pstmt.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                var6_6 = throwable7;
                throw throwable7;
            }
            finally {
                if (conn != null) {
                    if (var6_6 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable8) {
                            var6_6.addSuppressed(throwable8);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        return seesAcl;
    }

    public static void resolveAdminAffectedAcls(SessionController sessionController) throws Exception {
        ClassObjectClientBean co = sessionController.getClassObject(AccessControlListObjectClientBean.CLASS_NAME);
        SuperObjectClientBean[] acls = sessionController.getSuperObjectByAttribute(sessionController, AccessControlListObjectClientBean.ADMINSAFFECTED_ATTRIBUTE, true, false, co);
        if (acls != null) {
            for (SuperObjectClientBean acl : acls) {
                sessionController.resolveAcl((AccessControlListObjectClientBean)acl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeAdminAffectedAcls(SessionController sessionController, DirectoryUserObjectClientBean user) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection sqlConn = cu.getConnection();
             PreparedStatement pstmt = sqlConn.prepareStatement("select aclid, userid from ACLADMINREVOKE where userid=?");){
            pstmt.setLong(1, user.getId());
            try (ResultSet rSet = pstmt.executeQuery();){
                while (rSet.next()) {
                    PreparedStatement pstmtDel;
                    block46: {
                        long delAclId = rSet.getLong(1);
                        long delUserId = rSet.getLong(2);
                        pstmtDel = sqlConn.prepareStatement("delete from ACLADMINREVOKE where aclid=? and userid=?");
                        Throwable throwable = null;
                        try {
                            pstmtDel.setLong(1, delAclId);
                            pstmtDel.setLong(2, delUserId);
                            pstmtDel.execute();
                            if (pstmtDel == null) continue;
                            if (throwable == null) break block46;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (pstmtDel == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        pstmtDel.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                pstmtDel.close();
                                throw throwable3;
                            }
                        }
                        try {
                            pstmtDel.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    pstmtDel.close();
                }
                return;
            }
        }
    }

    private List<Long> getAllAdminUsers(SessionController sessionController) throws Exception {
        if (this.allAdminUsers == null) {
            this.allAdminUsers = new ArrayList<Long>();
            ClassObjectClientBean co = sessionController.getClassObject(DirectoryUserObjectClientBean.CLASS_NAME);
            SuperObjectClientBean[] admins = sessionController.getSuperObjectByAttribute(sessionController, DirectoryUserObjectClientBean.ADMINENABLED_ATTRIBUTE, true, false, co);
            if (admins != null) {
                for (SuperObjectClientBean admin : admins) {
                    if (admin.getId().equals(11000L)) continue;
                    this.allAdminUsers.add(admin.getId());
                }
            }
        }
        return this.allAdminUsers;
    }

    private static long combineAccessLevels(PermissionBundleObjectClientBean[] pbArr) throws Exception {
        long accessLevel = 0L;
        int len = pbArr.length;
        for (int i = 0; i < len; ++i) {
            long al = pbArr[i].getAccessLevel();
            accessLevel |= al;
        }
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAcl(AccessControlListObjectClientBean acl) throws Exception {
        Connection conn = null;
        ConnectionUtils connectionUtils = null;
        Statement pstmt = null;
        try {
            connectionUtils = new ConnectionUtils(acl.getSessionController());
            conn = connectionUtils.getConnection();
            long aclId = acl.getId();
            pstmt = conn.prepareStatement("delete from ACLUSERTABLE where ACLID = ?");
            pstmt.setLong(1, aclId);
            pstmt.execute();
            pstmt.close();
            pstmt = conn.prepareStatement("delete from ACLUSERREVOKE where ACLID = ?");
            pstmt.setLong(1, aclId);
            pstmt.execute();
            pstmt.close();
            pstmt = conn.prepareStatement("delete from ACLADMINREVOKE where ACLID = ?");
            pstmt.setLong(1, aclId);
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                connectionUtils.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public static void removeAllEntrysFromDirectoryObject(DirectoryObjectClientBean docb) throws Exception {
        SuperObjectClientBean[] socb = docb.getSessionController().getSuperObjectByAttribute(docb.getSessionController(), AccessControlEntryObjectClientBean.GRANTEE_ATTRIBUTE, docb, false, docb.getSessionController().getClassObject(AccessControlEntryObjectClientBean.CLASS_NAME));
        if (socb != null) {
            int len = socb.length;
            for (int i = 0; i < len; ++i) {
                AccessControlEntryObjectClientBean entry = (AccessControlEntryObjectClientBean)socb[i];
                AccessControlListObjectClientBean acl = entry.getAcl();
                if (acl != null) {
                    acl.removeAccessControlEntryObject(entry);
                    continue;
                }
                ExceptionUtils.handleException("No access to all ACLs you needed", "agorum.roi.remote.exception.NoAccessToAllAcl", 403);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.execute(this.sessionController);
    }
}

