/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

public class AccessLevel {
    public static final long ACCESSLEVEL_NONE = 0L;
    public static final long ACCESSLEVEL_ALL = 0xFFFFFFL;
    public static final long ACCESSLEVEL_DISCOVER = 1L;
    public static final long ACCESSLEVEL_SET_ATTR = 2L;
    public static final long ACCESSLEVEL_GET_CONTENT = 4L;
    public static final long ACCESSLEVEL_SET_CONTENT = 8L;
    public static final long ACCESSLEVEL_DELETE = 16L;
    public static final long ACCESSLEVEL_LOCK = 32L;
    public static final long ACCESSLEVEL_GRANT = 64L;
    public static final long ACCESSLEVEL_CREATE = 128L;
    public static final long ACCESSLEVEL_SELECTORACCESS = 256L;
    public static final long ACCESSLEVEL_ADDMEMBER = 4096L;
    public static final long ACCESSLEVEL_REMOVEMEMBER = 8192L;
    public static final long ACCESSLEVEL_ADDITEM = 16384L;
    public static final long ACCESSLEVEL_REMOVEITEM = 32768L;
    public static final long ACCESSLEVEL_ADDRELATIONSHIP = 65536L;
    public static final long ACCESSLEVEL_REMOVERELATIONSHIP = 131072L;
    public static final long ACCESSLEVEL_ADDVERSIONSERIES = 262144L;
    public static final long ACCESSLEVEL_REMOVEVERSIONSERIES = 524288L;
    public static final long ACCESSLEVEL_ADDVERSION = 0x100000L;
    public static final long ACCESSLEVEL_REMOVEVERSION = 0x200000L;
    public static final long ACCESSLEVEL_SETDEFAULTVERSION = 0x400000L;
    public static final long ACCESSLEVEL_SETPOLICY = 0x800000L;
    public static final long ACCESSLEVEL_CHECK_OUT = 1048613L;
    public static final long ACCESSLEVEL_WRITE = 12583034L;
    private long accessLevel = 0L;

    public AccessLevel(long accessLevel) {
        this.accessLevel = accessLevel;
    }

    public AccessLevel() {
        this.accessLevel = 0L;
    }

    public void addPermission(long newPermission) {
        this.accessLevel |= newPermission;
    }

    public void removePermission(long remPermission) {
        this.accessLevel &= remPermission ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long getEffectiveLevel() {
        return this.accessLevel;
    }

    public static long getAccessLevel(String accessLevelName) {
        long accesslevel = 0L;
        if (accessLevelName != null) {
            if (accessLevelName.equalsIgnoreCase("All")) {
                accesslevel = 0xFFFFFFL;
            } else if (accessLevelName.equalsIgnoreCase("Discover")) {
                accesslevel = 1L;
            } else if (accessLevelName.equalsIgnoreCase("SetAttribute")) {
                accesslevel = 2L;
            } else if (accessLevelName.equalsIgnoreCase("GetContent")) {
                accesslevel = 4L;
            } else if (accessLevelName.equalsIgnoreCase("SetContent")) {
                accesslevel = 8L;
            } else if (accessLevelName.equalsIgnoreCase("Delete")) {
                accesslevel = 16L;
            } else if (accessLevelName.equalsIgnoreCase("Lock")) {
                accesslevel = 32L;
            } else if (accessLevelName.equalsIgnoreCase("Grant")) {
                accesslevel = 64L;
            } else if (accessLevelName.equalsIgnoreCase("Create")) {
                accesslevel = 128L;
            } else if (accessLevelName.equalsIgnoreCase("SelectOrAccess")) {
                accesslevel = 256L;
            } else if (accessLevelName.equalsIgnoreCase("AddMember")) {
                accesslevel = 4096L;
            } else if (accessLevelName.equalsIgnoreCase("RemoveMember")) {
                accesslevel = 8192L;
            } else if (accessLevelName.equalsIgnoreCase("AddItem")) {
                accesslevel = 16384L;
            } else if (accessLevelName.equalsIgnoreCase("RemoveItem")) {
                accesslevel = 32768L;
            } else if (accessLevelName.equalsIgnoreCase("AddRelationship")) {
                accesslevel = 65536L;
            } else if (accessLevelName.equalsIgnoreCase("RemoveRelationship")) {
                accesslevel = 131072L;
            } else if (accessLevelName.equalsIgnoreCase("AddVersionSeries")) {
                accesslevel = 262144L;
            } else if (accessLevelName.equalsIgnoreCase("RemoveVersionServies")) {
                accesslevel = 524288L;
            } else if (accessLevelName.equalsIgnoreCase("AddVersion")) {
                accesslevel = 0x100000L;
            } else if (accessLevelName.equalsIgnoreCase("RemoveVersion")) {
                accesslevel = 0x200000L;
            } else if (accessLevelName.equalsIgnoreCase("SetDefaultVersion")) {
                accesslevel = 0x400000L;
            } else if (accessLevelName.equalsIgnoreCase("SetPolicy")) {
                accesslevel = 0x800000L;
            } else if (accessLevelName.equalsIgnoreCase("AG_PB_ALL")) {
                accesslevel = AccessLevel.getAccessLevel("Delete");
            } else if (accessLevelName.equalsIgnoreCase("AG_PB_WRITE")) {
                accesslevel = AccessLevel.getAccessLevel("SetAttribute");
            } else if (accessLevelName.equalsIgnoreCase("AG_PB_PROTECTED")) {
                accesslevel = AccessLevel.getAccessLevel("AddItem");
            } else if (accessLevelName.equalsIgnoreCase("AG_PB_CHECK_OUT")) {
                accesslevel = AccessLevel.getAccessLevel("AddVersion");
            } else if (accessLevelName.equalsIgnoreCase("AG_PB_READ")) {
                accesslevel = AccessLevel.getAccessLevel("Discover");
            }
        }
        return accesslevel;
    }
}

