/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.commons.logging.TimeSpanLogger;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.AttributeXMLObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.statistic.searchengine.IndexStatistic;

public class AXOCache {
    private static final IndexStatistic statIndex = IndexStatistic.getInstance();

    private static GenericCache getCache(Long sessionId) {
        return GenericCache.getInstance((Object)(sessionId + "_AXOCache"), (int)100000, (int)1000, (int)500);
    }

    public static AttributeXMLObjectClientBean[] get(GlobalObjectClientBean obj) throws Exception {
        GenericCache cache = AXOCache.getCache(obj.getSessionController().getSessionId());
        AttributeXMLObjectClientBean[] axos = (AttributeXMLObjectClientBean[])cache.get((Object)obj.getId());
        if (axos == null) {
            statIndex.count("AXOCache miss", 1L);
            try (TimeSpanLogger.Auto tsl = new TimeSpanLogger((Statistic)statIndex).name("AXOS: get").objectId(obj.getId()).logAs("DEBUG").alertAs("WARNING").alertAt(300L).measurement().auto();){
                axos = obj.getAllAttributeXmlObjects(true, true, false);
                if (axos == null) {
                    axos = new AttributeXMLObjectClientBean[]{};
                }
                cache.put((Object)obj.getId(), (Object)axos);
            }
        } else {
            statIndex.count("AXOCache hit", 1L);
        }
        return axos;
    }

    public static void invalidate(Long sessionId) {
        AXOCache.getCache(sessionId).invalidateCache();
    }
}

