/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import java.io.File;
import java.io.RandomAccessFile;

public class TestFindAllSetClientInfo {
    public void run(String startPath) throws Exception {
        File f = new File(startPath);
        if (!f.exists()) {
            throw new Exception("SourcePath does not exist");
        }
        if (!f.isDirectory()) {
            throw new Exception("SourcePath is not a Directory");
        }
        this.runRecursive(f);
    }

    private void runRecursive(File f) throws Exception {
        File[] myList = f.listFiles();
        if (myList != null) {
            int len = myList.length;
            for (int i = 0; i < len; ++i) {
                if (myList[i].isDirectory()) {
                    this.runRecursive(myList[i]);
                    continue;
                }
                if (!myList[i].isFile() || !myList[i].getName().endsWith(".java")) continue;
                RandomAccessFile raf = new RandomAccessFile(myList[i], "r");
                String line = null;
                boolean found = false;
                while ((line = raf.readLine()) != null) {
                    if (line.indexOf(".setModulInfo(") < 0) continue;
                    System.err.println(myList[i].getAbsolutePath() + "\n  " + line);
                }
                raf.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: TestFindAllSetClientInfo <StartPath>\nSample:\nTestFindAllSetClientInfo C:\\projekte\\cvs\\agorum");
        } else {
            try {
                TestFindAllSetClientInfo testFindAllSetClientInfo = new TestFindAllSetClientInfo();
                testFindAllSetClientInfo.run(args[0]);
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            System.err.println("program end");
        }
    }
}

